% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worklink_operations.R
\name{worklink_describe_device}
\alias{worklink_describe_device}
\title{Provides information about a user's device}
\usage{
worklink_describe_device(FleetArn, DeviceId)
}
\arguments{
\item{FleetArn}{[required] The ARN of the fleet.}

\item{DeviceId}{[required] A unique identifier for a registered user's device.}
}
\value{
A list with the following syntax:\preformatted{list(
  Status = "ACTIVE"|"SIGNED_OUT",
  Model = "string",
  Manufacturer = "string",
  OperatingSystem = "string",
  OperatingSystemVersion = "string",
  PatchLevel = "string",
  FirstAccessedTime = as.POSIXct(
    "2015-01-01"
  ),
  LastAccessedTime = as.POSIXct(
    "2015-01-01"
  ),
  Username = "string"
)
}
}
\description{
Provides information about a user's device.
}
\section{Request syntax}{
\preformatted{svc$describe_device(
  FleetArn = "string",
  DeviceId = "string"
)
}
}

\keyword{internal}
