% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_create_user}
\alias{workdocs_create_user}
\title{Creates a user in a Simple AD or Microsoft AD directory}
\usage{
workdocs_create_user(OrganizationId, Username, EmailAddress, GivenName,
  Surname, Password, TimeZoneId, StorageRule, AuthenticationToken)
}
\arguments{
\item{OrganizationId}{The ID of the organization.}

\item{Username}{[required] The login name of the user.}

\item{EmailAddress}{The email address of the user.}

\item{GivenName}{[required] The given name of the user.}

\item{Surname}{[required] The surname of the user.}

\item{Password}{[required] The password of the user.}

\item{TimeZoneId}{The time zone ID of the user.}

\item{StorageRule}{The amount of storage for the user.}

\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}
}
\value{
A list with the following syntax:\preformatted{list(
  User = list(
    Id = "string",
    Username = "string",
    EmailAddress = "string",
    GivenName = "string",
    Surname = "string",
    OrganizationId = "string",
    RootFolderId = "string",
    RecycleBinFolderId = "string",
    Status = "ACTIVE"|"INACTIVE"|"PENDING",
    Type = "USER"|"ADMIN"|"POWERUSER"|"MINIMALUSER"|"WORKSPACESUSER",
    CreatedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    ModifiedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    TimeZoneId = "string",
    Locale = "en"|"fr"|"ko"|"de"|"es"|"ja"|"ru"|"zh_CN"|"zh_TW"|"pt_BR"|"default",
    Storage = list(
      StorageUtilizedInBytes = 123,
      StorageRule = list(
        StorageAllocatedInBytes = 123,
        StorageType = "UNLIMITED"|"QUOTA"
      )
    )
  )
)
}
}
\description{
Creates a user in a Simple AD or Microsoft AD directory. The status of a
newly created user is "ACTIVE". New users can access Amazon WorkDocs.
}
\section{Request syntax}{
\preformatted{svc$create_user(
  OrganizationId = "string",
  Username = "string",
  EmailAddress = "string",
  GivenName = "string",
  Surname = "string",
  Password = "string",
  TimeZoneId = "string",
  StorageRule = list(
    StorageAllocatedInBytes = 123,
    StorageType = "UNLIMITED"|"QUOTA"
  ),
  AuthenticationToken = "string"
)
}
}

\keyword{internal}
