% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_create_custom_metadata}
\alias{workdocs_create_custom_metadata}
\title{Adds one or more custom properties to the specified resource (a folder,
document, or version)}
\usage{
workdocs_create_custom_metadata(AuthenticationToken, ResourceId,
  VersionId, CustomMetadata)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{ResourceId}{[required] The ID of the resource.}

\item{VersionId}{The ID of the version, if the custom metadata is being added to a
document version.}

\item{CustomMetadata}{[required] Custom metadata in the form of name-value pairs.}
}
\value{
An empty list.
}
\description{
Adds one or more custom properties to the specified resource (a folder,
document, or version).
}
\section{Request syntax}{
\preformatted{svc$create_custom_metadata(
  AuthenticationToken = "string",
  ResourceId = "string",
  VersionId = "string",
  CustomMetadata = list(
    "string"
  )
)
}
}

\keyword{internal}
