% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_tag_resource}
\alias{appstream_tag_resource}
\title{Adds or overwrites one or more tags for the specified AppStream 2}
\usage{
appstream_tag_resource(ResourceArn, Tags)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource.}

\item{Tags}{[required] The tags to associate. A tag is a key-value pair, and the value is
optional. For example, Environment=Test. If you do not specify a value,
Environment=.

If you do not specify a value, the value is set to an empty string.

Generally allowed characters are: letters, numbers, and spaces
representable in UTF-8, and the following special characters:

_ . : / = + \\ - @}
}
\value{
An empty list.
}
\description{
Adds or overwrites one or more tags for the specified AppStream 2.0
resource. You can tag AppStream 2.0 image builders, images, fleets, and
stacks.

Each tag consists of a key and an optional value. If a resource already
has a tag with the same key, this operation updates its value.

To list the current tags for your resources, use
\code{\link[=appstream_list_tags_for_resource]{list_tags_for_resource}}. To
disassociate tags from your resources, use
\code{\link[=appstream_untag_resource]{untag_resource}}.

For more information about tags, see \href{https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html}{Tagging Your Resources}
in the \emph{Amazon AppStream 2.0 Administration Guide}.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceArn = "string",
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
