% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_create_integration}
\alias{redshift_create_integration}
\title{Creates a zero-ETL integration or S3 event integration with Amazon
Redshift}
\usage{
redshift_create_integration(
  SourceArn,
  TargetArn,
  IntegrationName,
  KMSKeyId = NULL,
  TagList = NULL,
  AdditionalEncryptionContext = NULL,
  Description = NULL
)
}
\arguments{
\item{SourceArn}{[required] The Amazon Resource Name (ARN) of the database to use as the source for
replication.}

\item{TargetArn}{[required] The Amazon Resource Name (ARN) of the Amazon Redshift data warehouse to
use as the target for replication.}

\item{IntegrationName}{[required] The name of the integration.}

\item{KMSKeyId}{An Key Management Service (KMS) key identifier for the key to use to
encrypt the integration. If you don't specify an encryption key, the
default Amazon Web Services owned key is used.}

\item{TagList}{A list of tags.}

\item{AdditionalEncryptionContext}{An optional set of non-secret key–value pairs that contains additional
contextual information about the data. For more information, see
\href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context}{Encryption context}
in the \emph{Amazon Web Services Key Management Service Developer Guide}.

You can only include this parameter if you specify the \code{KMSKeyId}
parameter.}

\item{Description}{A description of the integration.}
}
\description{
Creates a zero-ETL integration or S3 event integration with Amazon Redshift.

See \url{https://www.paws-r-sdk.com/docs/redshift_create_integration/} for full documentation.
}
\keyword{internal}
