% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_apply_pending_maintenance_action}
\alias{rds_apply_pending_maintenance_action}
\title{Applies a pending maintenance action to a resource (for example, to a DB
instance)}
\usage{
rds_apply_pending_maintenance_action(
  ResourceIdentifier,
  ApplyAction,
  OptInType
)
}
\arguments{
\item{ResourceIdentifier}{[required] The RDS Amazon Resource Name (ARN) of the resource that the pending
maintenance action applies to. For information about creating an ARN,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing}{Constructing an RDS Amazon Resource Name (ARN)}.}

\item{ApplyAction}{[required] The pending maintenance action to apply to this resource.

Valid Values:
\itemize{
\item \code{ca-certificate-rotation}
\item \code{db-upgrade}
\item \code{hardware-maintenance}
\item \code{os-upgrade}
\item \code{system-update}
}

For more information about these actions, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#maintenance-actions-aurora}{Maintenance actions for Amazon Aurora}
or \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#maintenance-actions-rds}{Maintenance actions for Amazon RDS}.}

\item{OptInType}{[required] A value that specifies the type of opt-in request, or undoes an opt-in
request. An opt-in request of type \code{immediate} can't be undone.

Valid Values:
\itemize{
\item \code{immediate} - Apply the maintenance action immediately.
\item \code{next-maintenance} - Apply the maintenance action during the next
maintenance window for the resource.
\item \verb{undo-opt-in} - Cancel any existing \code{next-maintenance} opt-in
requests.
}}
}
\description{
Applies a pending maintenance action to a resource (for example, to a DB instance).

See \url{https://www.paws-r-sdk.com/docs/rds_apply_pending_maintenance_action/} for full documentation.
}
\keyword{internal}
