% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdbelastic_operations.R
\name{docdbelastic_update_cluster}
\alias{docdbelastic_update_cluster}
\title{Modifies an elastic cluster}
\usage{
docdbelastic_update_cluster(
  adminUserPassword = NULL,
  authType = NULL,
  backupRetentionPeriod = NULL,
  clientToken = NULL,
  clusterArn,
  preferredBackupWindow = NULL,
  preferredMaintenanceWindow = NULL,
  shardCapacity = NULL,
  shardCount = NULL,
  shardInstanceCount = NULL,
  subnetIds = NULL,
  vpcSecurityGroupIds = NULL
)
}
\arguments{
\item{adminUserPassword}{The password associated with the elastic cluster administrator. This
password can contain any printable ASCII character except forward slash
(/), double quote ("), or the "at" symbol (@).

\emph{Constraints}: Must contain from 8 to 100 characters.}

\item{authType}{The authentication type used to determine where to fetch the password
used for accessing the elastic cluster. Valid types are \code{PLAIN_TEXT} or
\code{SECRET_ARN}.}

\item{backupRetentionPeriod}{The number of days for which automatic snapshots are retained.}

\item{clientToken}{The client token for the elastic cluster.}

\item{clusterArn}{[required] The ARN identifier of the elastic cluster.}

\item{preferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled, as determined by the
\code{backupRetentionPeriod}.}

\item{preferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

\emph{Format}: \code{ddd:hh24:mi-ddd:hh24:mi}

\emph{Default}: a 30-minute window selected at random from an 8-hour block of
time for each Amazon Web Services Region, occurring on a random day of
the week.

\emph{Valid days}: Mon, Tue, Wed, Thu, Fri, Sat, Sun

\emph{Constraints}: Minimum 30-minute window.}

\item{shardCapacity}{The number of vCPUs assigned to each elastic cluster shard. Maximum is
64. Allowed values are 2, 4, 8, 16, 32, 64.}

\item{shardCount}{The number of shards assigned to the elastic cluster. Maximum is 32.}

\item{shardInstanceCount}{The number of replica instances applying to all shards in the elastic
cluster. A \code{shardInstanceCount} value of 1 means there is one writer
instance, and any additional instances are replicas that can be used for
reads and to improve availability.}

\item{subnetIds}{The Amazon EC2 subnet IDs for the elastic cluster.}

\item{vpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with the elastic cluster.}
}
\description{
Modifies an elastic cluster. This includes updating admin-username/password, upgrading the API version, and setting up a backup window and maintenance window

See \url{https://www.paws-r-sdk.com/docs/docdbelastic_update_cluster/} for full documentation.
}
\keyword{internal}
