% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_switchover_global_cluster}
\alias{rds_switchover_global_cluster}
\title{Switches over the specified secondary DB cluster to be the new primary
DB cluster in the global database cluster}
\usage{
rds_switchover_global_cluster(
  GlobalClusterIdentifier,
  TargetDbClusterIdentifier
)
}
\arguments{
\item{GlobalClusterIdentifier}{[required] The identifier of the global database cluster to switch over. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must match the identifier of an existing global database cluster
(Aurora global database).
}}

\item{TargetDbClusterIdentifier}{[required] The identifier of the secondary Aurora DB cluster to promote to the new
primary for the global database cluster. Use the Amazon Resource Name
(ARN) for the identifier so that Aurora can locate the cluster in its
Amazon Web Services Region.}
}
\description{
Switches over the specified secondary DB cluster to be the new primary DB cluster in the global database cluster. Switchover operations were previously called "managed planned failovers."

See \url{https://www.paws-r-sdk.com/docs/rds_switchover_global_cluster/} for full documentation.
}
\keyword{internal}
