% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_cluster_from_snapshot}
\alias{rds_restore_db_cluster_from_snapshot}
\title{Creates a new DB cluster from a DB snapshot or DB cluster snapshot}
\usage{
rds_restore_db_cluster_from_snapshot(
  AvailabilityZones = NULL,
  DBClusterIdentifier,
  SnapshotIdentifier,
  Engine,
  EngineVersion = NULL,
  Port = NULL,
  DBSubnetGroupName = NULL,
  DatabaseName = NULL,
  OptionGroupName = NULL,
  VpcSecurityGroupIds = NULL,
  Tags = NULL,
  KmsKeyId = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  BacktrackWindow = NULL,
  EnableCloudwatchLogsExports = NULL,
  EngineMode = NULL,
  ScalingConfiguration = NULL,
  DBClusterParameterGroupName = NULL,
  DeletionProtection = NULL,
  CopyTagsToSnapshot = NULL,
  Domain = NULL,
  DomainIAMRoleName = NULL,
  DBClusterInstanceClass = NULL,
  StorageType = NULL,
  Iops = NULL,
  PubliclyAccessible = NULL,
  ServerlessV2ScalingConfiguration = NULL,
  NetworkType = NULL,
  RdsCustomClusterConfiguration = NULL
)
}
\arguments{
\item{AvailabilityZones}{Provides the list of Availability Zones (AZs) where instances in the
restored DB cluster can be created.

Valid for: Aurora DB clusters only}

\item{DBClusterIdentifier}{[required] The name of the DB cluster to create from the DB snapshot or DB cluster
snapshot. This parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-snapshot-id}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{SnapshotIdentifier}{[required] The identifier for the DB snapshot or DB cluster snapshot to restore
from.

You can use either the name or the Amazon Resource Name (ARN) to specify
a DB cluster snapshot. However, you can use only the ARN to specify a DB
snapshot.

Constraints:
\itemize{
\item Must match the identifier of an existing Snapshot.
}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{Engine}{[required] The database engine to use for the new DB cluster.

Default: The same as source

Constraint: Must be compatible with the engine of the source

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{EngineVersion}{The version of the database engine to use for the new DB cluster. If you
don't specify an engine version, the default version for the database
engine in the Amazon Web Services Region is used.

To list all of the available engine versions for Aurora MySQL, use the
following command:

\verb{aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"}

To list all of the available engine versions for Aurora PostgreSQL, use
the following command:

\verb{aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"}

To list all of the available engine versions for RDS for MySQL, use the
following command:

\verb{aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"}

To list all of the available engine versions for RDS for PostgreSQL, use
the following command:

\verb{aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"}

\strong{Aurora MySQL}

See \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html}{Database engine updates for Amazon Aurora MySQL}
in the \emph{Amazon Aurora User Guide}.

\strong{Aurora PostgreSQL}

See \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html}{Amazon Aurora PostgreSQL releases and engine versions}
in the \emph{Amazon Aurora User Guide}.

\strong{MySQL}

See \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt}{Amazon RDS for MySQL}
in the \emph{Amazon RDS User Guide.}

\strong{PostgreSQL}

See \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts}{Amazon RDS for PostgreSQL versions and extensions}
in the \emph{Amazon RDS User Guide.}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{Port}{The port number on which the new DB cluster accepts connections.

Constraints: This value must be \code{1150-65535}

Default: The same port as the original DB cluster.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{DBSubnetGroupName}{The name of the DB subnet group to use for the new DB cluster.

Constraints: If supplied, must match the name of an existing DB subnet
group.

Example: \code{mydbsubnetgroup}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{DatabaseName}{The database name for the restored DB cluster.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{OptionGroupName}{The name of the option group to use for the restored DB cluster.

DB clusters are associated with a default option group that can't be
modified.}

\item{VpcSecurityGroupIds}{A list of VPC security groups that the new DB cluster will belong to.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{Tags}{The tags to be assigned to the restored DB cluster.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{KmsKeyId}{The Amazon Web Services KMS key identifier to use when restoring an
encrypted DB cluster from a DB snapshot or DB cluster snapshot.

The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
ARN, or alias name for the KMS key. To use a KMS key in a different
Amazon Web Services account, specify the key ARN or alias ARN.

When you don't specify a value for the \code{KmsKeyId} parameter, then the
following occurs:
\itemize{
\item If the DB snapshot or DB cluster snapshot in \code{SnapshotIdentifier} is
encrypted, then the restored DB cluster is encrypted using the KMS
key that was used to encrypt the DB snapshot or DB cluster snapshot.
\item If the DB snapshot or DB cluster snapshot in \code{SnapshotIdentifier}
isn't encrypted, then the restored DB cluster isn't encrypted.
}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{EnableIAMDatabaseAuthentication}{Specifies whether to enable mapping of Amazon Web Services Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping isn't enabled.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication}
in the \emph{Amazon Aurora User Guide}.

Valid for: Aurora DB clusters only}

\item{BacktrackWindow}{The target backtrack window, in seconds. To disable backtracking, set
this value to 0.

Currently, Backtrack is only supported for Aurora MySQL DB clusters.

Default: 0

Constraints:
\itemize{
\item If specified, this value must be set to a number from 0 to 259,200
(72 hours).
}

Valid for: Aurora DB clusters only}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB cluster is to export to Amazon
CloudWatch Logs. The values in the list depend on the DB engine being
used.

\strong{RDS for MySQL}

Possible values are \code{error}, \code{general}, and \code{slowquery}.

\strong{RDS for PostgreSQL}

Possible values are \code{postgresql} and \code{upgrade}.

\strong{Aurora MySQL}

Possible values are \code{audit}, \code{error}, \code{general}, and \code{slowquery}.

\strong{Aurora PostgreSQL}

Possible value is \code{postgresql}.

For more information about exporting CloudWatch Logs for Amazon RDS, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.

For more information about exporting CloudWatch Logs for Amazon Aurora,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon Aurora User Guide}.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{EngineMode}{The DB engine mode of the DB cluster, either \code{provisioned} or
\code{serverless}.

For more information, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html}{CreateDBCluster}.

Valid for: Aurora DB clusters only}

\item{ScalingConfiguration}{For DB clusters in \code{serverless} DB engine mode, the scaling properties
of the DB cluster.

Valid for: Aurora DB clusters only}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to associate with this DB
cluster. If this argument is omitted, the default DB cluster parameter
group for the specified engine is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing default DB cluster
parameter group.
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{DeletionProtection}{Specifies whether to enable deletion protection for the DB cluster. The
database can't be deleted when deletion protection is enabled. By
default, deletion protection isn't enabled.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{CopyTagsToSnapshot}{Specifies whether to copy all tags from the restored DB cluster to
snapshots of the restored DB cluster. The default is not to copy them.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{Domain}{The Active Directory directory ID to restore the DB cluster in. The
domain must be created prior to this operation. Currently, only MySQL,
Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created
in an Active Directory Domain.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon RDS User Guide}.

Valid for: Aurora DB clusters only}

\item{DomainIAMRoleName}{The name of the IAM role to be used when making API calls to the
Directory Service.

Valid for: Aurora DB clusters only}

\item{DBClusterInstanceClass}{The compute and memory capacity of the each DB instance in the Multi-AZ
DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are
available in all Amazon Web Services Regions, or for all database
engines.

For the full list of DB instance classes, and availability for your
engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB Instance Class}
in the \emph{Amazon RDS User Guide.}

Valid for: Multi-AZ DB clusters only}

\item{StorageType}{Specifies the storage type to be associated with the DB cluster.

When specified for a Multi-AZ DB cluster, a value for the \code{Iops}
parameter is required.

Valid Values: \code{aurora}, \code{aurora-iopt1} (Aurora DB clusters); \code{io1}
(Multi-AZ DB clusters)

Default: \code{aurora} (Aurora DB clusters); \code{io1} (Multi-AZ DB clusters)

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
be initially allocated for each DB instance in the Multi-AZ DB cluster.

For information about valid IOPS values, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS}{Amazon RDS Provisioned IOPS storage}
in the \emph{Amazon RDS User Guide}.

Constraints: Must be a multiple between .5 and 50 of the storage amount
for the DB instance.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{PubliclyAccessible}{Specifies whether the DB cluster is publicly accessible.

When the DB cluster is publicly accessible, its Domain Name System (DNS)
endpoint resolves to the private IP address from within the DB cluster's
virtual private cloud (VPC). It resolves to the public IP address from
outside of the DB cluster's VPC. Access to the DB cluster is ultimately
controlled by the security group it uses. That public access is not
permitted if the security group assigned to the DB cluster doesn't
permit it.

When the DB cluster isn't publicly accessible, it is an internal DB
cluster with a DNS name that resolves to a private IP address.

Default: The default behavior varies depending on whether
\code{DBSubnetGroupName} is specified.

If \code{DBSubnetGroupName} isn't specified, and \code{PubliclyAccessible} isn't
specified, the following applies:
\itemize{
\item If the default VPC in the target Region doesn’t have an internet
gateway attached to it, the DB cluster is private.
\item If the default VPC in the target Region has an internet gateway
attached to it, the DB cluster is public.
}

If \code{DBSubnetGroupName} is specified, and \code{PubliclyAccessible} isn't
specified, the following applies:
\itemize{
\item If the subnets are part of a VPC that doesn’t have an internet
gateway attached to it, the DB cluster is private.
\item If the subnets are part of a VPC that has an internet gateway
attached to it, the DB cluster is public.
}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{ServerlessV2ScalingConfiguration}{}

\item{NetworkType}{The network type of the DB cluster.

Valid Values:
\itemize{
\item \code{IPV4}
\item \code{DUAL}
}

The network type is determined by the \code{DBSubnetGroup} specified for the
DB cluster. A \code{DBSubnetGroup} can support only the IPv4 protocol or the
IPv4 and the IPv6 protocols (\code{DUAL}).

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html}{Working with a DB instance in a VPC}
in the \emph{Amazon Aurora User Guide.}

Valid for: Aurora DB clusters only}

\item{RdsCustomClusterConfiguration}{Reserved for future use.}
}
\description{
Creates a new DB cluster from a DB snapshot or DB cluster snapshot.

See \url{https://www.paws-r-sdk.com/docs/rds_restore_db_cluster_from_snapshot/} for full documentation.
}
\keyword{internal}
