% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_delete_db_cluster}
\alias{rds_delete_db_cluster}
\title{The DeleteDBCluster action deletes a previously provisioned DB cluster}
\usage{
rds_delete_db_cluster(
  DBClusterIdentifier,
  SkipFinalSnapshot = NULL,
  FinalDBSnapshotIdentifier = NULL,
  DeleteAutomatedBackups = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier for the DB cluster to be deleted. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must match an existing DBClusterIdentifier.
}}

\item{SkipFinalSnapshot}{Specifies whether to skip the creation of a final DB cluster snapshot
before the DB cluster is deleted. If skip is specified, no DB cluster
snapshot is created. If skip isn't specified, a DB cluster snapshot is
created before the DB cluster is deleted. By default, skip isn't
specified, and the DB cluster snapshot is created. By default, this
parameter is disabled.

You must specify a \code{FinalDBSnapshotIdentifier} parameter if
\code{SkipFinalSnapshot} is disabled.}

\item{FinalDBSnapshotIdentifier}{The DB cluster snapshot identifier of the new DB cluster snapshot
created when \code{SkipFinalSnapshot} is disabled.

Specifying this parameter and also skipping the creation of a final DB
cluster snapshot with the \code{SkipFinalShapshot} parameter results in an
error.

Constraints:
\itemize{
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}}

\item{DeleteAutomatedBackups}{Specifies whether to remove automated backups immediately after the DB
cluster is deleted. This parameter isn't case-sensitive. The default is
to remove automated backups immediately after the DB cluster is deleted.}
}
\description{
The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted.

See \url{https://www.paws-r-sdk.com/docs/rds_delete_db_cluster/} for full documentation.
}
\keyword{internal}
