% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_import_table}
\alias{dynamodb_import_table}
\title{Imports table data from an S3 bucket}
\usage{
dynamodb_import_table(
  ClientToken = NULL,
  S3BucketSource,
  InputFormat,
  InputFormatOptions = NULL,
  InputCompressionType = NULL,
  TableCreationParameters
)
}
\arguments{
\item{ClientToken}{Providing a \code{ClientToken} makes the call to \code{ImportTableInput}
idempotent, meaning that multiple identical calls have the same effect
as one single call.

A client token is valid for 8 hours after the first request that uses it
is completed. After 8 hours, any request with the same client token is
treated as a new request. Do not resubmit the same request with the same
client token for more than 8 hours, or the result might not be
idempotent.

If you submit a request with the same client token but a change in other
parameters within the 8-hour idempotency window, DynamoDB returns an
\code{IdempotentParameterMismatch} exception.}

\item{S3BucketSource}{[required] The S3 bucket that provides the source for the import.}

\item{InputFormat}{[required] The format of the source data. Valid values for \code{ImportFormat} are
\code{CSV}, \code{DYNAMODB_JSON} or \code{ION}.}

\item{InputFormatOptions}{Additional properties that specify how the input is formatted,}

\item{InputCompressionType}{Type of compression to be used on the input coming from the imported
table.}

\item{TableCreationParameters}{[required] Parameters for the table to import the data into.}
}
\description{
Imports table data from an S3 bucket.

See \url{https://www.paws-r-sdk.com/docs/dynamodb_import_table/} for full documentation.
}
\keyword{internal}
