% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_get_credentials}
\alias{redshiftserverless_get_credentials}
\title{Returns a database user name and temporary password with temporary
authorization to log in to Amazon Redshift Serverless}
\usage{
redshiftserverless_get_credentials(
  dbName = NULL,
  durationSeconds = NULL,
  workgroupName
)
}
\arguments{
\item{dbName}{The name of the database to get temporary authorization to log on to.

Constraints:
\itemize{
\item Must be 1 to 64 alphanumeric characters or hyphens.
\item Must contain only uppercase or lowercase letters, numbers,
underscore, plus sign, period (dot), at symbol (@), or hyphen.
\item The first character must be a letter.
\item Must not contain a colon ( : ) or slash ( / ).
\item Cannot be a reserved word. A list of reserved words can be found in
\href{https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html}{Reserved Words}
in the Amazon Redshift Database Developer Guide
}}

\item{durationSeconds}{The number of seconds until the returned temporary password expires. The
minimum is 900 seconds, and the maximum is 3600 seconds.}

\item{workgroupName}{[required] The name of the workgroup associated with the database.}
}
\description{
Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless.

See \url{https://www.paws-r-sdk.com/docs/redshiftserverless_get_credentials/} for full documentation.
}
\keyword{internal}
