% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timestreamquery_operations.R
\name{timestreamquery_prepare_query}
\alias{timestreamquery_prepare_query}
\title{A synchronous operation that allows you to submit a query with
parameters to be stored by Timestream for later running}
\usage{
timestreamquery_prepare_query(QueryString, ValidateOnly = NULL)
}
\arguments{
\item{QueryString}{[required] The Timestream query string that you want to use as a prepared
statement. Parameter names can be specified in the query string \code{@}
character followed by an identifier.}

\item{ValidateOnly}{By setting this value to \code{true}, Timestream will only validate that the
query string is a valid Timestream query, and not store the prepared
query for later use.}
}
\description{
A synchronous operation that allows you to submit a query with parameters to be stored by Timestream for later running. Timestream only supports using this operation with the \code{PrepareQueryRequest$ValidateOnly} set to \code{true}.

See \url{https://paws-r.github.io/docs/timestreamquery/prepare_query.html} for full documentation.
}
\keyword{internal}
