% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_parameter_group}
\alias{rds_modify_db_parameter_group}
\title{Modifies the parameters of a DB parameter group}
\usage{
rds_modify_db_parameter_group(DBParameterGroupName, Parameters)
}
\arguments{
\item{DBParameterGroupName}{[required] The name of the DB parameter group.

Constraints:
\itemize{
\item If supplied, must match the name of an existing \code{DBParameterGroup}.
}}

\item{Parameters}{[required] An array of parameter names, values, and the application methods for the
parameter update. At least one parameter name, value, and application
method must be supplied; later arguments are optional. A maximum of 20
parameters can be modified in a single request.

Valid Values (for the application method): \code{immediate | pending-reboot}

You can use the \code{immediate} value with dynamic parameters only. You can
use the \code{pending-reboot} value for both dynamic and static parameters.

When the application method is \code{immediate}, changes to dynamic
parameters are applied immediately to the DB instances associated with
the parameter group.

When the application method is \code{pending-reboot}, changes to dynamic and
static parameters are applied after a reboot without failover to the DB
instances associated with the parameter group.

You can't use \code{pending-reboot} with dynamic parameters on RDS for SQL
Server DB instances. Use \code{immediate}.

For more information on modifying DB parameters, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html}{Working with DB parameter groups}
in the \emph{Amazon RDS User Guide}.}
}
\description{
Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: \code{ParameterName}, \code{ParameterValue}, and \code{ApplyMethod}. A maximum of 20 parameters can be modified in a single request.

See \url{https://paws-r.github.io/docs/rds/modify_db_parameter_group.html} for full documentation.
}
\keyword{internal}
