% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_certificates}
\alias{rds_describe_certificates}
\title{Lists the set of CA certificates provided by Amazon RDS for this Amazon
Web Services account}
\usage{
rds_describe_certificates(
  CertificateIdentifier = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{CertificateIdentifier}{The user-supplied certificate identifier. If this parameter is
specified, information for only the identified certificate is returned.
This parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must match an existing CertificateIdentifier.
}}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_certificates]{describe_certificates}} request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Lists the set of CA certificates provided by Amazon RDS for this Amazon Web Services account.

See \url{https://paws-r.github.io/docs/rds/describe_certificates.html} for full documentation.
}
\keyword{internal}
