% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_event_subscription}
\alias{rds_create_event_subscription}
\title{Creates an RDS event notification subscription}
\usage{
rds_create_event_subscription(
  SubscriptionName,
  SnsTopicArn,
  SourceType = NULL,
  EventCategories = NULL,
  SourceIds = NULL,
  Enabled = NULL,
  Tags = NULL
)
}
\arguments{
\item{SubscriptionName}{[required] The name of the subscription.

Constraints: The name must be less than 255 characters.}

\item{SnsTopicArn}{[required] The Amazon Resource Name (ARN) of the SNS topic created for event
notification. The ARN is created by Amazon SNS when you create a topic
and subscribe to it.}

\item{SourceType}{The type of source that is generating the events. For example, if you
want to be notified of events generated by a DB instance, you set this
parameter to \code{db-instance}. For RDS Proxy events, specify \code{db-proxy}. If
this value isn't specified, all events are returned.

Valid values: \code{db-instance} | \code{db-cluster} | \code{db-parameter-group} |
\code{db-security-group} | \code{db-snapshot} | \code{db-cluster-snapshot} | \code{db-proxy}}

\item{EventCategories}{A list of event categories for a particular source type (\code{SourceType})
that you want to subscribe to. You can see a list of the categories for
a given source type in the "Amazon RDS event categories and event
messages" section of the \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html}{\emph{Amazon RDS User Guide}}
or the \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html}{\emph{Amazon Aurora User Guide}}
. You can also see this list by using the
\code{\link[=rds_describe_event_categories]{describe_event_categories}} operation.}

\item{SourceIds}{The list of identifiers of the event sources for which events are
returned. If not specified, then all sources are included in the
response. An identifier must begin with a letter and must contain only
ASCII letters, digits, and hyphens. It can't end with a hyphen or
contain two consecutive hyphens.

Constraints:
\itemize{
\item If \code{SourceIds} are supplied, \code{SourceType} must also be provided.
\item If the source type is a DB instance, a \code{DBInstanceIdentifier} value
must be supplied.
\item If the source type is a DB cluster, a \code{DBClusterIdentifier} value
must be supplied.
\item If the source type is a DB parameter group, a \code{DBParameterGroupName}
value must be supplied.
\item If the source type is a DB security group, a \code{DBSecurityGroupName}
value must be supplied.
\item If the source type is a DB snapshot, a \code{DBSnapshotIdentifier} value
must be supplied.
\item If the source type is a DB cluster snapshot, a
\code{DBClusterSnapshotIdentifier} value must be supplied.
\item If the source type is an RDS Proxy, a \code{DBProxyName} value must be
supplied.
}}

\item{Enabled}{A value that indicates whether to activate the subscription. If the
event notification subscription isn't activated, the subscription is
created but not active.}

\item{Tags}{}
}
\description{
Creates an RDS event notification subscription. This operation requires a topic Amazon Resource Name (ARN) created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.

See \url{https://paws-r.github.io/docs/rds/create_event_subscription.html} for full documentation.
}
\keyword{internal}
