% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodbstreams_operations.R
\name{dynamodbstreams_describe_stream}
\alias{dynamodbstreams_describe_stream}
\title{Returns information about a stream, including the current status of the
stream, its Amazon Resource Name (ARN), the composition of its shards,
and its corresponding DynamoDB table}
\usage{
dynamodbstreams_describe_stream(
  StreamArn,
  Limit = NULL,
  ExclusiveStartShardId = NULL
)
}
\arguments{
\item{StreamArn}{[required] The Amazon Resource Name (ARN) for the stream.}

\item{Limit}{The maximum number of shard objects to return. The upper limit is 100.}

\item{ExclusiveStartShardId}{The shard ID of the first item that this operation will evaluate. Use
the value that was returned for \code{LastEvaluatedShardId} in the previous
operation.}
}
\description{
Returns information about a stream, including the current status of the stream, its Amazon Resource Name (ARN), the composition of its shards, and its corresponding DynamoDB table.

See \url{https://paws-r.github.io/docs/dynamodbstreams/describe_stream.html} for full documentation.
}
\keyword{internal}
