% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_describe_db_engine_versions}
\alias{docdb_describe_db_engine_versions}
\title{Returns a list of the available engines}
\usage{
docdb_describe_db_engine_versions(
  Engine = NULL,
  EngineVersion = NULL,
  DBParameterGroupFamily = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL,
  DefaultOnly = NULL,
  ListSupportedCharacterSets = NULL,
  ListSupportedTimezones = NULL
)
}
\arguments{
\item{Engine}{The database engine to return.}

\item{EngineVersion}{The database engine version to return.

Example: \verb{3.6.0}}

\item{DBParameterGroupFamily}{The name of a specific parameter group family to return details for.

Constraints:
\itemize{
\item If provided, must match an existing \code{DBParameterGroupFamily}.
}}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
(marker) is included in the response so that the remaining results can
be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}

\item{DefaultOnly}{Indicates that only the default version of the specified engine or
engine and major version combination is returned.}

\item{ListSupportedCharacterSets}{If this parameter is specified and the requested engine supports the
\code{CharacterSetName} parameter for
\code{\link[=docdb_create_db_instance]{create_db_instance}}, the response includes
a list of supported character sets for each engine version.}

\item{ListSupportedTimezones}{If this parameter is specified and the requested engine supports the
\code{TimeZone} parameter for
\code{\link[=docdb_create_db_instance]{create_db_instance}}, the response includes
a list of supported time zones for each engine version.}
}
\description{
Returns a list of the available engines.

See \url{https://paws-r.github.io/docs/docdb/describe_db_engine_versions.html} for full documentation.
}
\keyword{internal}
