# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include elasticache_service.R
NULL

#' A tag is a key-value pair where the key and value are case-sensitive
#'
#' @description
#' A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
#'
#' See [https://paws-r.github.io/docs/elasticache/add_tags_to_resource.html](https://paws-r.github.io/docs/elasticache/add_tags_to_resource.html) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which the tags are to
#' be added, for example
#' `arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster` or
#' `arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot`.
#' ElastiCache resources are *cluster* and *snapshot*.
#'
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' Amazon Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#' @param Tags &#91;required&#93; A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname elasticache_add_tags_to_resource
elasticache_add_tags_to_resource <- function(ResourceName, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$add_tags_to_resource_input(ResourceName = ResourceName, Tags = Tags)
  output <- .elasticache$add_tags_to_resource_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$add_tags_to_resource <- elasticache_add_tags_to_resource

#' Allows network ingress to a cache security group
#'
#' @description
#' Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2, and Amazon EC2 security groups are used as the authorization mechanism.
#'
#' See [https://paws-r.github.io/docs/elasticache/authorize_cache_security_group_ingress.html](https://paws-r.github.io/docs/elasticache/authorize_cache_security_group_ingress.html) for full documentation.
#'
#' @param CacheSecurityGroupName &#91;required&#93; The cache security group that allows network ingress.
#' @param EC2SecurityGroupName &#91;required&#93; The Amazon EC2 security group to be authorized for ingress to the cache
#' security group.
#' @param EC2SecurityGroupOwnerId &#91;required&#93; The Amazon account number of the Amazon EC2 security group owner. Note
#' that this is not the same thing as an Amazon access key ID - you must
#' provide a valid Amazon account number for this parameter.
#'
#' @keywords internal
#'
#' @rdname elasticache_authorize_cache_security_group_ingress
elasticache_authorize_cache_security_group_ingress <- function(CacheSecurityGroupName, EC2SecurityGroupName, EC2SecurityGroupOwnerId) {
  op <- new_operation(
    name = "AuthorizeCacheSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$authorize_cache_security_group_ingress_input(CacheSecurityGroupName = CacheSecurityGroupName, EC2SecurityGroupName = EC2SecurityGroupName, EC2SecurityGroupOwnerId = EC2SecurityGroupOwnerId)
  output <- .elasticache$authorize_cache_security_group_ingress_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$authorize_cache_security_group_ingress <- elasticache_authorize_cache_security_group_ingress

#' Apply the service update
#'
#' @description
#' Apply the service update. For more information on service updates and applying them, see [Applying Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/).
#'
#' See [https://paws-r.github.io/docs/elasticache/batch_apply_update_action.html](https://paws-r.github.io/docs/elasticache/batch_apply_update_action.html) for full documentation.
#'
#' @param ReplicationGroupIds The replication group IDs
#' @param CacheClusterIds The cache cluster IDs
#' @param ServiceUpdateName &#91;required&#93; The unique ID of the service update
#'
#' @keywords internal
#'
#' @rdname elasticache_batch_apply_update_action
elasticache_batch_apply_update_action <- function(ReplicationGroupIds = NULL, CacheClusterIds = NULL, ServiceUpdateName) {
  op <- new_operation(
    name = "BatchApplyUpdateAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$batch_apply_update_action_input(ReplicationGroupIds = ReplicationGroupIds, CacheClusterIds = CacheClusterIds, ServiceUpdateName = ServiceUpdateName)
  output <- .elasticache$batch_apply_update_action_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$batch_apply_update_action <- elasticache_batch_apply_update_action

#' Stop the service update
#'
#' @description
#' Stop the service update. For more information on service updates and stopping them, see [Stopping Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/).
#'
#' See [https://paws-r.github.io/docs/elasticache/batch_stop_update_action.html](https://paws-r.github.io/docs/elasticache/batch_stop_update_action.html) for full documentation.
#'
#' @param ReplicationGroupIds The replication group IDs
#' @param CacheClusterIds The cache cluster IDs
#' @param ServiceUpdateName &#91;required&#93; The unique ID of the service update
#'
#' @keywords internal
#'
#' @rdname elasticache_batch_stop_update_action
elasticache_batch_stop_update_action <- function(ReplicationGroupIds = NULL, CacheClusterIds = NULL, ServiceUpdateName) {
  op <- new_operation(
    name = "BatchStopUpdateAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$batch_stop_update_action_input(ReplicationGroupIds = ReplicationGroupIds, CacheClusterIds = CacheClusterIds, ServiceUpdateName = ServiceUpdateName)
  output <- .elasticache$batch_stop_update_action_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$batch_stop_update_action <- elasticache_batch_stop_update_action

#' Complete the migration of data
#'
#' @description
#' Complete the migration of data.
#'
#' See [https://paws-r.github.io/docs/elasticache/complete_migration.html](https://paws-r.github.io/docs/elasticache/complete_migration.html) for full documentation.
#'
#' @param ReplicationGroupId &#91;required&#93; The ID of the replication group to which data is being migrated.
#' @param Force Forces the migration to stop without ensuring that data is in sync. It
#' is recommended to use this option only to abort the migration and not
#' recommended when application wants to continue migration to ElastiCache.
#'
#' @keywords internal
#'
#' @rdname elasticache_complete_migration
elasticache_complete_migration <- function(ReplicationGroupId, Force = NULL) {
  op <- new_operation(
    name = "CompleteMigration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$complete_migration_input(ReplicationGroupId = ReplicationGroupId, Force = Force)
  output <- .elasticache$complete_migration_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$complete_migration <- elasticache_complete_migration

#' Makes a copy of an existing snapshot
#'
#' @description
#' Makes a copy of an existing snapshot.
#'
#' See [https://paws-r.github.io/docs/elasticache/copy_snapshot.html](https://paws-r.github.io/docs/elasticache/copy_snapshot.html) for full documentation.
#'
#' @param SourceSnapshotName &#91;required&#93; The name of an existing snapshot from which to make a copy.
#' @param TargetSnapshotName &#91;required&#93; A name for the snapshot copy. ElastiCache does not permit overwriting a
#' snapshot, therefore this name must be unique within its context -
#' ElastiCache or an Amazon S3 bucket if exporting.
#' @param TargetBucket The Amazon S3 bucket to which the snapshot is exported. This parameter
#' is used only when exporting a snapshot for external access.
#'
#' When using this parameter to export a snapshot, be sure Amazon
#' ElastiCache has the needed permissions to this S3 bucket. For more
#' information, see [Step 2: Grant ElastiCache Access to Your Amazon S3
#' Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access)
#' in the *Amazon ElastiCache User Guide*.
#'
#' For more information, see [Exporting a
#' Snapshot](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html)
#' in the *Amazon ElastiCache User Guide*.
#' @param KmsKeyId The ID of the KMS key used to encrypt the target snapshot.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname elasticache_copy_snapshot
elasticache_copy_snapshot <- function(SourceSnapshotName, TargetSnapshotName, TargetBucket = NULL, KmsKeyId = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CopySnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$copy_snapshot_input(SourceSnapshotName = SourceSnapshotName, TargetSnapshotName = TargetSnapshotName, TargetBucket = TargetBucket, KmsKeyId = KmsKeyId, Tags = Tags)
  output <- .elasticache$copy_snapshot_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$copy_snapshot <- elasticache_copy_snapshot

#' Creates a cluster
#'
#' @description
#' Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either Memcached or Redis.
#'
#' See [https://paws-r.github.io/docs/elasticache/create_cache_cluster.html](https://paws-r.github.io/docs/elasticache/create_cache_cluster.html) for full documentation.
#'
#' @param CacheClusterId &#91;required&#93; The node group (shard) identifier. This parameter is stored as a
#' lowercase string.
#'
#' **Constraints:**
#'
#' -   A name must contain from 1 to 50 alphanumeric characters or hyphens.
#'
#' -   The first character must be a letter.
#'
#' -   A name cannot end with a hyphen or contain two consecutive hyphens.
#' @param ReplicationGroupId The ID of the replication group to which this cluster should belong. If
#' this parameter is specified, the cluster is added to the specified
#' replication group as a read replica; otherwise, the cluster is a
#' standalone primary that is not part of any replication group.
#'
#' If the specified replication group is Multi-AZ enabled and the
#' Availability Zone is not specified, the cluster is created in
#' Availability Zones that provide the best spread of read replicas across
#' Availability Zones.
#'
#' This parameter is only valid if the `Engine` parameter is `redis`.
#' @param AZMode Specifies whether the nodes in this Memcached cluster are created in a
#' single Availability Zone or created across multiple Availability Zones
#' in the cluster's region.
#'
#' This parameter is only supported for Memcached clusters.
#'
#' If the `AZMode` and `PreferredAvailabilityZones` are not specified,
#' ElastiCache assumes `single-az` mode.
#' @param PreferredAvailabilityZone The EC2 Availability Zone in which the cluster is created.
#'
#' All nodes belonging to this cluster are placed in the preferred
#' Availability Zone. If you want to create your nodes across multiple
#' Availability Zones, use `PreferredAvailabilityZones`.
#'
#' Default: System chosen Availability Zone.
#' @param PreferredAvailabilityZones A list of the Availability Zones in which cache nodes are created. The
#' order of the zones in the list is not important.
#'
#' This option is only supported on Memcached.
#'
#' If you are creating your cluster in an Amazon VPC (recommended) you can
#' only locate nodes in Availability Zones that are associated with the
#' subnets in the selected subnet group.
#'
#' The number of Availability Zones listed must equal the value of
#' `NumCacheNodes`.
#'
#' If you want all the nodes in the same Availability Zone, use
#' `PreferredAvailabilityZone` instead, or repeat the Availability Zone
#' multiple times in the list.
#'
#' Default: System chosen Availability Zones.
#' @param NumCacheNodes The initial number of cache nodes that the cluster has.
#'
#' For clusters running Redis, this value must be 1. For clusters running
#' Memcached, this value must be between 1 and 40.
#'
#' If you need more than 40 nodes for your Memcached cluster, please fill
#' out the ElastiCache Limit Increase Request form at
#' http://aws.amazon.com/contact-us/elasticache-node-limit-request/.
#' @param CacheNodeType The compute and memory capacity of the nodes in the node group (shard).
#'
#' The following node types are supported by ElastiCache. Generally
#' speaking, the current generation types provide more memory and
#' computational power at lower cost when compared to their equivalent
#' previous generation counterparts.
#'
#' -   General purpose:
#'
#'     -   Current generation:
#'
#'         **M6g node types** (available only for Redis engine version
#'         5.0.6 onward and for Memcached engine version 1.5.16 onward):
#'         `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`,
#'         `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`,
#'         `cache.m6g.16xlarge`
#'
#'         For region availability, see [Supported Node
#'         Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
#'
#'         **M5 node types:** `cache.m5.large`, `cache.m5.xlarge`,
#'         `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`,
#'         `cache.m5.24xlarge`
#'
#'         **M4 node types:** `cache.m4.large`, `cache.m4.xlarge`,
#'         `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`
#'
#'         **T4g node types** (available only for Redis engine version
#'         5.0.6 onward and Memcached engine version 1.5.16 onward):
#'         `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`
#'
#'         **T3 node types:** `cache.t3.micro`, `cache.t3.small`,
#'         `cache.t3.medium`
#'
#'         **T2 node types:** `cache.t2.micro`, `cache.t2.small`,
#'         `cache.t2.medium`
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **T1 node types:** `cache.t1.micro`
#'
#'         **M1 node types:** `cache.m1.small`, `cache.m1.medium`,
#'         `cache.m1.large`, `cache.m1.xlarge`
#'
#'         **M3 node types:** `cache.m3.medium`, `cache.m3.large`,
#'         `cache.m3.xlarge`, `cache.m3.2xlarge`
#'
#' -   Compute optimized:
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **C1 node types:** `cache.c1.xlarge`
#'
#' -   Memory optimized:
#'
#'     -   Current generation:
#'
#'         **R6g node types** (available only for Redis engine version
#'         5.0.6 onward and for Memcached engine version 1.5.16 onward).
#'
#'         `cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`,
#'         `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`,
#'         `cache.r6g.16xlarge`
#'
#'         For region availability, see [Supported Node
#'         Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
#'
#'         **R5 node types:** `cache.r5.large`, `cache.r5.xlarge`,
#'         `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`,
#'         `cache.r5.24xlarge`
#'
#'         **R4 node types:** `cache.r4.large`, `cache.r4.xlarge`,
#'         `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`,
#'         `cache.r4.16xlarge`
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **M2 node types:** `cache.m2.xlarge`, `cache.m2.2xlarge`,
#'         `cache.m2.4xlarge`
#'
#'         **R3 node types:** `cache.r3.large`, `cache.r3.xlarge`,
#'         `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
#'
#' **Additional node type info**
#'
#' -   All current generation instance types are created in Amazon VPC by
#'     default.
#'
#' -   Redis append-only files (AOF) are not supported for T1 or T2
#'     instances.
#'
#' -   Redis Multi-AZ with automatic failover is not supported on T1
#'     instances.
#'
#' -   Redis configuration variables `appendonly` and `appendfsync` are not
#'     supported on Redis version 2.8.22 and later.
#' @param Engine The name of the cache engine to be used for this cluster.
#'
#' Valid values for this parameter are: `memcached` | `redis`
#' @param EngineVersion The version number of the cache engine to be used for this cluster. To
#' view the supported cache engine versions, use the
#' DescribeCacheEngineVersions operation.
#'
#' **Important:** You can upgrade to a newer engine version (see [Selecting
#' a Cache Engine and
#' Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)),
#' but you cannot downgrade to an earlier engine version. If you want to
#' use an earlier engine version, you must delete the existing cluster or
#' replication group and create it anew with the earlier engine version.
#' @param CacheParameterGroupName The name of the parameter group to associate with this cluster. If this
#' argument is omitted, the default parameter group for the specified
#' engine is used. You cannot use any parameter group which has
#' `cluster-enabled='yes'` when creating a cluster.
#' @param CacheSubnetGroupName The name of the subnet group to be used for the cluster.
#'
#' Use this parameter only when you are creating a cluster in an Amazon
#' Virtual Private Cloud (Amazon VPC).
#'
#' If you're going to launch your cluster in an Amazon VPC, you need to
#' create a subnet group before you start creating a cluster. For more
#' information, see [Subnets and Subnet
#' Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html).
#' @param CacheSecurityGroupNames A list of security group names to associate with this cluster.
#'
#' Use this parameter only when you are creating a cluster outside of an
#' Amazon Virtual Private Cloud (Amazon VPC).
#' @param SecurityGroupIds One or more VPC security groups associated with the cluster.
#'
#' Use this parameter only when you are creating a cluster in an Amazon
#' Virtual Private Cloud (Amazon VPC).
#' @param Tags A list of tags to be added to this resource.
#' @param SnapshotArns A single-element string list containing an Amazon Resource Name (ARN)
#' that uniquely identifies a Redis RDB snapshot file stored in Amazon S3.
#' The snapshot file is used to populate the node group (shard). The Amazon
#' S3 object name in the ARN cannot contain any commas.
#'
#' This parameter is only valid if the `Engine` parameter is `redis`.
#'
#' Example of an Amazon S3 ARN: `arn:aws:s3:::my_bucket/snapshot1.rdb`
#' @param SnapshotName The name of a Redis snapshot from which to restore data into the new
#' node group (shard). The snapshot status changes to `restoring` while the
#' new node group (shard) is being created.
#'
#' This parameter is only valid if the `Engine` parameter is `redis`.
#' @param PreferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period.
#' @param Port The port number on which each of the cache nodes accepts connections.
#' @param NotificationTopicArn The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
#' (SNS) topic to which notifications are sent.
#'
#' The Amazon SNS topic owner must be the same as the cluster owner.
#' @param AutoMinorVersionUpgrade  If you are running Redis engine version 6.0 or later, set this
#' parameter to yes if you want to opt-in to the next auto minor version
#' upgrade campaign. This parameter is disabled for previous versions. 
#' @param SnapshotRetentionLimit The number of days for which ElastiCache retains automatic snapshots
#' before deleting them. For example, if you set `SnapshotRetentionLimit`
#' to 5, a snapshot taken today is retained for 5 days before being
#' deleted.
#'
#' This parameter is only valid if the `Engine` parameter is `redis`.
#'
#' Default: 0 (i.e., automatic backups are disabled for this cache
#' cluster).
#' @param SnapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a
#' daily snapshot of your node group (shard).
#'
#' Example: `05:00-09:00`
#'
#' If you do not specify this parameter, ElastiCache automatically chooses
#' an appropriate time range.
#'
#' This parameter is only valid if the `Engine` parameter is `redis`.
#' @param AuthToken **Reserved parameter.** The password used to access a password protected
#' server.
#'
#' Password constraints:
#'
#' -   Must be only printable ASCII characters.
#'
#' -   Must be at least 16 characters and no more than 128 characters in
#'     length.
#'
#' -   The only permitted printable special characters are !, &, #, $, ^,
#'     \<, \>, and -. Other printable special characters cannot be used in
#'     the AUTH token.
#'
#' For more information, see [AUTH
#' password](https://redis.io/commands/auth/) at
#' http://redis.io/commands/AUTH.
#' @param OutpostMode Specifies whether the nodes in the cluster are created in a single
#' outpost or across multiple outposts.
#' @param PreferredOutpostArn The outpost ARN in which the cache cluster is created.
#' @param PreferredOutpostArns The outpost ARNs in which the cache cluster is created.
#' @param LogDeliveryConfigurations Specifies the destination, format and type of the logs.
#' @param TransitEncryptionEnabled A flag that enables in-transit encryption when set to true. You cannot
#' modify the value of `TransitEncryptionEnabled` after the cluster is
#' created. To enable in-transit encryption on a cluster you must set
#' `TransitEncryptionEnabled` to true when you create a cluster.
#'
#' **Required:** Only available when creating a cache cluster in an Amazon
#' VPC using Memcached version `1.6.12` or later.
#'
#' @keywords internal
#'
#' @rdname elasticache_create_cache_cluster
elasticache_create_cache_cluster <- function(CacheClusterId, ReplicationGroupId = NULL, AZMode = NULL, PreferredAvailabilityZone = NULL, PreferredAvailabilityZones = NULL, NumCacheNodes = NULL, CacheNodeType = NULL, Engine = NULL, EngineVersion = NULL, CacheParameterGroupName = NULL, CacheSubnetGroupName = NULL, CacheSecurityGroupNames = NULL, SecurityGroupIds = NULL, Tags = NULL, SnapshotArns = NULL, SnapshotName = NULL, PreferredMaintenanceWindow = NULL, Port = NULL, NotificationTopicArn = NULL, AutoMinorVersionUpgrade = NULL, SnapshotRetentionLimit = NULL, SnapshotWindow = NULL, AuthToken = NULL, OutpostMode = NULL, PreferredOutpostArn = NULL, PreferredOutpostArns = NULL, LogDeliveryConfigurations = NULL, TransitEncryptionEnabled = NULL) {
  op <- new_operation(
    name = "CreateCacheCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_cache_cluster_input(CacheClusterId = CacheClusterId, ReplicationGroupId = ReplicationGroupId, AZMode = AZMode, PreferredAvailabilityZone = PreferredAvailabilityZone, PreferredAvailabilityZones = PreferredAvailabilityZones, NumCacheNodes = NumCacheNodes, CacheNodeType = CacheNodeType, Engine = Engine, EngineVersion = EngineVersion, CacheParameterGroupName = CacheParameterGroupName, CacheSubnetGroupName = CacheSubnetGroupName, CacheSecurityGroupNames = CacheSecurityGroupNames, SecurityGroupIds = SecurityGroupIds, Tags = Tags, SnapshotArns = SnapshotArns, SnapshotName = SnapshotName, PreferredMaintenanceWindow = PreferredMaintenanceWindow, Port = Port, NotificationTopicArn = NotificationTopicArn, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, SnapshotRetentionLimit = SnapshotRetentionLimit, SnapshotWindow = SnapshotWindow, AuthToken = AuthToken, OutpostMode = OutpostMode, PreferredOutpostArn = PreferredOutpostArn, PreferredOutpostArns = PreferredOutpostArns, LogDeliveryConfigurations = LogDeliveryConfigurations, TransitEncryptionEnabled = TransitEncryptionEnabled)
  output <- .elasticache$create_cache_cluster_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_cache_cluster <- elasticache_create_cache_cluster

#' Creates a new Amazon ElastiCache cache parameter group
#'
#' @description
#' Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster or replication group using the CacheParameterGroup.
#'
#' See [https://paws-r.github.io/docs/elasticache/create_cache_parameter_group.html](https://paws-r.github.io/docs/elasticache/create_cache_parameter_group.html) for full documentation.
#'
#' @param CacheParameterGroupName &#91;required&#93; A user-specified name for the cache parameter group.
#' @param CacheParameterGroupFamily &#91;required&#93; The name of the cache parameter group family that the cache parameter
#' group can be used with.
#'
#' Valid values are: `memcached1.4` | `memcached1.5` | `memcached1.6` |
#' `redis2.6` | `redis2.8` | `redis3.2` | `redis4.0` | `redis5.0` |
#' `redis6.x`
#' @param Description &#91;required&#93; A user-specified description for the cache parameter group.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname elasticache_create_cache_parameter_group
elasticache_create_cache_parameter_group <- function(CacheParameterGroupName, CacheParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateCacheParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_cache_parameter_group_input(CacheParameterGroupName = CacheParameterGroupName, CacheParameterGroupFamily = CacheParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .elasticache$create_cache_parameter_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_cache_parameter_group <- elasticache_create_cache_parameter_group

#' Creates a new cache security group
#'
#' @description
#' Creates a new cache security group. Use a cache security group to control access to one or more clusters.
#'
#' See [https://paws-r.github.io/docs/elasticache/create_cache_security_group.html](https://paws-r.github.io/docs/elasticache/create_cache_security_group.html) for full documentation.
#'
#' @param CacheSecurityGroupName &#91;required&#93; A name for the cache security group. This value is stored as a lowercase
#' string.
#'
#' Constraints: Must contain no more than 255 alphanumeric characters.
#' Cannot be the word "Default".
#'
#' Example: `mysecuritygroup`
#' @param Description &#91;required&#93; A description for the cache security group.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname elasticache_create_cache_security_group
elasticache_create_cache_security_group <- function(CacheSecurityGroupName, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateCacheSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_cache_security_group_input(CacheSecurityGroupName = CacheSecurityGroupName, Description = Description, Tags = Tags)
  output <- .elasticache$create_cache_security_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_cache_security_group <- elasticache_create_cache_security_group

#' Creates a new cache subnet group
#'
#' @description
#' Creates a new cache subnet group.
#'
#' See [https://paws-r.github.io/docs/elasticache/create_cache_subnet_group.html](https://paws-r.github.io/docs/elasticache/create_cache_subnet_group.html) for full documentation.
#'
#' @param CacheSubnetGroupName &#91;required&#93; A name for the cache subnet group. This value is stored as a lowercase
#' string.
#'
#' Constraints: Must contain no more than 255 alphanumeric characters or
#' hyphens.
#'
#' Example: `mysubnetgroup`
#' @param CacheSubnetGroupDescription &#91;required&#93; A description for the cache subnet group.
#' @param SubnetIds &#91;required&#93; A list of VPC subnet IDs for the cache subnet group.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname elasticache_create_cache_subnet_group
elasticache_create_cache_subnet_group <- function(CacheSubnetGroupName, CacheSubnetGroupDescription, SubnetIds, Tags = NULL) {
  op <- new_operation(
    name = "CreateCacheSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_cache_subnet_group_input(CacheSubnetGroupName = CacheSubnetGroupName, CacheSubnetGroupDescription = CacheSubnetGroupDescription, SubnetIds = SubnetIds, Tags = Tags)
  output <- .elasticache$create_cache_subnet_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_cache_subnet_group <- elasticache_create_cache_subnet_group

#' Global Datastore for Redis offers fully managed, fast, reliable and
#' secure cross-region replication
#'
#' @description
#' Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable low-latency reads and disaster recovery across regions. For more information, see [Replication Across Regions Using Global Datastore](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html).
#'
#' See [https://paws-r.github.io/docs/elasticache/create_global_replication_group.html](https://paws-r.github.io/docs/elasticache/create_global_replication_group.html) for full documentation.
#'
#' @param GlobalReplicationGroupIdSuffix &#91;required&#93; The suffix name of a Global datastore. Amazon ElastiCache automatically
#' applies a prefix to the Global datastore ID when it is created. Each
#' Amazon Region has its own prefix. For instance, a Global datastore ID
#' created in the US-West-1 region will begin with "dsdfu" along with the
#' suffix name you provide. The suffix, combined with the auto-generated
#' prefix, guarantees uniqueness of the Global datastore name across
#' multiple regions.
#'
#' For a full list of Amazon Regions and their respective Global datastore
#' iD prefixes, see [Using the Amazon CLI with Global
#' datastores](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastores-CLI.html)
#' .
#' @param GlobalReplicationGroupDescription Provides details of the Global datastore
#' @param PrimaryReplicationGroupId &#91;required&#93; The name of the primary cluster that accepts writes and will replicate
#' updates to the secondary cluster.
#'
#' @keywords internal
#'
#' @rdname elasticache_create_global_replication_group
elasticache_create_global_replication_group <- function(GlobalReplicationGroupIdSuffix, GlobalReplicationGroupDescription = NULL, PrimaryReplicationGroupId) {
  op <- new_operation(
    name = "CreateGlobalReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_global_replication_group_input(GlobalReplicationGroupIdSuffix = GlobalReplicationGroupIdSuffix, GlobalReplicationGroupDescription = GlobalReplicationGroupDescription, PrimaryReplicationGroupId = PrimaryReplicationGroupId)
  output <- .elasticache$create_global_replication_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_global_replication_group <- elasticache_create_global_replication_group

#' Creates a Redis (cluster mode disabled) or a Redis (cluster mode
#' enabled) replication group
#'
#' @description
#' Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.
#'
#' See [https://paws-r.github.io/docs/elasticache/create_replication_group.html](https://paws-r.github.io/docs/elasticache/create_replication_group.html) for full documentation.
#'
#' @param ReplicationGroupId &#91;required&#93; The replication group identifier. This parameter is stored as a
#' lowercase string.
#'
#' Constraints:
#'
#' -   A name must contain from 1 to 40 alphanumeric characters or hyphens.
#'
#' -   The first character must be a letter.
#'
#' -   A name cannot end with a hyphen or contain two consecutive hyphens.
#' @param ReplicationGroupDescription &#91;required&#93; A user-created description for the replication group.
#' @param GlobalReplicationGroupId The name of the Global datastore
#' @param PrimaryClusterId The identifier of the cluster that serves as the primary for this
#' replication group. This cluster must already exist and have a status of
#' `available`.
#'
#' This parameter is not required if `NumCacheClusters`, `NumNodeGroups`,
#' or `ReplicasPerNodeGroup` is specified.
#' @param AutomaticFailoverEnabled Specifies whether a read-only replica is automatically promoted to
#' read/write primary if the existing primary fails.
#'
#' `AutomaticFailoverEnabled` must be enabled for Redis (cluster mode
#' enabled) replication groups.
#'
#' Default: false
#' @param MultiAZEnabled A flag indicating if you have Multi-AZ enabled to enhance fault
#' tolerance. For more information, see [Minimizing Downtime:
#' Multi-AZ](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html).
#' @param NumCacheClusters The number of clusters this replication group initially has.
#'
#' This parameter is not used if there is more than one node group (shard).
#' You should use `ReplicasPerNodeGroup` instead.
#'
#' If `AutomaticFailoverEnabled` is `true`, the value of this parameter
#' must be at least 2. If `AutomaticFailoverEnabled` is `false` you can
#' omit this parameter (it will default to 1), or you can explicitly set it
#' to a value between 2 and 6.
#'
#' The maximum permitted value for `NumCacheClusters` is 6 (1 primary plus
#' 5 replicas).
#' @param PreferredCacheClusterAZs A list of EC2 Availability Zones in which the replication group's
#' clusters are created. The order of the Availability Zones in the list is
#' the order in which clusters are allocated. The primary cluster is
#' created in the first AZ in the list.
#'
#' This parameter is not used if there is more than one node group (shard).
#' You should use `NodeGroupConfiguration` instead.
#'
#' If you are creating your replication group in an Amazon VPC
#' (recommended), you can only locate clusters in Availability Zones
#' associated with the subnets in the selected subnet group.
#'
#' The number of Availability Zones listed must equal the value of
#' `NumCacheClusters`.
#'
#' Default: system chosen Availability Zones.
#' @param NumNodeGroups An optional parameter that specifies the number of node groups (shards)
#' for this Redis (cluster mode enabled) replication group. For Redis
#' (cluster mode disabled) either omit this parameter or set it to 1.
#'
#' Default: 1
#' @param ReplicasPerNodeGroup An optional parameter that specifies the number of replica nodes in each
#' node group (shard). Valid values are 0 to 5.
#' @param NodeGroupConfiguration A list of node group (shard) configuration options. Each node group
#' (shard) configuration has the following members:
#' `PrimaryAvailabilityZone`, `ReplicaAvailabilityZones`, `ReplicaCount`,
#' and `Slots`.
#'
#' If you're creating a Redis (cluster mode disabled) or a Redis (cluster
#' mode enabled) replication group, you can use this parameter to
#' individually configure each node group (shard), or you can omit this
#' parameter. However, it is required when seeding a Redis (cluster mode
#' enabled) cluster from a S3 rdb file. You must configure each node group
#' (shard) using this parameter because you must specify the slots for each
#' node group.
#' @param CacheNodeType The compute and memory capacity of the nodes in the node group (shard).
#'
#' The following node types are supported by ElastiCache. Generally
#' speaking, the current generation types provide more memory and
#' computational power at lower cost when compared to their equivalent
#' previous generation counterparts.
#'
#' -   General purpose:
#'
#'     -   Current generation:
#'
#'         **M6g node types** (available only for Redis engine version
#'         5.0.6 onward and for Memcached engine version 1.5.16 onward):
#'         `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`,
#'         `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`,
#'         `cache.m6g.16xlarge`
#'
#'         For region availability, see [Supported Node
#'         Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
#'
#'         **M5 node types:** `cache.m5.large`, `cache.m5.xlarge`,
#'         `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`,
#'         `cache.m5.24xlarge`
#'
#'         **M4 node types:** `cache.m4.large`, `cache.m4.xlarge`,
#'         `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`
#'
#'         **T4g node types** (available only for Redis engine version
#'         5.0.6 onward and Memcached engine version 1.5.16 onward):
#'         `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`
#'
#'         **T3 node types:** `cache.t3.micro`, `cache.t3.small`,
#'         `cache.t3.medium`
#'
#'         **T2 node types:** `cache.t2.micro`, `cache.t2.small`,
#'         `cache.t2.medium`
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **T1 node types:** `cache.t1.micro`
#'
#'         **M1 node types:** `cache.m1.small`, `cache.m1.medium`,
#'         `cache.m1.large`, `cache.m1.xlarge`
#'
#'         **M3 node types:** `cache.m3.medium`, `cache.m3.large`,
#'         `cache.m3.xlarge`, `cache.m3.2xlarge`
#'
#' -   Compute optimized:
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **C1 node types:** `cache.c1.xlarge`
#'
#' -   Memory optimized with data tiering:
#'
#'     -   Current generation:
#'
#'         **R6gd node types** (available only for Redis engine version 6.2
#'         onward).
#'
#'         `cache.r6gd.xlarge`, `cache.r6gd.2xlarge`, `cache.r6gd.4xlarge`,
#'         `cache.r6gd.8xlarge`, `cache.r6gd.12xlarge`,
#'         `cache.r6gd.16xlarge`
#'
#' -   Memory optimized:
#'
#'     -   Current generation:
#'
#'         **R6g node types** (available only for Redis engine version
#'         5.0.6 onward and for Memcached engine version 1.5.16 onward).
#'
#'         `cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`,
#'         `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`,
#'         `cache.r6g.16xlarge`
#'
#'         For region availability, see [Supported Node
#'         Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
#'
#'         **R5 node types:** `cache.r5.large`, `cache.r5.xlarge`,
#'         `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`,
#'         `cache.r5.24xlarge`
#'
#'         **R4 node types:** `cache.r4.large`, `cache.r4.xlarge`,
#'         `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`,
#'         `cache.r4.16xlarge`
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **M2 node types:** `cache.m2.xlarge`, `cache.m2.2xlarge`,
#'         `cache.m2.4xlarge`
#'
#'         **R3 node types:** `cache.r3.large`, `cache.r3.xlarge`,
#'         `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
#'
#' **Additional node type info**
#'
#' -   All current generation instance types are created in Amazon VPC by
#'     default.
#'
#' -   Redis append-only files (AOF) are not supported for T1 or T2
#'     instances.
#'
#' -   Redis Multi-AZ with automatic failover is not supported on T1
#'     instances.
#'
#' -   Redis configuration variables `appendonly` and `appendfsync` are not
#'     supported on Redis version 2.8.22 and later.
#' @param Engine The name of the cache engine to be used for the clusters in this
#' replication group. Must be Redis.
#' @param EngineVersion The version number of the cache engine to be used for the clusters in
#' this replication group. To view the supported cache engine versions, use
#' the
#' [`describe_cache_engine_versions`][elasticache_describe_cache_engine_versions]
#' operation.
#'
#' **Important:** You can upgrade to a newer engine version (see [Selecting
#' a Cache Engine and
#' Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement))
#' in the *ElastiCache User Guide*, but you cannot downgrade to an earlier
#' engine version. If you want to use an earlier engine version, you must
#' delete the existing cluster or replication group and create it anew with
#' the earlier engine version.
#' @param CacheParameterGroupName The name of the parameter group to associate with this replication
#' group. If this argument is omitted, the default cache parameter group
#' for the specified engine is used.
#'
#' If you are running Redis version 3.2.4 or later, only one node group
#' (shard), and want to use a default parameter group, we recommend that
#' you specify the parameter group by name.
#'
#' -   To create a Redis (cluster mode disabled) replication group, use
#'     `CacheParameterGroupName=default.redis3.2`.
#'
#' -   To create a Redis (cluster mode enabled) replication group, use
#'     `CacheParameterGroupName=default.redis3.2.cluster.on`.
#' @param CacheSubnetGroupName The name of the cache subnet group to be used for the replication group.
#'
#' If you're going to launch your cluster in an Amazon VPC, you need to
#' create a subnet group before you start creating a cluster. For more
#' information, see [Subnets and Subnet
#' Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html).
#' @param CacheSecurityGroupNames A list of cache security group names to associate with this replication
#' group.
#' @param SecurityGroupIds One or more Amazon VPC security groups associated with this replication
#' group.
#'
#' Use this parameter only when you are creating a replication group in an
#' Amazon Virtual Private Cloud (Amazon VPC).
#' @param Tags A list of tags to be added to this resource. Tags are comma-separated
#' key,value pairs (e.g. Key=`myKey`, Value=`myKeyValue`. You can include
#' multiple tags as shown following: Key=`myKey`, Value=`myKeyValue`
#' Key=`mySecondKey`, Value=`mySecondKeyValue`. Tags on replication groups
#' will be replicated to all nodes.
#' @param SnapshotArns A list of Amazon Resource Names (ARN) that uniquely identify the Redis
#' RDB snapshot files stored in Amazon S3. The snapshot files are used to
#' populate the new replication group. The Amazon S3 object name in the ARN
#' cannot contain any commas. The new replication group will have the
#' number of node groups (console: shards) specified by the parameter
#' *NumNodeGroups* or the number of node groups configured by
#' *NodeGroupConfiguration* regardless of the number of ARNs specified
#' here.
#'
#' Example of an Amazon S3 ARN: `arn:aws:s3:::my_bucket/snapshot1.rdb`
#' @param SnapshotName The name of a snapshot from which to restore data into the new
#' replication group. The snapshot status changes to `restoring` while the
#' new replication group is being created.
#' @param PreferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period. Valid values for `ddd` are:
#'
#' Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period.
#'
#' Valid values for `ddd` are:
#'
#' -   `sun`
#'
#' -   `mon`
#'
#' -   `tue`
#'
#' -   `wed`
#'
#' -   `thu`
#'
#' -   `fri`
#'
#' -   `sat`
#'
#' Example: `sun:23:00-mon:01:30`
#' @param Port The port number on which each member of the replication group accepts
#' connections.
#' @param NotificationTopicArn The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
#' (SNS) topic to which notifications are sent.
#'
#' The Amazon SNS topic owner must be the same as the cluster owner.
#' @param AutoMinorVersionUpgrade  If you are running Redis engine version 6.0 or later, set this
#' parameter to yes if you want to opt-in to the next auto minor version
#' upgrade campaign. This parameter is disabled for previous versions. 
#' @param SnapshotRetentionLimit The number of days for which ElastiCache retains automatic snapshots
#' before deleting them. For example, if you set `SnapshotRetentionLimit`
#' to 5, a snapshot that was taken today is retained for 5 days before
#' being deleted.
#'
#' Default: 0 (i.e., automatic backups are disabled for this cluster).
#' @param SnapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a
#' daily snapshot of your node group (shard).
#'
#' Example: `05:00-09:00`
#'
#' If you do not specify this parameter, ElastiCache automatically chooses
#' an appropriate time range.
#' @param AuthToken **Reserved parameter.** The password used to access a password protected
#' server.
#'
#' `AuthToken` can be specified only on replication groups where
#' `TransitEncryptionEnabled` is `true`.
#'
#' For HIPAA compliance, you must specify `TransitEncryptionEnabled` as
#' `true`, an `AuthToken`, and a `CacheSubnetGroup`.
#'
#' Password constraints:
#'
#' -   Must be only printable ASCII characters.
#'
#' -   Must be at least 16 characters and no more than 128 characters in
#'     length.
#'
#' -   The only permitted printable special characters are !, &, #, $, ^,
#'     \<, \>, and -. Other printable special characters cannot be used in
#'     the AUTH token.
#'
#' For more information, see [AUTH
#' password](https://redis.io/commands/auth/) at
#' http://redis.io/commands/AUTH.
#' @param TransitEncryptionEnabled A flag that enables in-transit encryption when set to `true`.
#'
#' You cannot modify the value of `TransitEncryptionEnabled` after the
#' cluster is created. To enable in-transit encryption on a cluster you
#' must set `TransitEncryptionEnabled` to `true` when you create a cluster.
#'
#' This parameter is valid only if the `Engine` parameter is `redis`, the
#' `EngineVersion` parameter is `3.2.6`, `4.x` or later, and the cluster is
#' being created in an Amazon VPC.
#'
#' If you enable in-transit encryption, you must also specify a value for
#' `CacheSubnetGroup`.
#'
#' **Required:** Only available when creating a replication group in an
#' Amazon VPC using redis version `3.2.6`, `4.x` or later.
#'
#' Default: `false`
#'
#' For HIPAA compliance, you must specify `TransitEncryptionEnabled` as
#' `true`, an `AuthToken`, and a `CacheSubnetGroup`.
#' @param AtRestEncryptionEnabled A flag that enables encryption at rest when set to `true`.
#'
#' You cannot modify the value of `AtRestEncryptionEnabled` after the
#' replication group is created. To enable encryption at rest on a
#' replication group you must set `AtRestEncryptionEnabled` to `true` when
#' you create the replication group.
#'
#' **Required:** Only available when creating a replication group in an
#' Amazon VPC using redis version `3.2.6`, `4.x` or later.
#'
#' Default: `false`
#' @param KmsKeyId The ID of the KMS key used to encrypt the disk in the cluster.
#' @param UserGroupIds The user group to associate with the replication group.
#' @param LogDeliveryConfigurations Specifies the destination, format and type of the logs.
#' @param DataTieringEnabled Enables data tiering. Data tiering is only supported for replication
#' groups using the r6gd node type. This parameter must be set to true when
#' using r6gd nodes. For more information, see [Data
#' tiering](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html).
#'
#' @keywords internal
#'
#' @rdname elasticache_create_replication_group
elasticache_create_replication_group <- function(ReplicationGroupId, ReplicationGroupDescription, GlobalReplicationGroupId = NULL, PrimaryClusterId = NULL, AutomaticFailoverEnabled = NULL, MultiAZEnabled = NULL, NumCacheClusters = NULL, PreferredCacheClusterAZs = NULL, NumNodeGroups = NULL, ReplicasPerNodeGroup = NULL, NodeGroupConfiguration = NULL, CacheNodeType = NULL, Engine = NULL, EngineVersion = NULL, CacheParameterGroupName = NULL, CacheSubnetGroupName = NULL, CacheSecurityGroupNames = NULL, SecurityGroupIds = NULL, Tags = NULL, SnapshotArns = NULL, SnapshotName = NULL, PreferredMaintenanceWindow = NULL, Port = NULL, NotificationTopicArn = NULL, AutoMinorVersionUpgrade = NULL, SnapshotRetentionLimit = NULL, SnapshotWindow = NULL, AuthToken = NULL, TransitEncryptionEnabled = NULL, AtRestEncryptionEnabled = NULL, KmsKeyId = NULL, UserGroupIds = NULL, LogDeliveryConfigurations = NULL, DataTieringEnabled = NULL) {
  op <- new_operation(
    name = "CreateReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_replication_group_input(ReplicationGroupId = ReplicationGroupId, ReplicationGroupDescription = ReplicationGroupDescription, GlobalReplicationGroupId = GlobalReplicationGroupId, PrimaryClusterId = PrimaryClusterId, AutomaticFailoverEnabled = AutomaticFailoverEnabled, MultiAZEnabled = MultiAZEnabled, NumCacheClusters = NumCacheClusters, PreferredCacheClusterAZs = PreferredCacheClusterAZs, NumNodeGroups = NumNodeGroups, ReplicasPerNodeGroup = ReplicasPerNodeGroup, NodeGroupConfiguration = NodeGroupConfiguration, CacheNodeType = CacheNodeType, Engine = Engine, EngineVersion = EngineVersion, CacheParameterGroupName = CacheParameterGroupName, CacheSubnetGroupName = CacheSubnetGroupName, CacheSecurityGroupNames = CacheSecurityGroupNames, SecurityGroupIds = SecurityGroupIds, Tags = Tags, SnapshotArns = SnapshotArns, SnapshotName = SnapshotName, PreferredMaintenanceWindow = PreferredMaintenanceWindow, Port = Port, NotificationTopicArn = NotificationTopicArn, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, SnapshotRetentionLimit = SnapshotRetentionLimit, SnapshotWindow = SnapshotWindow, AuthToken = AuthToken, TransitEncryptionEnabled = TransitEncryptionEnabled, AtRestEncryptionEnabled = AtRestEncryptionEnabled, KmsKeyId = KmsKeyId, UserGroupIds = UserGroupIds, LogDeliveryConfigurations = LogDeliveryConfigurations, DataTieringEnabled = DataTieringEnabled)
  output <- .elasticache$create_replication_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_replication_group <- elasticache_create_replication_group

#' Creates a copy of an entire cluster or replication group at a specific
#' moment in time
#'
#' @description
#' Creates a copy of an entire cluster or replication group at a specific moment in time.
#'
#' See [https://paws-r.github.io/docs/elasticache/create_snapshot.html](https://paws-r.github.io/docs/elasticache/create_snapshot.html) for full documentation.
#'
#' @param ReplicationGroupId The identifier of an existing replication group. The snapshot is created
#' from this replication group.
#' @param CacheClusterId The identifier of an existing cluster. The snapshot is created from this
#' cluster.
#' @param SnapshotName &#91;required&#93; A name for the snapshot being created.
#' @param KmsKeyId The ID of the KMS key used to encrypt the snapshot.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname elasticache_create_snapshot
elasticache_create_snapshot <- function(ReplicationGroupId = NULL, CacheClusterId = NULL, SnapshotName, KmsKeyId = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_snapshot_input(ReplicationGroupId = ReplicationGroupId, CacheClusterId = CacheClusterId, SnapshotName = SnapshotName, KmsKeyId = KmsKeyId, Tags = Tags)
  output <- .elasticache$create_snapshot_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_snapshot <- elasticache_create_snapshot

#' For Redis engine version 6
#'
#' @description
#' For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see [Using Role Based Access Control (RBAC)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
#'
#' See [https://paws-r.github.io/docs/elasticache/create_user.html](https://paws-r.github.io/docs/elasticache/create_user.html) for full documentation.
#'
#' @param UserId &#91;required&#93; The ID of the user.
#' @param UserName &#91;required&#93; The username of the user.
#' @param Engine &#91;required&#93; The current supported value is Redis.
#' @param Passwords Passwords used for this user. You can create up to two passwords for
#' each user.
#' @param AccessString &#91;required&#93; Access permissions string used for this user.
#' @param NoPasswordRequired Indicates a password is not required for this user.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname elasticache_create_user
elasticache_create_user <- function(UserId, UserName, Engine, Passwords = NULL, AccessString, NoPasswordRequired = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_user_input(UserId = UserId, UserName = UserName, Engine = Engine, Passwords = Passwords, AccessString = AccessString, NoPasswordRequired = NoPasswordRequired, Tags = Tags)
  output <- .elasticache$create_user_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_user <- elasticache_create_user

#' For Redis engine version 6
#'
#' @description
#' For Redis engine version 6.0 onwards: Creates a Redis user group. For more information, see [Using Role Based Access Control (RBAC)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html)
#'
#' See [https://paws-r.github.io/docs/elasticache/create_user_group.html](https://paws-r.github.io/docs/elasticache/create_user_group.html) for full documentation.
#'
#' @param UserGroupId &#91;required&#93; The ID of the user group.
#' @param Engine &#91;required&#93; The current supported value is Redis.
#' @param UserIds The list of user IDs that belong to the user group.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname elasticache_create_user_group
elasticache_create_user_group <- function(UserGroupId, Engine, UserIds = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateUserGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_user_group_input(UserGroupId = UserGroupId, Engine = Engine, UserIds = UserIds, Tags = Tags)
  output <- .elasticache$create_user_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_user_group <- elasticache_create_user_group

#' Decreases the number of node groups in a Global datastore
#'
#' @description
#' Decreases the number of node groups in a Global datastore
#'
#' See [https://paws-r.github.io/docs/elasticache/decrease_node_groups_in_global_replication_group.html](https://paws-r.github.io/docs/elasticache/decrease_node_groups_in_global_replication_group.html) for full documentation.
#'
#' @param GlobalReplicationGroupId &#91;required&#93; The name of the Global datastore
#' @param NodeGroupCount &#91;required&#93; The number of node groups (shards) that results from the modification of
#' the shard configuration
#' @param GlobalNodeGroupsToRemove If the value of NodeGroupCount is less than the current number of node
#' groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is
#' required. GlobalNodeGroupsToRemove is a list of NodeGroupIds to remove
#' from the cluster. ElastiCache for Redis will attempt to remove all node
#' groups listed by GlobalNodeGroupsToRemove from the cluster.
#' @param GlobalNodeGroupsToRetain If the value of NodeGroupCount is less than the current number of node
#' groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is
#' required. GlobalNodeGroupsToRetain is a list of NodeGroupIds to retain
#' from the cluster. ElastiCache for Redis will attempt to retain all node
#' groups listed by GlobalNodeGroupsToRetain from the cluster.
#' @param ApplyImmediately &#91;required&#93; Indicates that the shard reconfiguration process begins immediately. At
#' present, the only permitted value for this parameter is true.
#'
#' @keywords internal
#'
#' @rdname elasticache_decrease_node_groups_in_global_replication_group
elasticache_decrease_node_groups_in_global_replication_group <- function(GlobalReplicationGroupId, NodeGroupCount, GlobalNodeGroupsToRemove = NULL, GlobalNodeGroupsToRetain = NULL, ApplyImmediately) {
  op <- new_operation(
    name = "DecreaseNodeGroupsInGlobalReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$decrease_node_groups_in_global_replication_group_input(GlobalReplicationGroupId = GlobalReplicationGroupId, NodeGroupCount = NodeGroupCount, GlobalNodeGroupsToRemove = GlobalNodeGroupsToRemove, GlobalNodeGroupsToRetain = GlobalNodeGroupsToRetain, ApplyImmediately = ApplyImmediately)
  output <- .elasticache$decrease_node_groups_in_global_replication_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$decrease_node_groups_in_global_replication_group <- elasticache_decrease_node_groups_in_global_replication_group

#' Dynamically decreases the number of replicas in a Redis (cluster mode
#' disabled) replication group or the number of replica nodes in one or
#' more node groups (shards) of a Redis (cluster mode enabled) replication
#' group
#'
#' @description
#' Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
#'
#' See [https://paws-r.github.io/docs/elasticache/decrease_replica_count.html](https://paws-r.github.io/docs/elasticache/decrease_replica_count.html) for full documentation.
#'
#' @param ReplicationGroupId &#91;required&#93; The id of the replication group from which you want to remove replica
#' nodes.
#' @param NewReplicaCount The number of read replica nodes you want at the completion of this
#' operation. For Redis (cluster mode disabled) replication groups, this is
#' the number of replica nodes in the replication group. For Redis (cluster
#' mode enabled) replication groups, this is the number of replica nodes in
#' each of the replication group's node groups.
#'
#' The minimum number of replicas in a shard or replication group is:
#'
#' -   Redis (cluster mode disabled)
#'
#'     -   If Multi-AZ is enabled: 1
#'
#'     -   If Multi-AZ is not enabled: 0
#'
#' -   Redis (cluster mode enabled): 0 (though you will not be able to
#'     failover to a replica if your primary node fails)
#' @param ReplicaConfiguration A list of `ConfigureShard` objects that can be used to configure each
#' shard in a Redis (cluster mode enabled) replication group. The
#' `ConfigureShard` has three members: `NewReplicaCount`, `NodeGroupId`,
#' and `PreferredAvailabilityZones`.
#' @param ReplicasToRemove A list of the node ids to remove from the replication group or node
#' group (shard).
#' @param ApplyImmediately &#91;required&#93; If `True`, the number of replica nodes is decreased immediately.
#' `ApplyImmediately=False` is not currently supported.
#'
#' @keywords internal
#'
#' @rdname elasticache_decrease_replica_count
elasticache_decrease_replica_count <- function(ReplicationGroupId, NewReplicaCount = NULL, ReplicaConfiguration = NULL, ReplicasToRemove = NULL, ApplyImmediately) {
  op <- new_operation(
    name = "DecreaseReplicaCount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$decrease_replica_count_input(ReplicationGroupId = ReplicationGroupId, NewReplicaCount = NewReplicaCount, ReplicaConfiguration = ReplicaConfiguration, ReplicasToRemove = ReplicasToRemove, ApplyImmediately = ApplyImmediately)
  output <- .elasticache$decrease_replica_count_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$decrease_replica_count <- elasticache_decrease_replica_count

#' Deletes a previously provisioned cluster
#'
#' @description
#' Deletes a previously provisioned cluster. [`delete_cache_cluster`][elasticache_delete_cache_cluster] deletes all associated cache nodes, node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.
#'
#' See [https://paws-r.github.io/docs/elasticache/delete_cache_cluster.html](https://paws-r.github.io/docs/elasticache/delete_cache_cluster.html) for full documentation.
#'
#' @param CacheClusterId &#91;required&#93; The cluster identifier for the cluster to be deleted. This parameter is
#' not case sensitive.
#' @param FinalSnapshotIdentifier The user-supplied name of a final cluster snapshot. This is the unique
#' name that identifies the snapshot. ElastiCache creates the snapshot, and
#' then deletes the cluster immediately afterward.
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_cache_cluster
elasticache_delete_cache_cluster <- function(CacheClusterId, FinalSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteCacheCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_cache_cluster_input(CacheClusterId = CacheClusterId, FinalSnapshotIdentifier = FinalSnapshotIdentifier)
  output <- .elasticache$delete_cache_cluster_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_cache_cluster <- elasticache_delete_cache_cluster

#' Deletes the specified cache parameter group
#'
#' @description
#' Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with any cache clusters. You cannot delete the default cache parameter groups in your account.
#'
#' See [https://paws-r.github.io/docs/elasticache/delete_cache_parameter_group.html](https://paws-r.github.io/docs/elasticache/delete_cache_parameter_group.html) for full documentation.
#'
#' @param CacheParameterGroupName &#91;required&#93; The name of the cache parameter group to delete.
#'
#' The specified cache security group must not be associated with any
#' clusters.
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_cache_parameter_group
elasticache_delete_cache_parameter_group <- function(CacheParameterGroupName) {
  op <- new_operation(
    name = "DeleteCacheParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_cache_parameter_group_input(CacheParameterGroupName = CacheParameterGroupName)
  output <- .elasticache$delete_cache_parameter_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_cache_parameter_group <- elasticache_delete_cache_parameter_group

#' Deletes a cache security group
#'
#' @description
#' Deletes a cache security group.
#'
#' See [https://paws-r.github.io/docs/elasticache/delete_cache_security_group.html](https://paws-r.github.io/docs/elasticache/delete_cache_security_group.html) for full documentation.
#'
#' @param CacheSecurityGroupName &#91;required&#93; The name of the cache security group to delete.
#'
#' You cannot delete the default security group.
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_cache_security_group
elasticache_delete_cache_security_group <- function(CacheSecurityGroupName) {
  op <- new_operation(
    name = "DeleteCacheSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_cache_security_group_input(CacheSecurityGroupName = CacheSecurityGroupName)
  output <- .elasticache$delete_cache_security_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_cache_security_group <- elasticache_delete_cache_security_group

#' Deletes a cache subnet group
#'
#' @description
#' Deletes a cache subnet group.
#'
#' See [https://paws-r.github.io/docs/elasticache/delete_cache_subnet_group.html](https://paws-r.github.io/docs/elasticache/delete_cache_subnet_group.html) for full documentation.
#'
#' @param CacheSubnetGroupName &#91;required&#93; The name of the cache subnet group to delete.
#'
#' Constraints: Must contain no more than 255 alphanumeric characters or
#' hyphens.
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_cache_subnet_group
elasticache_delete_cache_subnet_group <- function(CacheSubnetGroupName) {
  op <- new_operation(
    name = "DeleteCacheSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_cache_subnet_group_input(CacheSubnetGroupName = CacheSubnetGroupName)
  output <- .elasticache$delete_cache_subnet_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_cache_subnet_group <- elasticache_delete_cache_subnet_group

#' Deleting a Global datastore is a two-step process:
#'
#' @description
#' Deleting a Global datastore is a two-step process:
#'
#' See [https://paws-r.github.io/docs/elasticache/delete_global_replication_group.html](https://paws-r.github.io/docs/elasticache/delete_global_replication_group.html) for full documentation.
#'
#' @param GlobalReplicationGroupId &#91;required&#93; The name of the Global datastore
#' @param RetainPrimaryReplicationGroup &#91;required&#93; The primary replication group is retained as a standalone replication
#' group.
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_global_replication_group
elasticache_delete_global_replication_group <- function(GlobalReplicationGroupId, RetainPrimaryReplicationGroup) {
  op <- new_operation(
    name = "DeleteGlobalReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_global_replication_group_input(GlobalReplicationGroupId = GlobalReplicationGroupId, RetainPrimaryReplicationGroup = RetainPrimaryReplicationGroup)
  output <- .elasticache$delete_global_replication_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_global_replication_group <- elasticache_delete_global_replication_group

#' Deletes an existing replication group
#'
#' @description
#' Deletes an existing replication group. By default, this operation deletes the entire replication group, including the primary/primaries and all of the read replicas. If the replication group has only one primary, you can optionally delete only the read replicas, while retaining the primary by setting `RetainPrimaryCluster=true`.
#'
#' See [https://paws-r.github.io/docs/elasticache/delete_replication_group.html](https://paws-r.github.io/docs/elasticache/delete_replication_group.html) for full documentation.
#'
#' @param ReplicationGroupId &#91;required&#93; The identifier for the cluster to be deleted. This parameter is not case
#' sensitive.
#' @param RetainPrimaryCluster If set to `true`, all of the read replicas are deleted, but the primary
#' node is retained.
#' @param FinalSnapshotIdentifier The name of a final node group (shard) snapshot. ElastiCache creates the
#' snapshot from the primary node in the cluster, rather than one of the
#' replicas; this is to ensure that it captures the freshest data. After
#' the final snapshot is taken, the replication group is immediately
#' deleted.
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_replication_group
elasticache_delete_replication_group <- function(ReplicationGroupId, RetainPrimaryCluster = NULL, FinalSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_replication_group_input(ReplicationGroupId = ReplicationGroupId, RetainPrimaryCluster = RetainPrimaryCluster, FinalSnapshotIdentifier = FinalSnapshotIdentifier)
  output <- .elasticache$delete_replication_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_replication_group <- elasticache_delete_replication_group

#' Deletes an existing snapshot
#'
#' @description
#' Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately begins deleting the snapshot; you cannot cancel or revert this operation.
#'
#' See [https://paws-r.github.io/docs/elasticache/delete_snapshot.html](https://paws-r.github.io/docs/elasticache/delete_snapshot.html) for full documentation.
#'
#' @param SnapshotName &#91;required&#93; The name of the snapshot to be deleted.
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_snapshot
elasticache_delete_snapshot <- function(SnapshotName) {
  op <- new_operation(
    name = "DeleteSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_snapshot_input(SnapshotName = SnapshotName)
  output <- .elasticache$delete_snapshot_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_snapshot <- elasticache_delete_snapshot

#' For Redis engine version 6
#'
#' @description
#' For Redis engine version 6.0 onwards: Deletes a user. The user will be removed from all user groups and in turn removed from all replication groups. For more information, see [Using Role Based Access Control (RBAC)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
#'
#' See [https://paws-r.github.io/docs/elasticache/delete_user.html](https://paws-r.github.io/docs/elasticache/delete_user.html) for full documentation.
#'
#' @param UserId &#91;required&#93; The ID of the user.
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_user
elasticache_delete_user <- function(UserId) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_user_input(UserId = UserId)
  output <- .elasticache$delete_user_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_user <- elasticache_delete_user

#' For Redis engine version 6
#'
#' @description
#' For Redis engine version 6.0 onwards: Deletes a user group. The user group must first be disassociated from the replication group before it can be deleted. For more information, see [Using Role Based Access Control (RBAC)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
#'
#' See [https://paws-r.github.io/docs/elasticache/delete_user_group.html](https://paws-r.github.io/docs/elasticache/delete_user_group.html) for full documentation.
#'
#' @param UserGroupId &#91;required&#93; The ID of the user group.
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_user_group
elasticache_delete_user_group <- function(UserGroupId) {
  op <- new_operation(
    name = "DeleteUserGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_user_group_input(UserGroupId = UserGroupId)
  output <- .elasticache$delete_user_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_user_group <- elasticache_delete_user_group

#' Returns information about all provisioned clusters if no cluster
#' identifier is specified, or about a specific cache cluster if a cluster
#' identifier is supplied
#'
#' @description
#' Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cache cluster if a cluster identifier is supplied.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_cache_clusters.html](https://paws-r.github.io/docs/elasticache/describe_cache_clusters.html) for full documentation.
#'
#' @param CacheClusterId The user-supplied cluster identifier. If this parameter is specified,
#' only information about that specific cluster is returned. This parameter
#' isn't case sensitive.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 100
#'
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#' @param ShowCacheNodeInfo An optional flag that can be included in the `DescribeCacheCluster`
#' request to retrieve information about the individual cache nodes.
#' @param ShowCacheClustersNotInReplicationGroups An optional flag that can be included in the `DescribeCacheCluster`
#' request to show only nodes (API/CLI: clusters) that are not members of a
#' replication group. In practice, this mean Memcached and single node
#' Redis clusters.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_clusters
elasticache_describe_cache_clusters <- function(CacheClusterId = NULL, MaxRecords = NULL, Marker = NULL, ShowCacheNodeInfo = NULL, ShowCacheClustersNotInReplicationGroups = NULL) {
  op <- new_operation(
    name = "DescribeCacheClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_clusters_input(CacheClusterId = CacheClusterId, MaxRecords = MaxRecords, Marker = Marker, ShowCacheNodeInfo = ShowCacheNodeInfo, ShowCacheClustersNotInReplicationGroups = ShowCacheClustersNotInReplicationGroups)
  output <- .elasticache$describe_cache_clusters_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_clusters <- elasticache_describe_cache_clusters

#' Returns a list of the available cache engines and their versions
#'
#' @description
#' Returns a list of the available cache engines and their versions.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_cache_engine_versions.html](https://paws-r.github.io/docs/elasticache/describe_cache_engine_versions.html) for full documentation.
#'
#' @param Engine The cache engine to return. Valid values: `memcached` | `redis`
#' @param EngineVersion The cache engine version to return.
#'
#' Example: `1.4.14`
#' @param CacheParameterGroupFamily The name of a specific cache parameter group family to return details
#' for.
#'
#' Valid values are: `memcached1.4` | `memcached1.5` | `memcached1.6` |
#' `redis2.6` | `redis2.8` | `redis3.2` | `redis4.0` | `redis5.0` |
#' `redis6.x` | `redis6.2`
#'
#' Constraints:
#'
#' -   Must be 1 to 255 alphanumeric characters
#'
#' -   First character must be a letter
#'
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 100
#'
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#' @param DefaultOnly If `true`, specifies that only the default version of the specified
#' engine or engine and major version combination is to be returned.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_engine_versions
elasticache_describe_cache_engine_versions <- function(Engine = NULL, EngineVersion = NULL, CacheParameterGroupFamily = NULL, MaxRecords = NULL, Marker = NULL, DefaultOnly = NULL) {
  op <- new_operation(
    name = "DescribeCacheEngineVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_engine_versions_input(Engine = Engine, EngineVersion = EngineVersion, CacheParameterGroupFamily = CacheParameterGroupFamily, MaxRecords = MaxRecords, Marker = Marker, DefaultOnly = DefaultOnly)
  output <- .elasticache$describe_cache_engine_versions_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_engine_versions <- elasticache_describe_cache_engine_versions

#' Returns a list of cache parameter group descriptions
#'
#' @description
#' Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list contains only the descriptions for that group.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_cache_parameter_groups.html](https://paws-r.github.io/docs/elasticache/describe_cache_parameter_groups.html) for full documentation.
#'
#' @param CacheParameterGroupName The name of a specific cache parameter group to return details for.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 100
#'
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_parameter_groups
elasticache_describe_cache_parameter_groups <- function(CacheParameterGroupName = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCacheParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_parameter_groups_input(CacheParameterGroupName = CacheParameterGroupName, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_cache_parameter_groups_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_parameter_groups <- elasticache_describe_cache_parameter_groups

#' Returns the detailed parameter list for a particular cache parameter
#' group
#'
#' @description
#' Returns the detailed parameter list for a particular cache parameter group.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_cache_parameters.html](https://paws-r.github.io/docs/elasticache/describe_cache_parameters.html) for full documentation.
#'
#' @param CacheParameterGroupName &#91;required&#93; The name of a specific cache parameter group to return details for.
#' @param Source The parameter types to return.
#'
#' Valid values: `user` | `system` | `engine-default`
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 100
#'
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_parameters
elasticache_describe_cache_parameters <- function(CacheParameterGroupName, Source = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCacheParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_parameters_input(CacheParameterGroupName = CacheParameterGroupName, Source = Source, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_cache_parameters_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_parameters <- elasticache_describe_cache_parameters

#' Returns a list of cache security group descriptions
#'
#' @description
#' Returns a list of cache security group descriptions. If a cache security group name is specified, the list contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_cache_security_groups.html](https://paws-r.github.io/docs/elasticache/describe_cache_security_groups.html) for full documentation.
#'
#' @param CacheSecurityGroupName The name of the cache security group to return details for.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 100
#'
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_security_groups
elasticache_describe_cache_security_groups <- function(CacheSecurityGroupName = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCacheSecurityGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_security_groups_input(CacheSecurityGroupName = CacheSecurityGroupName, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_cache_security_groups_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_security_groups <- elasticache_describe_cache_security_groups

#' Returns a list of cache subnet group descriptions
#'
#' @description
#' Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache clusters now launch in VPC by default.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_cache_subnet_groups.html](https://paws-r.github.io/docs/elasticache/describe_cache_subnet_groups.html) for full documentation.
#'
#' @param CacheSubnetGroupName The name of the cache subnet group to return details for.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 100
#'
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_subnet_groups
elasticache_describe_cache_subnet_groups <- function(CacheSubnetGroupName = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCacheSubnetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_subnet_groups_input(CacheSubnetGroupName = CacheSubnetGroupName, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_cache_subnet_groups_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_subnet_groups <- elasticache_describe_cache_subnet_groups

#' Returns the default engine and system parameter information for the
#' specified cache engine
#'
#' @description
#' Returns the default engine and system parameter information for the specified cache engine.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_engine_default_parameters.html](https://paws-r.github.io/docs/elasticache/describe_engine_default_parameters.html) for full documentation.
#'
#' @param CacheParameterGroupFamily &#91;required&#93; The name of the cache parameter group family.
#'
#' Valid values are: `memcached1.4` | `memcached1.5` | `memcached1.6` |
#' `redis2.6` | `redis2.8` | `redis3.2` | `redis4.0` | `redis5.0` |
#' `redis6.x` | `redis6.2`
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 100
#'
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_engine_default_parameters
elasticache_describe_engine_default_parameters <- function(CacheParameterGroupFamily, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_engine_default_parameters_input(CacheParameterGroupFamily = CacheParameterGroupFamily, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_engine_default_parameters_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_engine_default_parameters <- elasticache_describe_engine_default_parameters

#' Returns events related to clusters, cache security groups, and cache
#' parameter groups
#'
#' @description
#' Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events specific to a particular cluster, cache security group, or cache parameter group by providing the name as a parameter.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_events.html](https://paws-r.github.io/docs/elasticache/describe_events.html) for full documentation.
#'
#' @param SourceIdentifier The identifier of the event source for which events are returned. If not
#' specified, all sources are included in the response.
#' @param SourceType The event source to retrieve events for. If no value is specified, all
#' events are returned.
#' @param StartTime The beginning of the time interval to retrieve events for, specified in
#' ISO 8601 format.
#'
#' **Example:** 2017-03-30T07:03:49.555Z
#' @param EndTime The end of the time interval for which to retrieve events, specified in
#' ISO 8601 format.
#'
#' **Example:** 2017-03-30T07:03:49.555Z
#' @param Duration The number of minutes worth of events to retrieve.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 100
#'
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_events
elasticache_describe_events <- function(SourceIdentifier = NULL, SourceType = NULL, StartTime = NULL, EndTime = NULL, Duration = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_events_input(SourceIdentifier = SourceIdentifier, SourceType = SourceType, StartTime = StartTime, EndTime = EndTime, Duration = Duration, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_events_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_events <- elasticache_describe_events

#' Returns information about a particular global replication group
#'
#' @description
#' Returns information about a particular global replication group. If no identifier is specified, returns information about all Global datastores.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_global_replication_groups.html](https://paws-r.github.io/docs/elasticache/describe_global_replication_groups.html) for full documentation.
#'
#' @param GlobalReplicationGroupId The name of the Global datastore
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified MaxRecords value, a marker is included
#' in the response so that the remaining results can be retrieved.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#' @param ShowMemberInfo Returns the list of members that comprise the Global datastore.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_global_replication_groups
elasticache_describe_global_replication_groups <- function(GlobalReplicationGroupId = NULL, MaxRecords = NULL, Marker = NULL, ShowMemberInfo = NULL) {
  op <- new_operation(
    name = "DescribeGlobalReplicationGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_global_replication_groups_input(GlobalReplicationGroupId = GlobalReplicationGroupId, MaxRecords = MaxRecords, Marker = Marker, ShowMemberInfo = ShowMemberInfo)
  output <- .elasticache$describe_global_replication_groups_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_global_replication_groups <- elasticache_describe_global_replication_groups

#' Returns information about a particular replication group
#'
#' @description
#' Returns information about a particular replication group. If no identifier is specified, [`describe_replication_groups`][elasticache_describe_replication_groups] returns information about all replication groups.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_replication_groups.html](https://paws-r.github.io/docs/elasticache/describe_replication_groups.html) for full documentation.
#'
#' @param ReplicationGroupId The identifier for the replication group to be described. This parameter
#' is not case sensitive.
#'
#' If you do not specify this parameter, information about all replication
#' groups is returned.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 100
#'
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_replication_groups
elasticache_describe_replication_groups <- function(ReplicationGroupId = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReplicationGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_replication_groups_input(ReplicationGroupId = ReplicationGroupId, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_replication_groups_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_replication_groups <- elasticache_describe_replication_groups

#' Returns information about reserved cache nodes for this account, or
#' about a specified reserved cache node
#'
#' @description
#' Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_reserved_cache_nodes.html](https://paws-r.github.io/docs/elasticache/describe_reserved_cache_nodes.html) for full documentation.
#'
#' @param ReservedCacheNodeId The reserved cache node identifier filter value. Use this parameter to
#' show only the reservation that matches the specified reservation ID.
#' @param ReservedCacheNodesOfferingId The offering identifier filter value. Use this parameter to show only
#' purchased reservations matching the specified offering identifier.
#' @param CacheNodeType The cache node type filter value. Use this parameter to show only those
#' reservations matching the specified cache node type.
#'
#' The following node types are supported by ElastiCache. Generally
#' speaking, the current generation types provide more memory and
#' computational power at lower cost when compared to their equivalent
#' previous generation counterparts.
#'
#' -   General purpose:
#'
#'     -   Current generation:
#'
#'         **M6g node types:** (available only for Redis engine version
#'         5.0.6 onward and for Memcached engine version 1.5.16 onward):
#'         `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`,
#'         `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`,
#'         `cache.m6g.16xlarge`
#'
#'         For region availability, see [Supported Node
#'         Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
#'
#'         **M5 node types:** `cache.m5.large`, `cache.m5.xlarge`,
#'         `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`,
#'         `cache.m5.24xlarge`
#'
#'         **M4 node types:** `cache.m4.large`, `cache.m4.xlarge`,
#'         `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`
#'
#'         **T4g node types** (available only for Redis engine version
#'         5.0.6 onward and for Memcached engine version 1.5.16 onward):
#'         `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`
#'
#'         **T3 node types:** `cache.t3.micro`, `cache.t3.small`,
#'         `cache.t3.medium`
#'
#'         **T2 node types:** `cache.t2.micro`, `cache.t2.small`,
#'         `cache.t2.medium`
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **T1 node types:** `cache.t1.micro`
#'
#'         **M1 node types:** `cache.m1.small`, `cache.m1.medium`,
#'         `cache.m1.large`, `cache.m1.xlarge`
#'
#'         **M3 node types:** `cache.m3.medium`, `cache.m3.large`,
#'         `cache.m3.xlarge`, `cache.m3.2xlarge`
#'
#' -   Compute optimized:
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **C1 node types:** `cache.c1.xlarge`
#'
#' -   Memory optimized with data tiering:
#'
#'     -   Current generation:
#'
#'         **R6gd node types** (available only for Redis engine version 6.2
#'         onward).
#'
#'         `cache.r6gd.xlarge`, `cache.r6gd.2xlarge`, `cache.r6gd.4xlarge`,
#'         `cache.r6gd.8xlarge`, `cache.r6gd.12xlarge`,
#'         `cache.r6gd.16xlarge`
#'
#' -   Memory optimized:
#'
#'     -   Current generation:
#'
#'         **R6g node types** (available only for Redis engine version
#'         5.0.6 onward and for Memcached engine version 1.5.16 onward).
#'
#'         `cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`,
#'         `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`,
#'         `cache.r6g.16xlarge`
#'
#'         For region availability, see [Supported Node
#'         Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
#'
#'         **R5 node types:** `cache.r5.large`, `cache.r5.xlarge`,
#'         `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`,
#'         `cache.r5.24xlarge`
#'
#'         **R4 node types:** `cache.r4.large`, `cache.r4.xlarge`,
#'         `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`,
#'         `cache.r4.16xlarge`
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **M2 node types:** `cache.m2.xlarge`, `cache.m2.2xlarge`,
#'         `cache.m2.4xlarge`
#'
#'         **R3 node types:** `cache.r3.large`, `cache.r3.xlarge`,
#'         `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
#'
#' **Additional node type info**
#'
#' -   All current generation instance types are created in Amazon VPC by
#'     default.
#'
#' -   Redis append-only files (AOF) are not supported for T1 or T2
#'     instances.
#'
#' -   Redis Multi-AZ with automatic failover is not supported on T1
#'     instances.
#'
#' -   Redis configuration variables `appendonly` and `appendfsync` are not
#'     supported on Redis version 2.8.22 and later.
#' @param Duration The duration filter value, specified in years or seconds. Use this
#' parameter to show only reservations for this duration.
#'
#' Valid Values: `1 | 3 | 31536000 | 94608000`
#' @param ProductDescription The product description filter value. Use this parameter to show only
#' those reservations matching the specified product description.
#' @param OfferingType The offering type filter value. Use this parameter to show only the
#' available offerings matching the specified offering type.
#'
#' Valid values:
#' `"Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"`
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 100
#'
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_reserved_cache_nodes
elasticache_describe_reserved_cache_nodes <- function(ReservedCacheNodeId = NULL, ReservedCacheNodesOfferingId = NULL, CacheNodeType = NULL, Duration = NULL, ProductDescription = NULL, OfferingType = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReservedCacheNodes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_reserved_cache_nodes_input(ReservedCacheNodeId = ReservedCacheNodeId, ReservedCacheNodesOfferingId = ReservedCacheNodesOfferingId, CacheNodeType = CacheNodeType, Duration = Duration, ProductDescription = ProductDescription, OfferingType = OfferingType, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_reserved_cache_nodes_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_reserved_cache_nodes <- elasticache_describe_reserved_cache_nodes

#' Lists available reserved cache node offerings
#'
#' @description
#' Lists available reserved cache node offerings.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_reserved_cache_nodes_offerings.html](https://paws-r.github.io/docs/elasticache/describe_reserved_cache_nodes_offerings.html) for full documentation.
#'
#' @param ReservedCacheNodesOfferingId The offering identifier filter value. Use this parameter to show only
#' the available offering that matches the specified reservation
#' identifier.
#'
#' Example: `438012d3-4052-4cc7-b2e3-8d3372e0e706`
#' @param CacheNodeType The cache node type filter value. Use this parameter to show only the
#' available offerings matching the specified cache node type.
#'
#' The following node types are supported by ElastiCache. Generally
#' speaking, the current generation types provide more memory and
#' computational power at lower cost when compared to their equivalent
#' previous generation counterparts.
#'
#' -   General purpose:
#'
#'     -   Current generation:
#'
#'         **M6g node types:** (available only for Redis engine version
#'         5.0.6 onward and for Memcached engine version 1.5.16 onward)
#'         `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`,
#'         `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`,
#'         `cache.m6g.16xlarge`
#'
#'         For region availability, see [Supported Node
#'         Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
#'
#'         **M5 node types:** `cache.m5.large`, `cache.m5.xlarge`,
#'         `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`,
#'         `cache.m5.24xlarge`
#'
#'         **M4 node types:** `cache.m4.large`, `cache.m4.xlarge`,
#'         `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`
#'
#'         **T4g node types** (available only for Redis engine version
#'         5.0.6 onward and for Memcached engine version 1.5.16 onward):
#'         `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`
#'
#'         **T3 node types:** `cache.t3.micro`, `cache.t3.small`,
#'         `cache.t3.medium`
#'
#'         **T2 node types:** `cache.t2.micro`, `cache.t2.small`,
#'         `cache.t2.medium`
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **T1 node types:** `cache.t1.micro`
#'
#'         **M1 node types:** `cache.m1.small`, `cache.m1.medium`,
#'         `cache.m1.large`, `cache.m1.xlarge`
#'
#'         **M3 node types:** `cache.m3.medium`, `cache.m3.large`,
#'         `cache.m3.xlarge`, `cache.m3.2xlarge`
#'
#' -   Compute optimized:
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **C1 node types:** `cache.c1.xlarge`
#'
#' -   Memory optimized with data tiering:
#'
#'     -   Current generation:
#'
#'         **R6gd node types** (available only for Redis engine version 6.2
#'         onward).
#'
#'         `cache.r6gd.xlarge`, `cache.r6gd.2xlarge`, `cache.r6gd.4xlarge`,
#'         `cache.r6gd.8xlarge`, `cache.r6gd.12xlarge`,
#'         `cache.r6gd.16xlarge`
#'
#' -   Memory optimized:
#'
#'     -   Current generation:
#'
#'         **R6g node types** (available only for Redis engine version
#'         5.0.6 onward and for Memcached engine version 1.5.16 onward).
#'
#'         `cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`,
#'         `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`,
#'         `cache.r6g.16xlarge`
#'
#'         For region availability, see [Supported Node
#'         Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
#'
#'         **R5 node types:** `cache.r5.large`, `cache.r5.xlarge`,
#'         `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`,
#'         `cache.r5.24xlarge`
#'
#'         **R4 node types:** `cache.r4.large`, `cache.r4.xlarge`,
#'         `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`,
#'         `cache.r4.16xlarge`
#'
#'     -   Previous generation: (not recommended. Existing clusters are
#'         still supported but creation of new clusters is not supported
#'         for these types.)
#'
#'         **M2 node types:** `cache.m2.xlarge`, `cache.m2.2xlarge`,
#'         `cache.m2.4xlarge`
#'
#'         **R3 node types:** `cache.r3.large`, `cache.r3.xlarge`,
#'         `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
#'
#' **Additional node type info**
#'
#' -   All current generation instance types are created in Amazon VPC by
#'     default.
#'
#' -   Redis append-only files (AOF) are not supported for T1 or T2
#'     instances.
#'
#' -   Redis Multi-AZ with automatic failover is not supported on T1
#'     instances.
#'
#' -   Redis configuration variables `appendonly` and `appendfsync` are not
#'     supported on Redis version 2.8.22 and later.
#' @param Duration Duration filter value, specified in years or seconds. Use this parameter
#' to show only reservations for a given duration.
#'
#' Valid Values: `1 | 3 | 31536000 | 94608000`
#' @param ProductDescription The product description filter value. Use this parameter to show only
#' the available offerings matching the specified product description.
#' @param OfferingType The offering type filter value. Use this parameter to show only the
#' available offerings matching the specified offering type.
#'
#' Valid Values:
#' `"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"`
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 100
#'
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_reserved_cache_nodes_offerings
elasticache_describe_reserved_cache_nodes_offerings <- function(ReservedCacheNodesOfferingId = NULL, CacheNodeType = NULL, Duration = NULL, ProductDescription = NULL, OfferingType = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReservedCacheNodesOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_reserved_cache_nodes_offerings_input(ReservedCacheNodesOfferingId = ReservedCacheNodesOfferingId, CacheNodeType = CacheNodeType, Duration = Duration, ProductDescription = ProductDescription, OfferingType = OfferingType, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_reserved_cache_nodes_offerings_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_reserved_cache_nodes_offerings <- elasticache_describe_reserved_cache_nodes_offerings

#' Returns details of the service updates
#'
#' @description
#' Returns details of the service updates
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_service_updates.html](https://paws-r.github.io/docs/elasticache/describe_service_updates.html) for full documentation.
#'
#' @param ServiceUpdateName The unique ID of the service update
#' @param ServiceUpdateStatus The status of the service update
#' @param MaxRecords The maximum number of records to include in the response
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_service_updates
elasticache_describe_service_updates <- function(ServiceUpdateName = NULL, ServiceUpdateStatus = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeServiceUpdates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_service_updates_input(ServiceUpdateName = ServiceUpdateName, ServiceUpdateStatus = ServiceUpdateStatus, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_service_updates_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_service_updates <- elasticache_describe_service_updates

#' Returns information about cluster or replication group snapshots
#'
#' @description
#' Returns information about cluster or replication group snapshots. By default, [`describe_snapshots`][elasticache_describe_snapshots] lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cache cluster.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_snapshots.html](https://paws-r.github.io/docs/elasticache/describe_snapshots.html) for full documentation.
#'
#' @param ReplicationGroupId A user-supplied replication group identifier. If this parameter is
#' specified, only snapshots associated with that specific replication
#' group are described.
#' @param CacheClusterId A user-supplied cluster identifier. If this parameter is specified, only
#' snapshots associated with that specific cluster are described.
#' @param SnapshotName A user-supplied name of the snapshot. If this parameter is specified,
#' only this snapshot are described.
#' @param SnapshotSource If set to `system`, the output shows snapshots that were automatically
#' created by ElastiCache. If set to `user` the output shows snapshots that
#' were manually created. If omitted, the output shows both automatically
#' and manually created snapshots.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#'
#' Default: 50
#'
#' Constraints: minimum 20; maximum 50.
#' @param ShowNodeGroupConfig A Boolean value which if true, the node group (shard) configuration is
#' included in the snapshot description.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_snapshots
elasticache_describe_snapshots <- function(ReplicationGroupId = NULL, CacheClusterId = NULL, SnapshotName = NULL, SnapshotSource = NULL, Marker = NULL, MaxRecords = NULL, ShowNodeGroupConfig = NULL) {
  op <- new_operation(
    name = "DescribeSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_snapshots_input(ReplicationGroupId = ReplicationGroupId, CacheClusterId = CacheClusterId, SnapshotName = SnapshotName, SnapshotSource = SnapshotSource, Marker = Marker, MaxRecords = MaxRecords, ShowNodeGroupConfig = ShowNodeGroupConfig)
  output <- .elasticache$describe_snapshots_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_snapshots <- elasticache_describe_snapshots

#' Returns details of the update actions
#'
#' @description
#' Returns details of the update actions
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_update_actions.html](https://paws-r.github.io/docs/elasticache/describe_update_actions.html) for full documentation.
#'
#' @param ServiceUpdateName The unique ID of the service update
#' @param ReplicationGroupIds The replication group IDs
#' @param CacheClusterIds The cache cluster IDs
#' @param Engine The Elasticache engine to which the update applies. Either Redis or
#' Memcached
#' @param ServiceUpdateStatus The status of the service update
#' @param ServiceUpdateTimeRange The range of time specified to search for service updates that are in
#' available status
#' @param UpdateActionStatus The status of the update action.
#' @param ShowNodeLevelUpdateStatus Dictates whether to include node level update status in the response
#' @param MaxRecords The maximum number of records to include in the response
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_update_actions
elasticache_describe_update_actions <- function(ServiceUpdateName = NULL, ReplicationGroupIds = NULL, CacheClusterIds = NULL, Engine = NULL, ServiceUpdateStatus = NULL, ServiceUpdateTimeRange = NULL, UpdateActionStatus = NULL, ShowNodeLevelUpdateStatus = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeUpdateActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_update_actions_input(ServiceUpdateName = ServiceUpdateName, ReplicationGroupIds = ReplicationGroupIds, CacheClusterIds = CacheClusterIds, Engine = Engine, ServiceUpdateStatus = ServiceUpdateStatus, ServiceUpdateTimeRange = ServiceUpdateTimeRange, UpdateActionStatus = UpdateActionStatus, ShowNodeLevelUpdateStatus = ShowNodeLevelUpdateStatus, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_update_actions_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_update_actions <- elasticache_describe_update_actions

#' Returns a list of user groups
#'
#' @description
#' Returns a list of user groups.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_user_groups.html](https://paws-r.github.io/docs/elasticache/describe_user_groups.html) for full documentation.
#'
#' @param UserGroupId The ID of the user group.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified MaxRecords value, a marker is included
#' in the response so that the remaining results can be retrieved.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by MaxRecords. \>
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_user_groups
elasticache_describe_user_groups <- function(UserGroupId = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeUserGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_user_groups_input(UserGroupId = UserGroupId, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_user_groups_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_user_groups <- elasticache_describe_user_groups

#' Returns a list of users
#'
#' @description
#' Returns a list of users.
#'
#' See [https://paws-r.github.io/docs/elasticache/describe_users.html](https://paws-r.github.io/docs/elasticache/describe_users.html) for full documentation.
#'
#' @param Engine The Redis engine.
#' @param UserId The ID of the user.
#' @param Filters Filter to determine the list of User IDs to return.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified MaxRecords value, a marker is included
#' in the response so that the remaining results can be retrieved.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by MaxRecords. \>
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_users
elasticache_describe_users <- function(Engine = NULL, UserId = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeUsers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_users_input(Engine = Engine, UserId = UserId, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_users_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_users <- elasticache_describe_users

#' Remove a secondary cluster from the Global datastore using the Global
#' datastore name
#'
#' @description
#' Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon region.
#'
#' See [https://paws-r.github.io/docs/elasticache/disassociate_global_replication_group.html](https://paws-r.github.io/docs/elasticache/disassociate_global_replication_group.html) for full documentation.
#'
#' @param GlobalReplicationGroupId &#91;required&#93; The name of the Global datastore
#' @param ReplicationGroupId &#91;required&#93; The name of the secondary cluster you wish to remove from the Global
#' datastore
#' @param ReplicationGroupRegion &#91;required&#93; The Amazon region of secondary cluster you wish to remove from the
#' Global datastore
#'
#' @keywords internal
#'
#' @rdname elasticache_disassociate_global_replication_group
elasticache_disassociate_global_replication_group <- function(GlobalReplicationGroupId, ReplicationGroupId, ReplicationGroupRegion) {
  op <- new_operation(
    name = "DisassociateGlobalReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$disassociate_global_replication_group_input(GlobalReplicationGroupId = GlobalReplicationGroupId, ReplicationGroupId = ReplicationGroupId, ReplicationGroupRegion = ReplicationGroupRegion)
  output <- .elasticache$disassociate_global_replication_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$disassociate_global_replication_group <- elasticache_disassociate_global_replication_group

#' Used to failover the primary region to a selected secondary region
#'
#' @description
#' Used to failover the primary region to a selected secondary region. The selected secondary region will become primary, and all other clusters will become secondary.
#'
#' See [https://paws-r.github.io/docs/elasticache/failover_global_replication_group.html](https://paws-r.github.io/docs/elasticache/failover_global_replication_group.html) for full documentation.
#'
#' @param GlobalReplicationGroupId &#91;required&#93; The name of the Global datastore
#' @param PrimaryRegion &#91;required&#93; The Amazon region of the primary cluster of the Global datastore
#' @param PrimaryReplicationGroupId &#91;required&#93; The name of the primary replication group
#'
#' @keywords internal
#'
#' @rdname elasticache_failover_global_replication_group
elasticache_failover_global_replication_group <- function(GlobalReplicationGroupId, PrimaryRegion, PrimaryReplicationGroupId) {
  op <- new_operation(
    name = "FailoverGlobalReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$failover_global_replication_group_input(GlobalReplicationGroupId = GlobalReplicationGroupId, PrimaryRegion = PrimaryRegion, PrimaryReplicationGroupId = PrimaryReplicationGroupId)
  output <- .elasticache$failover_global_replication_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$failover_global_replication_group <- elasticache_failover_global_replication_group

#' Increase the number of node groups in the Global datastore
#'
#' @description
#' Increase the number of node groups in the Global datastore
#'
#' See [https://paws-r.github.io/docs/elasticache/increase_node_groups_in_global_replication_group.html](https://paws-r.github.io/docs/elasticache/increase_node_groups_in_global_replication_group.html) for full documentation.
#'
#' @param GlobalReplicationGroupId &#91;required&#93; The name of the Global datastore
#' @param NodeGroupCount &#91;required&#93; The number of node groups you wish to add
#' @param RegionalConfigurations Describes the replication group IDs, the Amazon regions where they are
#' stored and the shard configuration for each that comprise the Global
#' datastore
#' @param ApplyImmediately &#91;required&#93; Indicates that the process begins immediately. At present, the only
#' permitted value for this parameter is true.
#'
#' @keywords internal
#'
#' @rdname elasticache_increase_node_groups_in_global_replication_group
elasticache_increase_node_groups_in_global_replication_group <- function(GlobalReplicationGroupId, NodeGroupCount, RegionalConfigurations = NULL, ApplyImmediately) {
  op <- new_operation(
    name = "IncreaseNodeGroupsInGlobalReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$increase_node_groups_in_global_replication_group_input(GlobalReplicationGroupId = GlobalReplicationGroupId, NodeGroupCount = NodeGroupCount, RegionalConfigurations = RegionalConfigurations, ApplyImmediately = ApplyImmediately)
  output <- .elasticache$increase_node_groups_in_global_replication_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$increase_node_groups_in_global_replication_group <- elasticache_increase_node_groups_in_global_replication_group

#' Dynamically increases the number of replicas in a Redis (cluster mode
#' disabled) replication group or the number of replica nodes in one or
#' more node groups (shards) of a Redis (cluster mode enabled) replication
#' group
#'
#' @description
#' Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
#'
#' See [https://paws-r.github.io/docs/elasticache/increase_replica_count.html](https://paws-r.github.io/docs/elasticache/increase_replica_count.html) for full documentation.
#'
#' @param ReplicationGroupId &#91;required&#93; The id of the replication group to which you want to add replica nodes.
#' @param NewReplicaCount The number of read replica nodes you want at the completion of this
#' operation. For Redis (cluster mode disabled) replication groups, this is
#' the number of replica nodes in the replication group. For Redis (cluster
#' mode enabled) replication groups, this is the number of replica nodes in
#' each of the replication group's node groups.
#' @param ReplicaConfiguration A list of `ConfigureShard` objects that can be used to configure each
#' shard in a Redis (cluster mode enabled) replication group. The
#' `ConfigureShard` has three members: `NewReplicaCount`, `NodeGroupId`,
#' and `PreferredAvailabilityZones`.
#' @param ApplyImmediately &#91;required&#93; If `True`, the number of replica nodes is increased immediately.
#' `ApplyImmediately=False` is not currently supported.
#'
#' @keywords internal
#'
#' @rdname elasticache_increase_replica_count
elasticache_increase_replica_count <- function(ReplicationGroupId, NewReplicaCount = NULL, ReplicaConfiguration = NULL, ApplyImmediately) {
  op <- new_operation(
    name = "IncreaseReplicaCount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$increase_replica_count_input(ReplicationGroupId = ReplicationGroupId, NewReplicaCount = NewReplicaCount, ReplicaConfiguration = ReplicaConfiguration, ApplyImmediately = ApplyImmediately)
  output <- .elasticache$increase_replica_count_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$increase_replica_count <- elasticache_increase_replica_count

#' Lists all available node types that you can scale your Redis cluster's
#' or replication group's current node type
#'
#' @description
#' Lists all available node types that you can scale your Redis cluster's or replication group's current node type.
#'
#' See [https://paws-r.github.io/docs/elasticache/list_allowed_node_type_modifications.html](https://paws-r.github.io/docs/elasticache/list_allowed_node_type_modifications.html) for full documentation.
#'
#' @param CacheClusterId The name of the cluster you want to scale up to a larger node instanced
#' type. ElastiCache uses the cluster id to identify the current node type
#' of this cluster and from that to create a list of node types you can
#' scale up to.
#'
#' You must provide a value for either the `CacheClusterId` or the
#' `ReplicationGroupId`.
#' @param ReplicationGroupId The name of the replication group want to scale up to a larger node
#' type. ElastiCache uses the replication group id to identify the current
#' node type being used by this replication group, and from that to create
#' a list of node types you can scale up to.
#'
#' You must provide a value for either the `CacheClusterId` or the
#' `ReplicationGroupId`.
#'
#' @keywords internal
#'
#' @rdname elasticache_list_allowed_node_type_modifications
elasticache_list_allowed_node_type_modifications <- function(CacheClusterId = NULL, ReplicationGroupId = NULL) {
  op <- new_operation(
    name = "ListAllowedNodeTypeModifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$list_allowed_node_type_modifications_input(CacheClusterId = CacheClusterId, ReplicationGroupId = ReplicationGroupId)
  output <- .elasticache$list_allowed_node_type_modifications_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$list_allowed_node_type_modifications <- elasticache_list_allowed_node_type_modifications

#' Lists all tags currently on a named resource
#'
#' @description
#' Lists all tags currently on a named resource.
#'
#' See [https://paws-r.github.io/docs/elasticache/list_tags_for_resource.html](https://paws-r.github.io/docs/elasticache/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which you want the
#' list of tags, for example
#' `arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster` or
#' `arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot`.
#'
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' Amazon Web Services Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#'
#' @keywords internal
#'
#' @rdname elasticache_list_tags_for_resource
elasticache_list_tags_for_resource <- function(ResourceName) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$list_tags_for_resource_input(ResourceName = ResourceName)
  output <- .elasticache$list_tags_for_resource_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$list_tags_for_resource <- elasticache_list_tags_for_resource

#' Modifies the settings for a cluster
#'
#' @description
#' Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration parameters by specifying the parameters and the new values.
#'
#' See [https://paws-r.github.io/docs/elasticache/modify_cache_cluster.html](https://paws-r.github.io/docs/elasticache/modify_cache_cluster.html) for full documentation.
#'
#' @param CacheClusterId &#91;required&#93; The cluster identifier. This value is stored as a lowercase string.
#' @param NumCacheNodes The number of cache nodes that the cluster should have. If the value for
#' `NumCacheNodes` is greater than the sum of the number of current cache
#' nodes and the number of cache nodes pending creation (which may be
#' zero), more nodes are added. If the value is less than the number of
#' existing cache nodes, nodes are removed. If the value is equal to the
#' number of current cache nodes, any pending add or remove requests are
#' canceled.
#'
#' If you are removing cache nodes, you must use the `CacheNodeIdsToRemove`
#' parameter to provide the IDs of the specific cache nodes to remove.
#'
#' For clusters running Redis, this value must be 1. For clusters running
#' Memcached, this value must be between 1 and 40.
#'
#' Adding or removing Memcached cache nodes can be applied immediately or
#' as a pending operation (see `ApplyImmediately`).
#'
#' A pending operation to modify the number of cache nodes in a cluster
#' during its maintenance window, whether by adding or removing nodes in
#' accordance with the scale out architecture, is not queued. The
#' customer's latest request to add or remove nodes to the cluster
#' overrides any previous pending operations to modify the number of cache
#' nodes in the cluster. For example, a request to remove 2 nodes would
#' override a previous pending operation to remove 3 nodes. Similarly, a
#' request to add 2 nodes would override a previous pending operation to
#' remove 3 nodes and vice versa. As Memcached cache nodes may now be
#' provisioned in different Availability Zones with flexible cache node
#' placement, a request to add nodes does not automatically override a
#' previous pending operation to add nodes. The customer can modify the
#' previous pending operation to add more nodes or explicitly cancel the
#' pending request and retry the new request. To cancel pending operations
#' to modify the number of cache nodes in a cluster, use the
#' [`modify_cache_cluster`][elasticache_modify_cache_cluster] request and
#' set `NumCacheNodes` equal to the number of cache nodes currently in the
#' cluster.
#' @param CacheNodeIdsToRemove A list of cache node IDs to be removed. A node ID is a numeric
#' identifier (0001, 0002, etc.). This parameter is only valid when
#' `NumCacheNodes` is less than the existing number of cache nodes. The
#' number of cache node IDs supplied in this parameter must match the
#' difference between the existing number of cache nodes in the cluster or
#' pending cache nodes, whichever is greater, and the value of
#' `NumCacheNodes` in the request.
#'
#' For example: If you have 3 active cache nodes, 7 pending cache nodes,
#' and the number of cache nodes in this
#' [`modify_cache_cluster`][elasticache_modify_cache_cluster] call is 5,
#' you must list 2 (7 - 5) cache node IDs to remove.
#' @param AZMode Specifies whether the new nodes in this Memcached cluster are all
#' created in a single Availability Zone or created across multiple
#' Availability Zones.
#'
#' Valid values: `single-az` | `cross-az`.
#'
#' This option is only supported for Memcached clusters.
#'
#' You cannot specify `single-az` if the Memcached cluster already has
#' cache nodes in different Availability Zones. If `cross-az` is specified,
#' existing Memcached nodes remain in their current Availability Zone.
#'
#' Only newly created nodes are located in different Availability Zones.
#' @param NewAvailabilityZones This option is only supported on Memcached clusters.
#'
#' The list of Availability Zones where the new Memcached cache nodes are
#' created.
#'
#' This parameter is only valid when `NumCacheNodes` in the request is
#' greater than the sum of the number of active cache nodes and the number
#' of cache nodes pending creation (which may be zero). The number of
#' Availability Zones supplied in this list must match the cache nodes
#' being added in this request.
#'
#' Scenarios:
#'
#' -   **Scenario 1:** You have 3 active nodes and wish to add 2 nodes.
#'     Specify `NumCacheNodes=5` (3 + 2) and optionally specify two
#'     Availability Zones for the two new nodes.
#'
#' -   **Scenario 2:** You have 3 active nodes and 2 nodes pending creation
#'     (from the scenario 1 call) and want to add 1 more node. Specify
#'     `NumCacheNodes=6` ((3 + 2) + 1) and optionally specify an
#'     Availability Zone for the new node.
#'
#' -   **Scenario 3:** You want to cancel all pending operations. Specify
#'     `NumCacheNodes=3` to cancel all pending operations.
#'
#' The Availability Zone placement of nodes pending creation cannot be
#' modified. If you wish to cancel any nodes pending creation, add 0 nodes
#' by setting `NumCacheNodes` to the number of current nodes.
#'
#' If `cross-az` is specified, existing Memcached nodes remain in their
#' current Availability Zone. Only newly created nodes can be located in
#' different Availability Zones. For guidance on how to move existing
#' Memcached nodes to different Availability Zones, see the **Availability
#' Zone Considerations** section of [Cache Node Considerations for
#' Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html).
#'
#' **Impact of new add/remove requests upon pending requests**
#'
#' -   Scenario-1
#'
#'     -   Pending Action: Delete
#'
#'     -   New Request: Delete
#'
#'     -   Result: The new delete, pending or immediate, replaces the
#'         pending delete.
#'
#' -   Scenario-2
#'
#'     -   Pending Action: Delete
#'
#'     -   New Request: Create
#'
#'     -   Result: The new create, pending or immediate, replaces the
#'         pending delete.
#'
#' -   Scenario-3
#'
#'     -   Pending Action: Create
#'
#'     -   New Request: Delete
#'
#'     -   Result: The new delete, pending or immediate, replaces the
#'         pending create.
#'
#' -   Scenario-4
#'
#'     -   Pending Action: Create
#'
#'     -   New Request: Create
#'
#'     -   Result: The new create is added to the pending create.
#'
#'         **Important:** If the new create request is **Apply
#'         Immediately - Yes**, all creates are performed immediately. If
#'         the new create request is **Apply Immediately - No**, all
#'         creates are pending.
#' @param CacheSecurityGroupNames A list of cache security group names to authorize on this cluster. This
#' change is asynchronously applied as soon as possible.
#'
#' You can use this parameter only with clusters that are created outside
#' of an Amazon Virtual Private Cloud (Amazon VPC).
#'
#' Constraints: Must contain no more than 255 alphanumeric characters. Must
#' not be "Default".
#' @param SecurityGroupIds Specifies the VPC Security Groups associated with the cluster.
#'
#' This parameter can be used only with clusters that are created in an
#' Amazon Virtual Private Cloud (Amazon VPC).
#' @param PreferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period.
#'
#' Valid values for `ddd` are:
#'
#' -   `sun`
#'
#' -   `mon`
#'
#' -   `tue`
#'
#' -   `wed`
#'
#' -   `thu`
#'
#' -   `fri`
#'
#' -   `sat`
#'
#' Example: `sun:23:00-mon:01:30`
#' @param NotificationTopicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to which
#' notifications are sent.
#'
#' The Amazon SNS topic owner must be same as the cluster owner.
#' @param CacheParameterGroupName The name of the cache parameter group to apply to this cluster. This
#' change is asynchronously applied as soon as possible for parameters when
#' the `ApplyImmediately` parameter is specified as `true` for this
#' request.
#' @param NotificationTopicStatus The status of the Amazon SNS notification topic. Notifications are sent
#' only if the status is `active`.
#'
#' Valid values: `active` | `inactive`
#' @param ApplyImmediately If `true`, this parameter causes the modifications in this request and
#' any pending modifications to be applied, asynchronously and as soon as
#' possible, regardless of the `PreferredMaintenanceWindow` setting for the
#' cluster.
#'
#' If `false`, changes to the cluster are applied on the next maintenance
#' reboot, or the next failure reboot, whichever occurs first.
#'
#' If you perform a
#' [`modify_cache_cluster`][elasticache_modify_cache_cluster] before a
#' pending modification is applied, the pending modification is replaced by
#' the newer modification.
#'
#' Valid values: `true` | `false`
#'
#' Default: `false`
#' @param EngineVersion The upgraded version of the cache engine to be run on the cache nodes.
#'
#' **Important:** You can upgrade to a newer engine version (see [Selecting
#' a Cache Engine and
#' Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)),
#' but you cannot downgrade to an earlier engine version. If you want to
#' use an earlier engine version, you must delete the existing cluster and
#' create it anew with the earlier engine version.
#' @param AutoMinorVersionUpgrade  If you are running Redis engine version 6.0 or later, set this
#' parameter to yes if you want to opt-in to the next auto minor version
#' upgrade campaign. This parameter is disabled for previous versions. 
#' @param SnapshotRetentionLimit The number of days for which ElastiCache retains automatic cluster
#' snapshots before deleting them. For example, if you set
#' `SnapshotRetentionLimit` to 5, a snapshot that was taken today is
#' retained for 5 days before being deleted.
#'
#' If the value of `SnapshotRetentionLimit` is set to zero (0), backups are
#' turned off.
#' @param SnapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a
#' daily snapshot of your cluster.
#' @param CacheNodeType A valid cache node type that you want to scale this cluster up to.
#' @param AuthToken Reserved parameter. The password used to access a password protected
#' server. This parameter must be specified with the `auth-token-update`
#' parameter. Password constraints:
#'
#' -   Must be only printable ASCII characters
#'
#' -   Must be at least 16 characters and no more than 128 characters in
#'     length
#'
#' -   Cannot contain any of the following characters: '/', '"', or '@@',
#'     '%'
#'
#' For more information, see AUTH password at
#' [AUTH](https://redis.io/commands/auth/).
#' @param AuthTokenUpdateStrategy Specifies the strategy to use to update the AUTH token. This parameter
#' must be specified with the `auth-token` parameter. Possible values:
#'
#' -   Rotate
#'
#' -   Set
#'
#' For more information, see [Authenticating Users with Redis
#' AUTH](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html)
#' @param LogDeliveryConfigurations Specifies the destination, format and type of the logs.
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_cache_cluster
elasticache_modify_cache_cluster <- function(CacheClusterId, NumCacheNodes = NULL, CacheNodeIdsToRemove = NULL, AZMode = NULL, NewAvailabilityZones = NULL, CacheSecurityGroupNames = NULL, SecurityGroupIds = NULL, PreferredMaintenanceWindow = NULL, NotificationTopicArn = NULL, CacheParameterGroupName = NULL, NotificationTopicStatus = NULL, ApplyImmediately = NULL, EngineVersion = NULL, AutoMinorVersionUpgrade = NULL, SnapshotRetentionLimit = NULL, SnapshotWindow = NULL, CacheNodeType = NULL, AuthToken = NULL, AuthTokenUpdateStrategy = NULL, LogDeliveryConfigurations = NULL) {
  op <- new_operation(
    name = "ModifyCacheCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_cache_cluster_input(CacheClusterId = CacheClusterId, NumCacheNodes = NumCacheNodes, CacheNodeIdsToRemove = CacheNodeIdsToRemove, AZMode = AZMode, NewAvailabilityZones = NewAvailabilityZones, CacheSecurityGroupNames = CacheSecurityGroupNames, SecurityGroupIds = SecurityGroupIds, PreferredMaintenanceWindow = PreferredMaintenanceWindow, NotificationTopicArn = NotificationTopicArn, CacheParameterGroupName = CacheParameterGroupName, NotificationTopicStatus = NotificationTopicStatus, ApplyImmediately = ApplyImmediately, EngineVersion = EngineVersion, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, SnapshotRetentionLimit = SnapshotRetentionLimit, SnapshotWindow = SnapshotWindow, CacheNodeType = CacheNodeType, AuthToken = AuthToken, AuthTokenUpdateStrategy = AuthTokenUpdateStrategy, LogDeliveryConfigurations = LogDeliveryConfigurations)
  output <- .elasticache$modify_cache_cluster_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_cache_cluster <- elasticache_modify_cache_cluster

#' Modifies the parameters of a cache parameter group
#'
#' @description
#' Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
#'
#' See [https://paws-r.github.io/docs/elasticache/modify_cache_parameter_group.html](https://paws-r.github.io/docs/elasticache/modify_cache_parameter_group.html) for full documentation.
#'
#' @param CacheParameterGroupName &#91;required&#93; The name of the cache parameter group to modify.
#' @param ParameterNameValues &#91;required&#93; An array of parameter names and values for the parameter update. You
#' must supply at least one parameter name and value; subsequent arguments
#' are optional. A maximum of 20 parameters may be modified per request.
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_cache_parameter_group
elasticache_modify_cache_parameter_group <- function(CacheParameterGroupName, ParameterNameValues) {
  op <- new_operation(
    name = "ModifyCacheParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_cache_parameter_group_input(CacheParameterGroupName = CacheParameterGroupName, ParameterNameValues = ParameterNameValues)
  output <- .elasticache$modify_cache_parameter_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_cache_parameter_group <- elasticache_modify_cache_parameter_group

#' Modifies an existing cache subnet group
#'
#' @description
#' Modifies an existing cache subnet group.
#'
#' See [https://paws-r.github.io/docs/elasticache/modify_cache_subnet_group.html](https://paws-r.github.io/docs/elasticache/modify_cache_subnet_group.html) for full documentation.
#'
#' @param CacheSubnetGroupName &#91;required&#93; The name for the cache subnet group. This value is stored as a lowercase
#' string.
#'
#' Constraints: Must contain no more than 255 alphanumeric characters or
#' hyphens.
#'
#' Example: `mysubnetgroup`
#' @param CacheSubnetGroupDescription A description of the cache subnet group.
#' @param SubnetIds The EC2 subnet IDs for the cache subnet group.
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_cache_subnet_group
elasticache_modify_cache_subnet_group <- function(CacheSubnetGroupName, CacheSubnetGroupDescription = NULL, SubnetIds = NULL) {
  op <- new_operation(
    name = "ModifyCacheSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_cache_subnet_group_input(CacheSubnetGroupName = CacheSubnetGroupName, CacheSubnetGroupDescription = CacheSubnetGroupDescription, SubnetIds = SubnetIds)
  output <- .elasticache$modify_cache_subnet_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_cache_subnet_group <- elasticache_modify_cache_subnet_group

#' Modifies the settings for a Global datastore
#'
#' @description
#' Modifies the settings for a Global datastore.
#'
#' See [https://paws-r.github.io/docs/elasticache/modify_global_replication_group.html](https://paws-r.github.io/docs/elasticache/modify_global_replication_group.html) for full documentation.
#'
#' @param GlobalReplicationGroupId &#91;required&#93; The name of the Global datastore
#' @param ApplyImmediately &#91;required&#93; This parameter causes the modifications in this request and any pending
#' modifications to be applied, asynchronously and as soon as possible.
#' Modifications to Global Replication Groups cannot be requested to be
#' applied in PreferredMaintenceWindow.
#' @param CacheNodeType A valid cache node type that you want to scale this Global datastore to.
#' @param EngineVersion The upgraded version of the cache engine to be run on the clusters in
#' the Global datastore.
#' @param CacheParameterGroupName The name of the cache parameter group to use with the Global datastore.
#' It must be compatible with the major engine version used by the Global
#' datastore.
#' @param GlobalReplicationGroupDescription A description of the Global datastore
#' @param AutomaticFailoverEnabled Determines whether a read replica is automatically promoted to
#' read/write primary if the existing primary encounters a failure.
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_global_replication_group
elasticache_modify_global_replication_group <- function(GlobalReplicationGroupId, ApplyImmediately, CacheNodeType = NULL, EngineVersion = NULL, CacheParameterGroupName = NULL, GlobalReplicationGroupDescription = NULL, AutomaticFailoverEnabled = NULL) {
  op <- new_operation(
    name = "ModifyGlobalReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_global_replication_group_input(GlobalReplicationGroupId = GlobalReplicationGroupId, ApplyImmediately = ApplyImmediately, CacheNodeType = CacheNodeType, EngineVersion = EngineVersion, CacheParameterGroupName = CacheParameterGroupName, GlobalReplicationGroupDescription = GlobalReplicationGroupDescription, AutomaticFailoverEnabled = AutomaticFailoverEnabled)
  output <- .elasticache$modify_global_replication_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_global_replication_group <- elasticache_modify_global_replication_group

#' Modifies the settings for a replication group
#'
#' @description
#' Modifies the settings for a replication group.
#'
#' See [https://paws-r.github.io/docs/elasticache/modify_replication_group.html](https://paws-r.github.io/docs/elasticache/modify_replication_group.html) for full documentation.
#'
#' @param ReplicationGroupId &#91;required&#93; The identifier of the replication group to modify.
#' @param ReplicationGroupDescription A description for the replication group. Maximum length is 255
#' characters.
#' @param PrimaryClusterId For replication groups with a single primary, if this parameter is
#' specified, ElastiCache promotes the specified cluster in the specified
#' replication group to the primary role. The nodes of all other clusters
#' in the replication group are read replicas.
#' @param SnapshottingClusterId The cluster ID that is used as the daily snapshot source for the
#' replication group. This parameter cannot be set for Redis (cluster mode
#' enabled) replication groups.
#' @param AutomaticFailoverEnabled Determines whether a read replica is automatically promoted to
#' read/write primary if the existing primary encounters a failure.
#'
#' Valid values: `true` | `false`
#' @param MultiAZEnabled A flag to indicate MultiAZ is enabled.
#' @param NodeGroupId Deprecated. This parameter is not used.
#' @param CacheSecurityGroupNames A list of cache security group names to authorize for the clusters in
#' this replication group. This change is asynchronously applied as soon as
#' possible.
#'
#' This parameter can be used only with replication group containing
#' clusters running outside of an Amazon Virtual Private Cloud (Amazon
#' VPC).
#'
#' Constraints: Must contain no more than 255 alphanumeric characters. Must
#' not be `Default`.
#' @param SecurityGroupIds Specifies the VPC Security Groups associated with the clusters in the
#' replication group.
#'
#' This parameter can be used only with replication group containing
#' clusters running in an Amazon Virtual Private Cloud (Amazon VPC).
#' @param PreferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period.
#'
#' Valid values for `ddd` are:
#'
#' -   `sun`
#'
#' -   `mon`
#'
#' -   `tue`
#'
#' -   `wed`
#'
#' -   `thu`
#'
#' -   `fri`
#'
#' -   `sat`
#'
#' Example: `sun:23:00-mon:01:30`
#' @param NotificationTopicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to which
#' notifications are sent.
#'
#' The Amazon SNS topic owner must be same as the replication group owner.
#' @param CacheParameterGroupName The name of the cache parameter group to apply to all of the clusters in
#' this replication group. This change is asynchronously applied as soon as
#' possible for parameters when the `ApplyImmediately` parameter is
#' specified as `true` for this request.
#' @param NotificationTopicStatus The status of the Amazon SNS notification topic for the replication
#' group. Notifications are sent only if the status is `active`.
#'
#' Valid values: `active` | `inactive`
#' @param ApplyImmediately If `true`, this parameter causes the modifications in this request and
#' any pending modifications to be applied, asynchronously and as soon as
#' possible, regardless of the `PreferredMaintenanceWindow` setting for the
#' replication group.
#'
#' If `false`, changes to the nodes in the replication group are applied on
#' the next maintenance reboot, or the next failure reboot, whichever
#' occurs first.
#'
#' Valid values: `true` | `false`
#'
#' Default: `false`
#' @param EngineVersion The upgraded version of the cache engine to be run on the clusters in
#' the replication group.
#'
#' **Important:** You can upgrade to a newer engine version (see [Selecting
#' a Cache Engine and
#' Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)),
#' but you cannot downgrade to an earlier engine version. If you want to
#' use an earlier engine version, you must delete the existing replication
#' group and create it anew with the earlier engine version.
#' @param AutoMinorVersionUpgrade  If you are running Redis engine version 6.0 or later, set this
#' parameter to yes if you want to opt-in to the next auto minor version
#' upgrade campaign. This parameter is disabled for previous versions. 
#' @param SnapshotRetentionLimit The number of days for which ElastiCache retains automatic node group
#' (shard) snapshots before deleting them. For example, if you set
#' `SnapshotRetentionLimit` to 5, a snapshot that was taken today is
#' retained for 5 days before being deleted.
#'
#' **Important** If the value of SnapshotRetentionLimit is set to zero (0),
#' backups are turned off.
#' @param SnapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a
#' daily snapshot of the node group (shard) specified by
#' `SnapshottingClusterId`.
#'
#' Example: `05:00-09:00`
#'
#' If you do not specify this parameter, ElastiCache automatically chooses
#' an appropriate time range.
#' @param CacheNodeType A valid cache node type that you want to scale this replication group
#' to.
#' @param AuthToken Reserved parameter. The password used to access a password protected
#' server. This parameter must be specified with the
#' `auth-token-update-strategy ` parameter. Password constraints:
#'
#' -   Must be only printable ASCII characters
#'
#' -   Must be at least 16 characters and no more than 128 characters in
#'     length
#'
#' -   Cannot contain any of the following characters: '/', '"', or '@@',
#'     '%'
#'
#' For more information, see AUTH password at
#' [AUTH](https://redis.io/commands/auth/).
#' @param AuthTokenUpdateStrategy Specifies the strategy to use to update the AUTH token. This parameter
#' must be specified with the `auth-token` parameter. Possible values:
#'
#' -   Rotate
#'
#' -   Set
#'
#' For more information, see [Authenticating Users with Redis
#' AUTH](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html)
#' @param UserGroupIdsToAdd The ID of the user group you are associating with the replication group.
#' @param UserGroupIdsToRemove The ID of the user group to disassociate from the replication group,
#' meaning the users in the group no longer can access the replication
#' group.
#' @param RemoveUserGroups Removes the user group associated with this replication group.
#' @param LogDeliveryConfigurations Specifies the destination, format and type of the logs.
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_replication_group
elasticache_modify_replication_group <- function(ReplicationGroupId, ReplicationGroupDescription = NULL, PrimaryClusterId = NULL, SnapshottingClusterId = NULL, AutomaticFailoverEnabled = NULL, MultiAZEnabled = NULL, NodeGroupId = NULL, CacheSecurityGroupNames = NULL, SecurityGroupIds = NULL, PreferredMaintenanceWindow = NULL, NotificationTopicArn = NULL, CacheParameterGroupName = NULL, NotificationTopicStatus = NULL, ApplyImmediately = NULL, EngineVersion = NULL, AutoMinorVersionUpgrade = NULL, SnapshotRetentionLimit = NULL, SnapshotWindow = NULL, CacheNodeType = NULL, AuthToken = NULL, AuthTokenUpdateStrategy = NULL, UserGroupIdsToAdd = NULL, UserGroupIdsToRemove = NULL, RemoveUserGroups = NULL, LogDeliveryConfigurations = NULL) {
  op <- new_operation(
    name = "ModifyReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_replication_group_input(ReplicationGroupId = ReplicationGroupId, ReplicationGroupDescription = ReplicationGroupDescription, PrimaryClusterId = PrimaryClusterId, SnapshottingClusterId = SnapshottingClusterId, AutomaticFailoverEnabled = AutomaticFailoverEnabled, MultiAZEnabled = MultiAZEnabled, NodeGroupId = NodeGroupId, CacheSecurityGroupNames = CacheSecurityGroupNames, SecurityGroupIds = SecurityGroupIds, PreferredMaintenanceWindow = PreferredMaintenanceWindow, NotificationTopicArn = NotificationTopicArn, CacheParameterGroupName = CacheParameterGroupName, NotificationTopicStatus = NotificationTopicStatus, ApplyImmediately = ApplyImmediately, EngineVersion = EngineVersion, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, SnapshotRetentionLimit = SnapshotRetentionLimit, SnapshotWindow = SnapshotWindow, CacheNodeType = CacheNodeType, AuthToken = AuthToken, AuthTokenUpdateStrategy = AuthTokenUpdateStrategy, UserGroupIdsToAdd = UserGroupIdsToAdd, UserGroupIdsToRemove = UserGroupIdsToRemove, RemoveUserGroups = RemoveUserGroups, LogDeliveryConfigurations = LogDeliveryConfigurations)
  output <- .elasticache$modify_replication_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_replication_group <- elasticache_modify_replication_group

#' Modifies a replication group's shards (node groups) by allowing you to
#' add shards, remove shards, or rebalance the keyspaces among existing
#' shards
#'
#' @description
#' Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance the keyspaces among existing shards.
#'
#' See [https://paws-r.github.io/docs/elasticache/modify_replication_group_shard_configuration.html](https://paws-r.github.io/docs/elasticache/modify_replication_group_shard_configuration.html) for full documentation.
#'
#' @param ReplicationGroupId &#91;required&#93; The name of the Redis (cluster mode enabled) cluster (replication group)
#' on which the shards are to be configured.
#' @param NodeGroupCount &#91;required&#93; The number of node groups (shards) that results from the modification of
#' the shard configuration.
#' @param ApplyImmediately &#91;required&#93; Indicates that the shard reconfiguration process begins immediately. At
#' present, the only permitted value for this parameter is `true`.
#'
#' Value: true
#' @param ReshardingConfiguration Specifies the preferred availability zones for each node group in the
#' cluster. If the value of `NodeGroupCount` is greater than the current
#' number of node groups (shards), you can use this parameter to specify
#' the preferred availability zones of the cluster's shards. If you omit
#' this parameter ElastiCache selects availability zones for you.
#'
#' You can specify this parameter only if the value of `NodeGroupCount` is
#' greater than the current number of node groups (shards).
#' @param NodeGroupsToRemove If the value of `NodeGroupCount` is less than the current number of node
#' groups (shards), then either `NodeGroupsToRemove` or
#' `NodeGroupsToRetain` is required. `NodeGroupsToRemove` is a list of
#' `NodeGroupId`s to remove from the cluster.
#'
#' ElastiCache for Redis will attempt to remove all node groups listed by
#' `NodeGroupsToRemove` from the cluster.
#' @param NodeGroupsToRetain If the value of `NodeGroupCount` is less than the current number of node
#' groups (shards), then either `NodeGroupsToRemove` or
#' `NodeGroupsToRetain` is required. `NodeGroupsToRetain` is a list of
#' `NodeGroupId`s to retain in the cluster.
#'
#' ElastiCache for Redis will attempt to remove all node groups except
#' those listed by `NodeGroupsToRetain` from the cluster.
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_replication_group_shard_configuration
elasticache_modify_replication_group_shard_configuration <- function(ReplicationGroupId, NodeGroupCount, ApplyImmediately, ReshardingConfiguration = NULL, NodeGroupsToRemove = NULL, NodeGroupsToRetain = NULL) {
  op <- new_operation(
    name = "ModifyReplicationGroupShardConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_replication_group_shard_configuration_input(ReplicationGroupId = ReplicationGroupId, NodeGroupCount = NodeGroupCount, ApplyImmediately = ApplyImmediately, ReshardingConfiguration = ReshardingConfiguration, NodeGroupsToRemove = NodeGroupsToRemove, NodeGroupsToRetain = NodeGroupsToRetain)
  output <- .elasticache$modify_replication_group_shard_configuration_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_replication_group_shard_configuration <- elasticache_modify_replication_group_shard_configuration

#' Changes user password(s) and/or access string
#'
#' @description
#' Changes user password(s) and/or access string.
#'
#' See [https://paws-r.github.io/docs/elasticache/modify_user.html](https://paws-r.github.io/docs/elasticache/modify_user.html) for full documentation.
#'
#' @param UserId &#91;required&#93; The ID of the user.
#' @param AccessString Access permissions string used for this user.
#' @param AppendAccessString Adds additional user permissions to the access string.
#' @param Passwords The passwords belonging to the user. You are allowed up to two.
#' @param NoPasswordRequired Indicates no password is required for the user.
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_user
elasticache_modify_user <- function(UserId, AccessString = NULL, AppendAccessString = NULL, Passwords = NULL, NoPasswordRequired = NULL) {
  op <- new_operation(
    name = "ModifyUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_user_input(UserId = UserId, AccessString = AccessString, AppendAccessString = AppendAccessString, Passwords = Passwords, NoPasswordRequired = NoPasswordRequired)
  output <- .elasticache$modify_user_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_user <- elasticache_modify_user

#' Changes the list of users that belong to the user group
#'
#' @description
#' Changes the list of users that belong to the user group.
#'
#' See [https://paws-r.github.io/docs/elasticache/modify_user_group.html](https://paws-r.github.io/docs/elasticache/modify_user_group.html) for full documentation.
#'
#' @param UserGroupId &#91;required&#93; The ID of the user group.
#' @param UserIdsToAdd The list of user IDs to add to the user group.
#' @param UserIdsToRemove The list of user IDs to remove from the user group.
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_user_group
elasticache_modify_user_group <- function(UserGroupId, UserIdsToAdd = NULL, UserIdsToRemove = NULL) {
  op <- new_operation(
    name = "ModifyUserGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_user_group_input(UserGroupId = UserGroupId, UserIdsToAdd = UserIdsToAdd, UserIdsToRemove = UserIdsToRemove)
  output <- .elasticache$modify_user_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_user_group <- elasticache_modify_user_group

#' Allows you to purchase a reserved cache node offering
#'
#' @description
#' Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are non-refundable. For more information, see [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/) for Redis or [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/) for Memcached.
#'
#' See [https://paws-r.github.io/docs/elasticache/purchase_reserved_cache_nodes_offering.html](https://paws-r.github.io/docs/elasticache/purchase_reserved_cache_nodes_offering.html) for full documentation.
#'
#' @param ReservedCacheNodesOfferingId &#91;required&#93; The ID of the reserved cache node offering to purchase.
#'
#' Example: `438012d3-4052-4cc7-b2e3-8d3372e0e706`
#' @param ReservedCacheNodeId A customer-specified identifier to track this reservation.
#'
#' The Reserved Cache Node ID is an unique customer-specified identifier to
#' track this reservation. If this parameter is not specified, ElastiCache
#' automatically generates an identifier for the reservation.
#'
#' Example: myreservationID
#' @param CacheNodeCount The number of cache node instances to reserve.
#'
#' Default: `1`
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname elasticache_purchase_reserved_cache_nodes_offering
elasticache_purchase_reserved_cache_nodes_offering <- function(ReservedCacheNodesOfferingId, ReservedCacheNodeId = NULL, CacheNodeCount = NULL, Tags = NULL) {
  op <- new_operation(
    name = "PurchaseReservedCacheNodesOffering",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$purchase_reserved_cache_nodes_offering_input(ReservedCacheNodesOfferingId = ReservedCacheNodesOfferingId, ReservedCacheNodeId = ReservedCacheNodeId, CacheNodeCount = CacheNodeCount, Tags = Tags)
  output <- .elasticache$purchase_reserved_cache_nodes_offering_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$purchase_reserved_cache_nodes_offering <- elasticache_purchase_reserved_cache_nodes_offering

#' Redistribute slots to ensure uniform distribution across existing shards
#' in the cluster
#'
#' @description
#' Redistribute slots to ensure uniform distribution across existing shards in the cluster.
#'
#' See [https://paws-r.github.io/docs/elasticache/rebalance_slots_in_global_replication_group.html](https://paws-r.github.io/docs/elasticache/rebalance_slots_in_global_replication_group.html) for full documentation.
#'
#' @param GlobalReplicationGroupId &#91;required&#93; The name of the Global datastore
#' @param ApplyImmediately &#91;required&#93; If `True`, redistribution is applied immediately.
#'
#' @keywords internal
#'
#' @rdname elasticache_rebalance_slots_in_global_replication_group
elasticache_rebalance_slots_in_global_replication_group <- function(GlobalReplicationGroupId, ApplyImmediately) {
  op <- new_operation(
    name = "RebalanceSlotsInGlobalReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$rebalance_slots_in_global_replication_group_input(GlobalReplicationGroupId = GlobalReplicationGroupId, ApplyImmediately = ApplyImmediately)
  output <- .elasticache$rebalance_slots_in_global_replication_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$rebalance_slots_in_global_replication_group <- elasticache_rebalance_slots_in_global_replication_group

#' Reboots some, or all, of the cache nodes within a provisioned cluster
#'
#' @description
#' Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
#'
#' See [https://paws-r.github.io/docs/elasticache/reboot_cache_cluster.html](https://paws-r.github.io/docs/elasticache/reboot_cache_cluster.html) for full documentation.
#'
#' @param CacheClusterId &#91;required&#93; The cluster identifier. This parameter is stored as a lowercase string.
#' @param CacheNodeIdsToReboot &#91;required&#93; A list of cache node IDs to reboot. A node ID is a numeric identifier
#' (0001, 0002, etc.). To reboot an entire cluster, specify all of the
#' cache node IDs.
#'
#' @keywords internal
#'
#' @rdname elasticache_reboot_cache_cluster
elasticache_reboot_cache_cluster <- function(CacheClusterId, CacheNodeIdsToReboot) {
  op <- new_operation(
    name = "RebootCacheCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$reboot_cache_cluster_input(CacheClusterId = CacheClusterId, CacheNodeIdsToReboot = CacheNodeIdsToReboot)
  output <- .elasticache$reboot_cache_cluster_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$reboot_cache_cluster <- elasticache_reboot_cache_cluster

#' Removes the tags identified by the TagKeys list from the named resource
#'
#' @description
#' Removes the tags identified by the `TagKeys` list from the named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
#'
#' See [https://paws-r.github.io/docs/elasticache/remove_tags_from_resource.html](https://paws-r.github.io/docs/elasticache/remove_tags_from_resource.html) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which you want the
#' tags removed, for example
#' `arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster` or
#' `arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot`.
#'
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' Amazon Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#' @param TagKeys &#91;required&#93; A list of `TagKeys` identifying the tags you want removed from the named
#' resource.
#'
#' @keywords internal
#'
#' @rdname elasticache_remove_tags_from_resource
elasticache_remove_tags_from_resource <- function(ResourceName, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$remove_tags_from_resource_input(ResourceName = ResourceName, TagKeys = TagKeys)
  output <- .elasticache$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$remove_tags_from_resource <- elasticache_remove_tags_from_resource

#' Modifies the parameters of a cache parameter group to the engine or
#' system default value
#'
#' @description
#' Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the `ResetAllParameters` and `CacheParameterGroupName` parameters.
#'
#' See [https://paws-r.github.io/docs/elasticache/reset_cache_parameter_group.html](https://paws-r.github.io/docs/elasticache/reset_cache_parameter_group.html) for full documentation.
#'
#' @param CacheParameterGroupName &#91;required&#93; The name of the cache parameter group to reset.
#' @param ResetAllParameters If `true`, all parameters in the cache parameter group are reset to
#' their default values. If `false`, only the parameters listed by
#' `ParameterNameValues` are reset to their default values.
#'
#' Valid values: `true` | `false`
#' @param ParameterNameValues An array of parameter names to reset to their default values. If
#' `ResetAllParameters` is `true`, do not use `ParameterNameValues`. If
#' `ResetAllParameters` is `false`, you must specify the name of at least
#' one parameter to reset.
#'
#' @keywords internal
#'
#' @rdname elasticache_reset_cache_parameter_group
elasticache_reset_cache_parameter_group <- function(CacheParameterGroupName, ResetAllParameters = NULL, ParameterNameValues = NULL) {
  op <- new_operation(
    name = "ResetCacheParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$reset_cache_parameter_group_input(CacheParameterGroupName = CacheParameterGroupName, ResetAllParameters = ResetAllParameters, ParameterNameValues = ParameterNameValues)
  output <- .elasticache$reset_cache_parameter_group_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$reset_cache_parameter_group <- elasticache_reset_cache_parameter_group

#' Revokes ingress from a cache security group
#'
#' @description
#' Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security group that had been previously authorized.
#'
#' See [https://paws-r.github.io/docs/elasticache/revoke_cache_security_group_ingress.html](https://paws-r.github.io/docs/elasticache/revoke_cache_security_group_ingress.html) for full documentation.
#'
#' @param CacheSecurityGroupName &#91;required&#93; The name of the cache security group to revoke ingress from.
#' @param EC2SecurityGroupName &#91;required&#93; The name of the Amazon EC2 security group to revoke access from.
#' @param EC2SecurityGroupOwnerId &#91;required&#93; The Amazon account number of the Amazon EC2 security group owner. Note
#' that this is not the same thing as an Amazon access key ID - you must
#' provide a valid Amazon account number for this parameter.
#'
#' @keywords internal
#'
#' @rdname elasticache_revoke_cache_security_group_ingress
elasticache_revoke_cache_security_group_ingress <- function(CacheSecurityGroupName, EC2SecurityGroupName, EC2SecurityGroupOwnerId) {
  op <- new_operation(
    name = "RevokeCacheSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$revoke_cache_security_group_ingress_input(CacheSecurityGroupName = CacheSecurityGroupName, EC2SecurityGroupName = EC2SecurityGroupName, EC2SecurityGroupOwnerId = EC2SecurityGroupOwnerId)
  output <- .elasticache$revoke_cache_security_group_ingress_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$revoke_cache_security_group_ingress <- elasticache_revoke_cache_security_group_ingress

#' Start the migration of data
#'
#' @description
#' Start the migration of data.
#'
#' See [https://paws-r.github.io/docs/elasticache/start_migration.html](https://paws-r.github.io/docs/elasticache/start_migration.html) for full documentation.
#'
#' @param ReplicationGroupId &#91;required&#93; The ID of the replication group to which data should be migrated.
#' @param CustomerNodeEndpointList &#91;required&#93; List of endpoints from which data should be migrated. For Redis (cluster
#' mode disabled), list should have only one element.
#'
#' @keywords internal
#'
#' @rdname elasticache_start_migration
elasticache_start_migration <- function(ReplicationGroupId, CustomerNodeEndpointList) {
  op <- new_operation(
    name = "StartMigration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$start_migration_input(ReplicationGroupId = ReplicationGroupId, CustomerNodeEndpointList = CustomerNodeEndpointList)
  output <- .elasticache$start_migration_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$start_migration <- elasticache_start_migration

#' Represents the input of a TestFailover operation which test automatic
#' failover on a specified node group (called shard in the console) in a
#' replication group (called cluster in the console)
#'
#' @description
#' Represents the input of a [`test_failover`][elasticache_test_failover] operation which test automatic failover on a specified node group (called shard in the console) in a replication group (called cluster in the console).
#'
#' See [https://paws-r.github.io/docs/elasticache/test_failover.html](https://paws-r.github.io/docs/elasticache/test_failover.html) for full documentation.
#'
#' @param ReplicationGroupId &#91;required&#93; The name of the replication group (console: cluster) whose automatic
#' failover is being tested by this operation.
#' @param NodeGroupId &#91;required&#93; The name of the node group (called shard in the console) in this
#' replication group on which automatic failover is to be tested. You may
#' test automatic failover on up to 5 node groups in any rolling 24-hour
#' period.
#'
#' @keywords internal
#'
#' @rdname elasticache_test_failover
elasticache_test_failover <- function(ReplicationGroupId, NodeGroupId) {
  op <- new_operation(
    name = "TestFailover",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$test_failover_input(ReplicationGroupId = ReplicationGroupId, NodeGroupId = NodeGroupId)
  output <- .elasticache$test_failover_output()
  config <- get_config()
  svc <- .elasticache$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$test_failover <- elasticache_test_failover
