# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include docdb_service.R
NULL

#' Adds a source identifier to an existing event notification subscription
#'
#' @description
#' Adds a source identifier to an existing event notification subscription.
#'
#' See [https://paws-r.github.io/docs/docdb/add_source_identifier_to_subscription.html](https://paws-r.github.io/docs/docdb/add_source_identifier_to_subscription.html) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the Amazon DocumentDB event notification subscription that
#' you want to add a source identifier to.
#' @param SourceIdentifier &#91;required&#93; The identifier of the event source to be added:
#' 
#' -   If the source type is an instance, a `DBInstanceIdentifier` must be
#'     provided.
#' 
#' -   If the source type is a security group, a `DBSecurityGroupName` must
#'     be provided.
#' 
#' -   If the source type is a parameter group, a `DBParameterGroupName`
#'     must be provided.
#' 
#' -   If the source type is a snapshot, a `DBSnapshotIdentifier` must be
#'     provided.
#'
#' @keywords internal
#'
#' @rdname docdb_add_source_identifier_to_subscription
docdb_add_source_identifier_to_subscription <- function(SubscriptionName, SourceIdentifier) {
  op <- new_operation(
    name = "AddSourceIdentifierToSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$add_source_identifier_to_subscription_input(SubscriptionName = SubscriptionName, SourceIdentifier = SourceIdentifier)
  output <- .docdb$add_source_identifier_to_subscription_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$add_source_identifier_to_subscription <- docdb_add_source_identifier_to_subscription

#' Adds metadata tags to an Amazon DocumentDB resource
#'
#' @description
#' Adds metadata tags to an Amazon DocumentDB resource. You can use these tags with cost allocation reporting to track costs that are associated with Amazon DocumentDB resources or in a `Condition` statement in an Identity and Access Management (IAM) policy for Amazon DocumentDB.
#'
#' See [https://paws-r.github.io/docs/docdb/add_tags_to_resource.html](https://paws-r.github.io/docs/docdb/add_tags_to_resource.html) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon DocumentDB resource that the tags are added to. This value is
#' an Amazon Resource Name .
#' @param Tags &#91;required&#93; The tags to be assigned to the Amazon DocumentDB resource.
#'
#' @keywords internal
#'
#' @rdname docdb_add_tags_to_resource
docdb_add_tags_to_resource <- function(ResourceName, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$add_tags_to_resource_input(ResourceName = ResourceName, Tags = Tags)
  output <- .docdb$add_tags_to_resource_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$add_tags_to_resource <- docdb_add_tags_to_resource

#' Applies a pending maintenance action to a resource (for example, to an
#' Amazon DocumentDB instance)
#'
#' @description
#' Applies a pending maintenance action to a resource (for example, to an Amazon DocumentDB instance).
#'
#' See [https://paws-r.github.io/docs/docdb/apply_pending_maintenance_action.html](https://paws-r.github.io/docs/docdb/apply_pending_maintenance_action.html) for full documentation.
#'
#' @param ResourceIdentifier &#91;required&#93; The Amazon Resource Name (ARN) of the resource that the pending
#' maintenance action applies to.
#' @param ApplyAction &#91;required&#93; The pending maintenance action to apply to this resource.
#' 
#' Valid values: `system-update`, `db-upgrade`
#' @param OptInType &#91;required&#93; A value that specifies the type of opt-in request or undoes an opt-in
#' request. An opt-in request of type `immediate` can't be undone.
#' 
#' Valid values:
#' 
#' -   `immediate` - Apply the maintenance action immediately.
#' 
#' -   `next-maintenance` - Apply the maintenance action during the next
#'     maintenance window for the resource.
#' 
#' -   `undo-opt-in` - Cancel any existing `next-maintenance` opt-in
#'     requests.
#'
#' @keywords internal
#'
#' @rdname docdb_apply_pending_maintenance_action
docdb_apply_pending_maintenance_action <- function(ResourceIdentifier, ApplyAction, OptInType) {
  op <- new_operation(
    name = "ApplyPendingMaintenanceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$apply_pending_maintenance_action_input(ResourceIdentifier = ResourceIdentifier, ApplyAction = ApplyAction, OptInType = OptInType)
  output <- .docdb$apply_pending_maintenance_action_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$apply_pending_maintenance_action <- docdb_apply_pending_maintenance_action

#' Copies the specified cluster parameter group
#'
#' @description
#' Copies the specified cluster parameter group.
#'
#' See [https://paws-r.github.io/docs/docdb/copy_db_cluster_parameter_group.html](https://paws-r.github.io/docs/docdb/copy_db_cluster_parameter_group.html) for full documentation.
#'
#' @param SourceDBClusterParameterGroupIdentifier &#91;required&#93; The identifier or Amazon Resource Name (ARN) for the source cluster
#' parameter group.
#' 
#' Constraints:
#' 
#' -   Must specify a valid cluster parameter group.
#' 
#' -   If the source cluster parameter group is in the same Amazon Web
#'     Services Region as the copy, specify a valid parameter group
#'     identifier; for example, `my-db-cluster-param-group`, or a valid
#'     ARN.
#' 
#' -   If the source parameter group is in a different Amazon Web Services
#'     Region than the copy, specify a valid cluster parameter group ARN;
#'     for example,
#'     `arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group`.
#' @param TargetDBClusterParameterGroupIdentifier &#91;required&#93; The identifier for the copied cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Cannot be null, empty, or blank.
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster-param-group1`
#' @param TargetDBClusterParameterGroupDescription &#91;required&#93; A description for the copied cluster parameter group.
#' @param Tags The tags that are to be assigned to the parameter group.
#'
#' @keywords internal
#'
#' @rdname docdb_copy_db_cluster_parameter_group
docdb_copy_db_cluster_parameter_group <- function(SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$copy_db_cluster_parameter_group_input(SourceDBClusterParameterGroupIdentifier = SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier = TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription = TargetDBClusterParameterGroupDescription, Tags = Tags)
  output <- .docdb$copy_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$copy_db_cluster_parameter_group <- docdb_copy_db_cluster_parameter_group

#' Copies a snapshot of a cluster
#'
#' @description
#' Copies a snapshot of a cluster.
#'
#' See [https://paws-r.github.io/docs/docdb/copy_db_cluster_snapshot.html](https://paws-r.github.io/docs/docdb/copy_db_cluster_snapshot.html) for full documentation.
#'
#' @param SourceDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the cluster snapshot to copy. This parameter is not
#' case sensitive.
#' 
#' Constraints:
#' 
#' -   Must specify a valid system snapshot in the *available* state.
#' 
#' -   If the source snapshot is in the same Amazon Web Services Region as
#'     the copy, specify a valid snapshot identifier.
#' 
#' -   If the source snapshot is in a different Amazon Web Services Region
#'     than the copy, specify a valid cluster snapshot ARN.
#' 
#' Example: `my-cluster-snapshot1`
#' @param TargetDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the new cluster snapshot to create from the source
#' cluster snapshot. This parameter is not case sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster-snapshot2`
#' @param KmsKeyId The KMS key ID for an encrypted cluster snapshot. The KMS key ID is the
#' Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for
#' the KMS encryption key.
#' 
#' If you copy an encrypted cluster snapshot from your Amazon Web Services
#' account, you can specify a value for `KmsKeyId` to encrypt the copy with
#' a new KMS encryption key. If you don't specify a value for `KmsKeyId`,
#' then the copy of the cluster snapshot is encrypted with the same KMS key
#' as the source cluster snapshot.
#' 
#' If you copy an encrypted cluster snapshot that is shared from another
#' Amazon Web Services account, then you must specify a value for
#' `KmsKeyId`.
#' 
#' To copy an encrypted cluster snapshot to another Amazon Web Services
#' Region, set `KmsKeyId` to the KMS key ID that you want to use to encrypt
#' the copy of the cluster snapshot in the destination Region. KMS
#' encryption keys are specific to the Amazon Web Services Region that they
#' are created in, and you can't use encryption keys from one Amazon Web
#' Services Region in another Amazon Web Services Region.
#' 
#' If you copy an unencrypted cluster snapshot and specify a value for the
#' `KmsKeyId` parameter, an error is returned.
#' @param PreSignedUrl The URL that contains a Signature Version 4 signed request for
#' the[`copy_db_cluster_snapshot`][docdb_copy_db_cluster_snapshot] API
#' action in the Amazon Web Services Region that contains the source
#' cluster snapshot to copy. You must use the `PreSignedUrl` parameter when
#' copying a cluster snapshot from another Amazon Web Services Region.
#' 
#' If you are using an Amazon Web Services SDK tool or the CLI, you can
#' specify `SourceRegion` (or `--source-region` for the CLI) instead of
#' specifying `PreSignedUrl` manually. Specifying `SourceRegion`
#' autogenerates a pre-signed URL that is a valid request for the operation
#' that can be executed in the source Amazon Web Services Region.
#' 
#' The presigned URL must be a valid request for the
#' [`copy_db_cluster_snapshot`][docdb_copy_db_cluster_snapshot] API action
#' that can be executed in the source Amazon Web Services Region that
#' contains the cluster snapshot to be copied. The presigned URL request
#' must contain the following parameter values:
#' 
#' -   `SourceRegion` - The ID of the region that contains the snapshot to
#'     be copied.
#' 
#' -   `SourceDBClusterSnapshotIdentifier` - The identifier for the the
#'     encrypted cluster snapshot to be copied. This identifier must be in
#'     the Amazon Resource Name (ARN) format for the source Amazon Web
#'     Services Region. For example, if you are copying an encrypted
#'     cluster snapshot from the us-east-1 Amazon Web Services Region, then
#'     your `SourceDBClusterSnapshotIdentifier` looks something like the
#'     following:
#'     `arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot`.
#' 
#' -   `TargetDBClusterSnapshotIdentifier` - The identifier for the new
#'     cluster snapshot to be created. This parameter isn't case sensitive.
#' @param CopyTags Set to `true` to copy all tags from the source cluster snapshot to the
#' target cluster snapshot, and otherwise `false`. The default is `false`.
#' @param Tags The tags to be assigned to the cluster snapshot.
#'
#' @keywords internal
#'
#' @rdname docdb_copy_db_cluster_snapshot
docdb_copy_db_cluster_snapshot <- function(SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier, KmsKeyId = NULL, PreSignedUrl = NULL, CopyTags = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$copy_db_cluster_snapshot_input(SourceDBClusterSnapshotIdentifier = SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier = TargetDBClusterSnapshotIdentifier, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, CopyTags = CopyTags, Tags = Tags)
  output <- .docdb$copy_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$copy_db_cluster_snapshot <- docdb_copy_db_cluster_snapshot

#' Creates a new Amazon DocumentDB cluster
#'
#' @description
#' Creates a new Amazon DocumentDB cluster.
#'
#' See [https://paws-r.github.io/docs/docdb/create_db_cluster.html](https://paws-r.github.io/docs/docdb/create_db_cluster.html) for full documentation.
#'
#' @param AvailabilityZones A list of Amazon EC2 Availability Zones that instances in the cluster
#' can be created in.
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. You must
#' specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35.
#' @param DBClusterIdentifier &#91;required&#93; The cluster identifier. This parameter is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster`
#' @param DBClusterParameterGroupName The name of the cluster parameter group to associate with this cluster.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this cluster.
#' @param DBSubnetGroupName A subnet group to associate with this cluster.
#' 
#' Constraints: Must match the name of an existing `DBSubnetGroup`. Must
#' not be default.
#' 
#' Example: `mySubnetgroup`
#' @param Engine &#91;required&#93; The name of the database engine to be used for this cluster.
#' 
#' Valid values: `docdb`
#' @param EngineVersion The version number of the database engine to use. The `--engine-version`
#' will default to the latest major engine version. For production
#' workloads, we recommend explicitly declaring this parameter with the
#' intended major engine version.
#' @param Port The port number on which the instances in the cluster accept
#' connections.
#' @param MasterUsername The name of the master user for the cluster.
#' 
#' Constraints:
#' 
#' -   Must be from 1 to 63 letters or numbers.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot be a reserved word for the chosen database engine.
#' @param MasterUserPassword The password for the master database user. This password can contain any
#' printable ASCII character except forward slash (/), double quote ("), or
#' the "at" symbol (@@).
#' 
#' Constraints: Must contain from 8 to 100 characters.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region.
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region, occurring on a random
#' day of the week.
#' 
#' Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
#' 
#' Constraints: Minimum 30-minute window.
#' @param Tags The tags to be assigned to the cluster.
#' @param StorageEncrypted Specifies whether the cluster is encrypted.
#' @param KmsKeyId The KMS key identifier for an encrypted cluster.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are creating a cluster using the same Amazon Web
#' Services account that owns the KMS encryption key that is used to
#' encrypt the new cluster, you can use the KMS key alias instead of the
#' ARN for the KMS encryption key.
#' 
#' If an encryption key is not specified in `KmsKeyId`:
#' 
#' -   If the `StorageEncrypted` parameter is `true`, Amazon DocumentDB
#'     uses your default encryption key.
#' 
#' KMS creates the default encryption key for your Amazon Web Services
#' account. Your Amazon Web Services account has a different default
#' encryption key for each Amazon Web Services Regions.
#' @param PreSignedUrl Not currently supported.
#' @param EnableCloudwatchLogsExports A list of log types that need to be enabled for exporting to Amazon
#' CloudWatch Logs. You can enable audit logs or profiler logs. For more
#' information, see [Auditing Amazon DocumentDB
#' Events](https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html)
#' and [Profiling Amazon DocumentDB
#' Operations](https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html).
#' @param DeletionProtection Specifies whether this cluster can be deleted. If `DeletionProtection`
#' is enabled, the cluster cannot be deleted unless it is modified and
#' `DeletionProtection` is disabled. `DeletionProtection` protects clusters
#' from being accidentally deleted.
#' @param GlobalClusterIdentifier The cluster identifier of the new global cluster.
#'
#' @keywords internal
#'
#' @rdname docdb_create_db_cluster
docdb_create_db_cluster <- function(AvailabilityZones = NULL, BackupRetentionPeriod = NULL, DBClusterIdentifier, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, DBSubnetGroupName = NULL, Engine, EngineVersion = NULL, Port = NULL, MasterUsername = NULL, MasterUserPassword = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, Tags = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, PreSignedUrl = NULL, EnableCloudwatchLogsExports = NULL, DeletionProtection = NULL, GlobalClusterIdentifier = NULL) {
  op <- new_operation(
    name = "CreateDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_db_cluster_input(AvailabilityZones = AvailabilityZones, BackupRetentionPeriod = BackupRetentionPeriod, DBClusterIdentifier = DBClusterIdentifier, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, DBSubnetGroupName = DBSubnetGroupName, Engine = Engine, EngineVersion = EngineVersion, Port = Port, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, Tags = Tags, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DeletionProtection = DeletionProtection, GlobalClusterIdentifier = GlobalClusterIdentifier)
  output <- .docdb$create_db_cluster_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_db_cluster <- docdb_create_db_cluster

#' Creates a new cluster parameter group
#'
#' @description
#' Creates a new cluster parameter group.
#'
#' See [https://paws-r.github.io/docs/docdb/create_db_cluster_parameter_group.html](https://paws-r.github.io/docs/docdb/create_db_cluster_parameter_group.html) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must not match the name of an existing `DBClusterParameterGroup`.
#' 
#' This value is stored as a lowercase string.
#' @param DBParameterGroupFamily &#91;required&#93; The cluster parameter group family name.
#' @param Description &#91;required&#93; The description for the cluster parameter group.
#' @param Tags The tags to be assigned to the cluster parameter group.
#'
#' @keywords internal
#'
#' @rdname docdb_create_db_cluster_parameter_group
docdb_create_db_cluster_parameter_group <- function(DBClusterParameterGroupName, DBParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, DBParameterGroupFamily = DBParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .docdb$create_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_db_cluster_parameter_group <- docdb_create_db_cluster_parameter_group

#' Creates a snapshot of a cluster
#'
#' @description
#' Creates a snapshot of a cluster.
#'
#' See [https://paws-r.github.io/docs/docdb/create_db_cluster_snapshot.html](https://paws-r.github.io/docs/docdb/create_db_cluster_snapshot.html) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the cluster snapshot. This parameter is stored as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster-snapshot1`
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the cluster to create a snapshot for. This parameter
#' is not case sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBCluster`.
#' 
#' Example: `my-cluster`
#' @param Tags The tags to be assigned to the cluster snapshot.
#'
#' @keywords internal
#'
#' @rdname docdb_create_db_cluster_snapshot
docdb_create_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier, DBClusterIdentifier, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, DBClusterIdentifier = DBClusterIdentifier, Tags = Tags)
  output <- .docdb$create_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_db_cluster_snapshot <- docdb_create_db_cluster_snapshot

#' Creates a new instance
#'
#' @description
#' Creates a new instance.
#'
#' See [https://paws-r.github.io/docs/docdb/create_db_instance.html](https://paws-r.github.io/docs/docdb/create_db_instance.html) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The instance identifier. This parameter is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param DBInstanceClass &#91;required&#93; The compute and memory capacity of the instance; for example,
#' `db.r5.large`.
#' @param Engine &#91;required&#93; The name of the database engine to be used for this instance.
#' 
#' Valid value: `docdb`
#' @param AvailabilityZone The Amazon EC2 Availability Zone that the instance is created in.
#' 
#' Default: A random, system-chosen Availability Zone in the endpoint's
#' Amazon Web Services Region.
#' 
#' Example: `us-east-1d`
#' @param PreferredMaintenanceWindow The time range each week during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region, occurring on a random
#' day of the week.
#' 
#' Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
#' 
#' Constraints: Minimum 30-minute window.
#' @param AutoMinorVersionUpgrade This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB
#' does not perform minor version upgrades regardless of the value set.
#' 
#' Default: `false`
#' @param Tags The tags to be assigned to the instance. You can assign up to 10 tags to
#' an instance.
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the cluster that the instance will belong to.
#' @param CopyTagsToSnapshot A value that indicates whether to copy tags from the DB instance to
#' snapshots of the DB instance. By default, tags are not copied.
#' @param PromotionTier A value that specifies the order in which an Amazon DocumentDB replica
#' is promoted to the primary instance after a failure of the existing
#' primary instance.
#' 
#' Default: 1
#' 
#' Valid values: 0-15
#' @param EnablePerformanceInsights A value that indicates whether to enable Performance Insights for the DB
#' Instance. For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html).
#' @param PerformanceInsightsKMSKeyId The KMS key identifier for encryption of Performance Insights data.
#' 
#' The KMS key identifier is the key ARN, key ID, alias ARN, or alias name
#' for the KMS key.
#' 
#' If you do not specify a value for PerformanceInsightsKMSKeyId, then
#' Amazon DocumentDB uses your default KMS key. There is a default KMS key
#' for your Amazon Web Services account. Your Amazon Web Services account
#' has a different default KMS key for each Amazon Web Services region.
#'
#' @keywords internal
#'
#' @rdname docdb_create_db_instance
docdb_create_db_instance <- function(DBInstanceIdentifier, DBInstanceClass, Engine, AvailabilityZone = NULL, PreferredMaintenanceWindow = NULL, AutoMinorVersionUpgrade = NULL, Tags = NULL, DBClusterIdentifier, CopyTagsToSnapshot = NULL, PromotionTier = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL) {
  op <- new_operation(
    name = "CreateDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, DBInstanceClass = DBInstanceClass, Engine = Engine, AvailabilityZone = AvailabilityZone, PreferredMaintenanceWindow = PreferredMaintenanceWindow, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, Tags = Tags, DBClusterIdentifier = DBClusterIdentifier, CopyTagsToSnapshot = CopyTagsToSnapshot, PromotionTier = PromotionTier, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId)
  output <- .docdb$create_db_instance_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_db_instance <- docdb_create_db_instance

#' Creates a new subnet group
#'
#' @description
#' Creates a new subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/docdb/create_db_subnet_group.html](https://paws-r.github.io/docs/docdb/create_db_subnet_group.html) for full documentation.
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the subnet group. This value is stored as a lowercase
#' string.
#' 
#' Constraints: Must contain no more than 255 letters, numbers, periods,
#' underscores, spaces, or hyphens. Must not be default.
#' 
#' Example: `mySubnetgroup`
#' @param DBSubnetGroupDescription &#91;required&#93; The description for the subnet group.
#' @param SubnetIds &#91;required&#93; The Amazon EC2 subnet IDs for the subnet group.
#' @param Tags The tags to be assigned to the subnet group.
#'
#' @keywords internal
#'
#' @rdname docdb_create_db_subnet_group
docdb_create_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription, SubnetIds, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds, Tags = Tags)
  output <- .docdb$create_db_subnet_group_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_db_subnet_group <- docdb_create_db_subnet_group

#' Creates an Amazon DocumentDB event notification subscription
#'
#' @description
#' Creates an Amazon DocumentDB event notification subscription. This action requires a topic Amazon Resource Name (ARN) created by using the Amazon DocumentDB console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the Amazon SNS console.
#'
#' See [https://paws-r.github.io/docs/docdb/create_event_subscription.html](https://paws-r.github.io/docs/docdb/create_event_subscription.html) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the subscription.
#' 
#' Constraints: The name must be fewer than 255 characters.
#' @param SnsTopicArn &#91;required&#93; The Amazon Resource Name (ARN) of the SNS topic created for event
#' notification. Amazon SNS creates the ARN when you create a topic and
#' subscribe to it.
#' @param SourceType The type of source that is generating the events. For example, if you
#' want to be notified of events generated by an instance, you would set
#' this parameter to `db-instance`. If this value is not specified, all
#' events are returned.
#' 
#' Valid values: `db-instance`, `db-cluster`, `db-parameter-group`,
#' `db-security-group`, `db-cluster-snapshot`
#' @param EventCategories A list of event categories for a `SourceType` that you want to subscribe
#' to.
#' @param SourceIds The list of identifiers of the event sources for which events are
#' returned. If not specified, then all sources are included in the
#' response. An identifier must begin with a letter and must contain only
#' ASCII letters, digits, and hyphens; it can't end with a hyphen or
#' contain two consecutive hyphens.
#' 
#' Constraints:
#' 
#' -   If `SourceIds` are provided, `SourceType` must also be provided.
#' 
#' -   If the source type is an instance, a `DBInstanceIdentifier` must be
#'     provided.
#' 
#' -   If the source type is a security group, a `DBSecurityGroupName` must
#'     be provided.
#' 
#' -   If the source type is a parameter group, a `DBParameterGroupName`
#'     must be provided.
#' 
#' -   If the source type is a snapshot, a `DBSnapshotIdentifier` must be
#'     provided.
#' @param Enabled A Boolean value; set to `true` to activate the subscription, set to
#' `false` to create the subscription but not active it.
#' @param Tags The tags to be assigned to the event subscription.
#'
#' @keywords internal
#'
#' @rdname docdb_create_event_subscription
docdb_create_event_subscription <- function(SubscriptionName, SnsTopicArn, SourceType = NULL, EventCategories = NULL, SourceIds = NULL, Enabled = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, EventCategories = EventCategories, SourceIds = SourceIds, Enabled = Enabled, Tags = Tags)
  output <- .docdb$create_event_subscription_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_event_subscription <- docdb_create_event_subscription

#' Creates an Amazon DocumentDB global cluster that can span multiple
#' multiple Amazon Web Services Regions
#'
#' @description
#' Creates an Amazon DocumentDB global cluster that can span multiple multiple Amazon Web Services Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.
#'
#' See [https://paws-r.github.io/docs/docdb/create_global_cluster.html](https://paws-r.github.io/docs/docdb/create_global_cluster.html) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The cluster identifier of the new global cluster.
#' @param SourceDBClusterIdentifier The Amazon Resource Name (ARN) to use as the primary cluster of the
#' global cluster. This parameter is optional.
#' @param Engine The name of the database engine to be used for this cluster.
#' @param EngineVersion The engine version of the global cluster.
#' @param DeletionProtection The deletion protection setting for the new global cluster. The global
#' cluster can't be deleted when deletion protection is enabled.
#' @param DatabaseName The name for your database of up to 64 alpha-numeric characters. If you
#' do not provide a name, Amazon DocumentDB will not create a database in
#' the global cluster you are creating.
#' @param StorageEncrypted The storage encryption setting for the new global cluster.
#'
#' @keywords internal
#'
#' @rdname docdb_create_global_cluster
docdb_create_global_cluster <- function(GlobalClusterIdentifier, SourceDBClusterIdentifier = NULL, Engine = NULL, EngineVersion = NULL, DeletionProtection = NULL, DatabaseName = NULL, StorageEncrypted = NULL) {
  op <- new_operation(
    name = "CreateGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, SourceDBClusterIdentifier = SourceDBClusterIdentifier, Engine = Engine, EngineVersion = EngineVersion, DeletionProtection = DeletionProtection, DatabaseName = DatabaseName, StorageEncrypted = StorageEncrypted)
  output <- .docdb$create_global_cluster_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_global_cluster <- docdb_create_global_cluster

#' Deletes a previously provisioned cluster
#'
#' @description
#' Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.
#'
#' See [https://paws-r.github.io/docs/docdb/delete_db_cluster.html](https://paws-r.github.io/docs/docdb/delete_db_cluster.html) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The cluster identifier for the cluster to be deleted. This parameter
#' isn't case sensitive.
#' 
#' Constraints:
#' 
#' -   Must match an existing `DBClusterIdentifier`.
#' @param SkipFinalSnapshot Determines whether a final cluster snapshot is created before the
#' cluster is deleted. If `true` is specified, no cluster snapshot is
#' created. If `false` is specified, a cluster snapshot is created before
#' the DB cluster is deleted.
#' 
#' If `SkipFinalSnapshot` is `false`, you must specify a
#' `FinalDBSnapshotIdentifier` parameter.
#' 
#' Default: `false`
#' @param FinalDBSnapshotIdentifier The cluster snapshot identifier of the new cluster snapshot created when
#' `SkipFinalSnapshot` is set to `false`.
#' 
#' Specifying this parameter and also setting the `SkipFinalShapshot`
#' parameter to `true` results in an error.
#' 
#' Constraints:
#' 
#' -   Must be from 1 to 255 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#'
#' @keywords internal
#'
#' @rdname docdb_delete_db_cluster
docdb_delete_db_cluster <- function(DBClusterIdentifier, SkipFinalSnapshot = NULL, FinalDBSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, SkipFinalSnapshot = SkipFinalSnapshot, FinalDBSnapshotIdentifier = FinalDBSnapshotIdentifier)
  output <- .docdb$delete_db_cluster_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_db_cluster <- docdb_delete_db_cluster

#' Deletes a specified cluster parameter group
#'
#' @description
#' Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with any clusters.
#'
#' See [https://paws-r.github.io/docs/docdb/delete_db_cluster_parameter_group.html](https://paws-r.github.io/docs/docdb/delete_db_cluster_parameter_group.html) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must be the name of an existing cluster parameter group.
#' 
#' -   You can't delete a default cluster parameter group.
#' 
#' -   Cannot be associated with any clusters.
#'
#' @keywords internal
#'
#' @rdname docdb_delete_db_cluster_parameter_group
docdb_delete_db_cluster_parameter_group <- function(DBClusterParameterGroupName) {
  op <- new_operation(
    name = "DeleteDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName)
  output <- .docdb$delete_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_db_cluster_parameter_group <- docdb_delete_db_cluster_parameter_group

#' Deletes a cluster snapshot
#'
#' @description
#' Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
#'
#' See [https://paws-r.github.io/docs/docdb/delete_db_cluster_snapshot.html](https://paws-r.github.io/docs/docdb/delete_db_cluster_snapshot.html) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the cluster snapshot to delete.
#' 
#' Constraints: Must be the name of an existing cluster snapshot in the
#' `available` state.
#'
#' @keywords internal
#'
#' @rdname docdb_delete_db_cluster_snapshot
docdb_delete_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DeleteDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .docdb$delete_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_db_cluster_snapshot <- docdb_delete_db_cluster_snapshot

#' Deletes a previously provisioned instance
#'
#' @description
#' Deletes a previously provisioned instance.
#'
#' See [https://paws-r.github.io/docs/docdb/delete_db_instance.html](https://paws-r.github.io/docs/docdb/delete_db_instance.html) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The instance identifier for the instance to be deleted. This parameter
#' isn't case sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing instance.
#'
#' @keywords internal
#'
#' @rdname docdb_delete_db_instance
docdb_delete_db_instance <- function(DBInstanceIdentifier) {
  op <- new_operation(
    name = "DeleteDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier)
  output <- .docdb$delete_db_instance_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_db_instance <- docdb_delete_db_instance

#' Deletes a subnet group
#'
#' @description
#' Deletes a subnet group.
#'
#' See [https://paws-r.github.io/docs/docdb/delete_db_subnet_group.html](https://paws-r.github.io/docs/docdb/delete_db_subnet_group.html) for full documentation.
#'
#' @param DBSubnetGroupName &#91;required&#93; The name of the database subnet group to delete.
#' 
#' You can't delete the default subnet group.
#' 
#' Constraints:
#' 
#' Must match the name of an existing `DBSubnetGroup`. Must not be default.
#' 
#' Example: `mySubnetgroup`
#'
#' @keywords internal
#'
#' @rdname docdb_delete_db_subnet_group
docdb_delete_db_subnet_group <- function(DBSubnetGroupName) {
  op <- new_operation(
    name = "DeleteDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName)
  output <- .docdb$delete_db_subnet_group_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_db_subnet_group <- docdb_delete_db_subnet_group

#' Deletes an Amazon DocumentDB event notification subscription
#'
#' @description
#' Deletes an Amazon DocumentDB event notification subscription.
#'
#' See [https://paws-r.github.io/docs/docdb/delete_event_subscription.html](https://paws-r.github.io/docs/docdb/delete_event_subscription.html) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the Amazon DocumentDB event notification subscription that
#' you want to delete.
#'
#' @keywords internal
#'
#' @rdname docdb_delete_event_subscription
docdb_delete_event_subscription <- function(SubscriptionName) {
  op <- new_operation(
    name = "DeleteEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_event_subscription_input(SubscriptionName = SubscriptionName)
  output <- .docdb$delete_event_subscription_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_event_subscription <- docdb_delete_event_subscription

#' Deletes a global cluster
#'
#' @description
#' Deletes a global cluster. The primary and secondary clusters must already be detached or deleted before attempting to delete a global cluster.
#'
#' See [https://paws-r.github.io/docs/docdb/delete_global_cluster.html](https://paws-r.github.io/docs/docdb/delete_global_cluster.html) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The cluster identifier of the global cluster being deleted.
#'
#' @keywords internal
#'
#' @rdname docdb_delete_global_cluster
docdb_delete_global_cluster <- function(GlobalClusterIdentifier) {
  op <- new_operation(
    name = "DeleteGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier)
  output <- .docdb$delete_global_cluster_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_global_cluster <- docdb_delete_global_cluster

#' Returns a list of certificate authority (CA) certificates provided by
#' Amazon DocumentDB for this Amazon Web Services account
#'
#' @description
#' Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_certificates.html](https://paws-r.github.io/docs/docdb/describe_certificates.html) for full documentation.
#'
#' @param CertificateIdentifier The user-supplied certificate identifier. If this parameter is
#' specified, information for only the specified certificate is returned.
#' If this parameter is omitted, a list of up to `MaxRecords` certificates
#' is returned. This parameter is not case sensitive.
#' 
#' Constraints
#' 
#' -   Must match an existing `CertificateIdentifier`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints:
#' 
#' -   Minimum: 20
#' 
#' -   Maximum: 100
#' @param Marker An optional pagination token provided by a previous
#' [`describe_certificates`][docdb_describe_certificates] request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_certificates
docdb_describe_certificates <- function(CertificateIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_certificates_input(CertificateIdentifier = CertificateIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_certificates_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_certificates <- docdb_describe_certificates

#' Returns a list of DBClusterParameterGroup descriptions
#'
#' @description
#' Returns a list of `DBClusterParameterGroup` descriptions. If a `DBClusterParameterGroupName` parameter is specified, the list contains only the description of the specified cluster parameter group.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_db_cluster_parameter_groups.html](https://paws-r.github.io/docs/docdb/describe_db_cluster_parameter_groups.html) for full documentation.
#'
#' @param DBClusterParameterGroupName The name of a specific cluster parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If provided, must match the name of an existing
#'     `DBClusterParameterGroup`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_cluster_parameter_groups
docdb_describe_db_cluster_parameter_groups <- function(DBClusterParameterGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_cluster_parameter_groups_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_db_cluster_parameter_groups_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_cluster_parameter_groups <- docdb_describe_db_cluster_parameter_groups

#' Returns the detailed parameter list for a particular cluster parameter
#' group
#'
#' @description
#' Returns the detailed parameter list for a particular cluster parameter group.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_db_cluster_parameters.html](https://paws-r.github.io/docs/docdb/describe_db_cluster_parameters.html) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of a specific cluster parameter group to return parameter
#' details for.
#' 
#' Constraints:
#' 
#' -   If provided, must match the name of an existing
#'     `DBClusterParameterGroup`.
#' @param Source A value that indicates to return only parameters for a specific source.
#' Parameter sources can be `engine`, `service`, or `customer`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_cluster_parameters
docdb_describe_db_cluster_parameters <- function(DBClusterParameterGroupName, Source = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_cluster_parameters_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Source = Source, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_db_cluster_parameters_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_cluster_parameters <- docdb_describe_db_cluster_parameters

#' Returns a list of cluster snapshot attribute names and values for a
#' manual DB cluster snapshot
#'
#' @description
#' Returns a list of cluster snapshot attribute names and values for a manual DB cluster snapshot.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_db_cluster_snapshot_attributes.html](https://paws-r.github.io/docs/docdb/describe_db_cluster_snapshot_attributes.html) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the cluster snapshot to describe the attributes for.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_cluster_snapshot_attributes
docdb_describe_db_cluster_snapshot_attributes <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshotAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_cluster_snapshot_attributes_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .docdb$describe_db_cluster_snapshot_attributes_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_cluster_snapshot_attributes <- docdb_describe_db_cluster_snapshot_attributes

#' Returns information about cluster snapshots
#'
#' @description
#' Returns information about cluster snapshots. This API operation supports pagination.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_db_cluster_snapshots.html](https://paws-r.github.io/docs/docdb/describe_db_cluster_snapshots.html) for full documentation.
#'
#' @param DBClusterIdentifier The ID of the cluster to retrieve the list of cluster snapshots for.
#' This parameter can't be used with the `DBClusterSnapshotIdentifier`
#' parameter. This parameter is not case sensitive.
#' 
#' Constraints:
#' 
#' -   If provided, must match the identifier of an existing `DBCluster`.
#' @param DBClusterSnapshotIdentifier A specific cluster snapshot identifier to describe. This parameter can't
#' be used with the `DBClusterIdentifier` parameter. This value is stored
#' as a lowercase string.
#' 
#' Constraints:
#' 
#' -   If provided, must match the identifier of an existing
#'     `DBClusterSnapshot`.
#' 
#' -   If this identifier is for an automated snapshot, the `SnapshotType`
#'     parameter must also be specified.
#' @param SnapshotType The type of cluster snapshots to be returned. You can specify one of the
#' following values:
#' 
#' -   `automated` - Return all cluster snapshots that Amazon DocumentDB
#'     has automatically created for your Amazon Web Services account.
#' 
#' -   `manual` - Return all cluster snapshots that you have manually
#'     created for your Amazon Web Services account.
#' 
#' -   `shared` - Return all manual cluster snapshots that have been shared
#'     to your Amazon Web Services account.
#' 
#' -   `public` - Return all cluster snapshots that have been marked as
#'     public.
#' 
#' If you don't specify a `SnapshotType` value, then both automated and
#' manual cluster snapshots are returned. You can include shared cluster
#' snapshots with these results by setting the `IncludeShared` parameter to
#' `true`. You can include public cluster snapshots with these results by
#' setting the`IncludePublic` parameter to `true`.
#' 
#' The `IncludeShared` and `IncludePublic` parameters don't apply for
#' `SnapshotType` values of `manual` or `automated`. The `IncludePublic`
#' parameter doesn't apply when `SnapshotType` is set to `shared`. The
#' `IncludeShared` parameter doesn't apply when `SnapshotType` is set to
#' `public`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param IncludeShared Set to `true` to include shared manual cluster snapshots from other
#' Amazon Web Services accounts that this Amazon Web Services account has
#' been given permission to copy or restore, and otherwise `false`. The
#' default is `false`.
#' @param IncludePublic Set to `true` to include manual cluster snapshots that are public and
#' can be copied or restored by any Amazon Web Services account, and
#' otherwise `false`. The default is `false`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_cluster_snapshots
docdb_describe_db_cluster_snapshots <- function(DBClusterIdentifier = NULL, DBClusterSnapshotIdentifier = NULL, SnapshotType = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, IncludeShared = NULL, IncludePublic = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_cluster_snapshots_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, SnapshotType = SnapshotType, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, IncludeShared = IncludeShared, IncludePublic = IncludePublic)
  output <- .docdb$describe_db_cluster_snapshots_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_cluster_snapshots <- docdb_describe_db_cluster_snapshots

#' Returns information about provisioned Amazon DocumentDB clusters
#'
#' @description
#' Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages operational technology that is shared with Amazon RDS and Amazon Neptune. Use the `filterName=engine,Values=docdb` filter parameter to return only Amazon DocumentDB clusters.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_db_clusters.html](https://paws-r.github.io/docs/docdb/describe_db_clusters.html) for full documentation.
#'
#' @param DBClusterIdentifier The user-provided cluster identifier. If this parameter is specified,
#' information from only the specific cluster is returned. This parameter
#' isn't case sensitive.
#' 
#' Constraints:
#' 
#' -   If provided, must match an existing `DBClusterIdentifier`.
#' @param Filters A filter that specifies one or more clusters to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts cluster identifiers and cluster Amazon
#'     Resource Names (ARNs). The results list only includes information
#'     about the clusters identified by these ARNs.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_clusters
docdb_describe_db_clusters <- function(DBClusterIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_clusters_input(DBClusterIdentifier = DBClusterIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_db_clusters_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_clusters <- docdb_describe_db_clusters

#' Returns a list of the available engines
#'
#' @description
#' Returns a list of the available engines.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_db_engine_versions.html](https://paws-r.github.io/docs/docdb/describe_db_engine_versions.html) for full documentation.
#'
#' @param Engine The database engine to return.
#' @param EngineVersion The database engine version to return.
#' 
#' Example: `3.6.0`
#' @param DBParameterGroupFamily The name of a specific parameter group family to return details for.
#' 
#' Constraints:
#' 
#' -   If provided, must match an existing `DBParameterGroupFamily`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param DefaultOnly Indicates that only the default version of the specified engine or
#' engine and major version combination is returned.
#' @param ListSupportedCharacterSets If this parameter is specified and the requested engine supports the
#' `CharacterSetName` parameter for
#' [`create_db_instance`][docdb_create_db_instance], the response includes
#' a list of supported character sets for each engine version.
#' @param ListSupportedTimezones If this parameter is specified and the requested engine supports the
#' `TimeZone` parameter for
#' [`create_db_instance`][docdb_create_db_instance], the response includes
#' a list of supported time zones for each engine version.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_engine_versions
docdb_describe_db_engine_versions <- function(Engine = NULL, EngineVersion = NULL, DBParameterGroupFamily = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, DefaultOnly = NULL, ListSupportedCharacterSets = NULL, ListSupportedTimezones = NULL) {
  op <- new_operation(
    name = "DescribeDBEngineVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_engine_versions_input(Engine = Engine, EngineVersion = EngineVersion, DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, DefaultOnly = DefaultOnly, ListSupportedCharacterSets = ListSupportedCharacterSets, ListSupportedTimezones = ListSupportedTimezones)
  output <- .docdb$describe_db_engine_versions_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_engine_versions <- docdb_describe_db_engine_versions

#' Returns information about provisioned Amazon DocumentDB instances
#'
#' @description
#' Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_db_instances.html](https://paws-r.github.io/docs/docdb/describe_db_instances.html) for full documentation.
#'
#' @param DBInstanceIdentifier The user-provided instance identifier. If this parameter is specified,
#' information from only the specific instance is returned. This parameter
#' isn't case sensitive.
#' 
#' Constraints:
#' 
#' -   If provided, must match the identifier of an existing `DBInstance`.
#' @param Filters A filter that specifies one or more instances to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts cluster identifiers and cluster Amazon
#'     Resource Names (ARNs). The results list includes only the
#'     information about the instances that are associated with the
#'     clusters that are identified by these ARNs.
#' 
#' -   `db-instance-id` - Accepts instance identifiers and instance ARNs.
#'     The results list includes only the information about the instances
#'     that are identified by these ARNs.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_instances
docdb_describe_db_instances <- function(DBInstanceIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_instances_input(DBInstanceIdentifier = DBInstanceIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_db_instances_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_instances <- docdb_describe_db_instances

#' Returns a list of DBSubnetGroup descriptions
#'
#' @description
#' Returns a list of `DBSubnetGroup` descriptions. If a `DBSubnetGroupName` is specified, the list will contain only the descriptions of the specified `DBSubnetGroup`.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_db_subnet_groups.html](https://paws-r.github.io/docs/docdb/describe_db_subnet_groups.html) for full documentation.
#'
#' @param DBSubnetGroupName The name of the subnet group to return details for.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_subnet_groups
docdb_describe_db_subnet_groups <- function(DBSubnetGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBSubnetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_subnet_groups_input(DBSubnetGroupName = DBSubnetGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_db_subnet_groups_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_subnet_groups <- docdb_describe_db_subnet_groups

#' Returns the default engine and system parameter information for the
#' cluster database engine
#'
#' @description
#' Returns the default engine and system parameter information for the cluster database engine.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_engine_default_cluster_parameters.html](https://paws-r.github.io/docs/docdb/describe_engine_default_cluster_parameters.html) for full documentation.
#'
#' @param DBParameterGroupFamily &#91;required&#93; The name of the cluster parameter group family to return the engine
#' parameter information for.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_engine_default_cluster_parameters
docdb_describe_engine_default_cluster_parameters <- function(DBParameterGroupFamily, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_engine_default_cluster_parameters_input(DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_engine_default_cluster_parameters_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_engine_default_cluster_parameters <- docdb_describe_engine_default_cluster_parameters

#' Displays a list of categories for all event source types, or, if
#' specified, for a specified source type
#'
#' @description
#' Displays a list of categories for all event source types, or, if specified, for a specified source type.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_event_categories.html](https://paws-r.github.io/docs/docdb/describe_event_categories.html) for full documentation.
#'
#' @param SourceType The type of source that is generating the events.
#' 
#' Valid values: `db-instance`, `db-parameter-group`, `db-security-group`
#' @param Filters This parameter is not currently supported.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_event_categories
docdb_describe_event_categories <- function(SourceType = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeEventCategories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_event_categories_input(SourceType = SourceType, Filters = Filters)
  output <- .docdb$describe_event_categories_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_event_categories <- docdb_describe_event_categories

#' Lists all the subscription descriptions for a customer account
#'
#' @description
#' Lists all the subscription descriptions for a customer account. The description for a subscription includes `SubscriptionName`, `SNSTopicARN`, `CustomerID`, `SourceType`, `SourceID`, `CreationTime`, and `Status`.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_event_subscriptions.html](https://paws-r.github.io/docs/docdb/describe_event_subscriptions.html) for full documentation.
#'
#' @param SubscriptionName The name of the Amazon DocumentDB event notification subscription that
#' you want to describe.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_event_subscriptions
docdb_describe_event_subscriptions <- function(SubscriptionName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEventSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_event_subscriptions_input(SubscriptionName = SubscriptionName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_event_subscriptions_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_event_subscriptions <- docdb_describe_event_subscriptions

#' Returns events related to instances, security groups, snapshots, and DB
#' parameter groups for the past 14 days
#'
#' @description
#' Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days. You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by providing the name as a parameter. By default, the events of the past hour are returned.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_events.html](https://paws-r.github.io/docs/docdb/describe_events.html) for full documentation.
#'
#' @param SourceIdentifier The identifier of the event source for which events are returned. If not
#' specified, then all sources are included in the response.
#' 
#' Constraints:
#' 
#' -   If `SourceIdentifier` is provided, `SourceType` must also be
#'     provided.
#' 
#' -   If the source type is `DBInstance`, a `DBInstanceIdentifier` must be
#'     provided.
#' 
#' -   If the source type is `DBSecurityGroup`, a `DBSecurityGroupName`
#'     must be provided.
#' 
#' -   If the source type is `DBParameterGroup`, a `DBParameterGroupName`
#'     must be provided.
#' 
#' -   If the source type is `DBSnapshot`, a `DBSnapshotIdentifier` must be
#'     provided.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' @param SourceType The event source to retrieve events for. If no value is specified, all
#' events are returned.
#' @param StartTime The beginning of the time interval to retrieve events for, specified in
#' ISO 8601 format.
#' 
#' Example: 2009-07-08T18:00Z
#' @param EndTime The end of the time interval for which to retrieve events, specified in
#' ISO 8601 format.
#' 
#' Example: 2009-07-08T18:00Z
#' @param Duration The number of minutes to retrieve events for.
#' 
#' Default: 60
#' @param EventCategories A list of event categories that trigger notifications for an event
#' notification subscription.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_events
docdb_describe_events <- function(SourceIdentifier = NULL, SourceType = NULL, StartTime = NULL, EndTime = NULL, Duration = NULL, EventCategories = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_events_input(SourceIdentifier = SourceIdentifier, SourceType = SourceType, StartTime = StartTime, EndTime = EndTime, Duration = Duration, EventCategories = EventCategories, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_events_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_events <- docdb_describe_events

#' Returns information about Amazon DocumentDB global clusters
#'
#' @description
#' Returns information about Amazon DocumentDB global clusters. This API supports pagination.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_global_clusters.html](https://paws-r.github.io/docs/docdb/describe_global_clusters.html) for full documentation.
#'
#' @param GlobalClusterIdentifier The user-supplied cluster identifier. If this parameter is specified,
#' information from only the specific cluster is returned. This parameter
#' isn't case-sensitive.
#' @param Filters A filter that specifies one or more global DB clusters to describe.
#' 
#' Supported filters: `db-cluster-id` accepts cluster identifiers and
#' cluster Amazon Resource Names (ARNs). The results list will only include
#' information about the clusters identified by these ARNs.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_global_clusters`][docdb_describe_global_clusters] request. If
#' this parameter is specified, the response includes only records beyond
#' the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_global_clusters
docdb_describe_global_clusters <- function(GlobalClusterIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeGlobalClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_global_clusters_input(GlobalClusterIdentifier = GlobalClusterIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_global_clusters_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_global_clusters <- docdb_describe_global_clusters

#' Returns a list of orderable instance options for the specified engine
#'
#' @description
#' Returns a list of orderable instance options for the specified engine.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_orderable_db_instance_options.html](https://paws-r.github.io/docs/docdb/describe_orderable_db_instance_options.html) for full documentation.
#'
#' @param Engine &#91;required&#93; The name of the engine to retrieve instance options for.
#' @param EngineVersion The engine version filter value. Specify this parameter to show only the
#' available offerings that match the specified engine version.
#' @param DBInstanceClass The instance class filter value. Specify this parameter to show only the
#' available offerings that match the specified instance class.
#' @param LicenseModel The license model filter value. Specify this parameter to show only the
#' available offerings that match the specified license model.
#' @param Vpc The virtual private cloud (VPC) filter value. Specify this parameter to
#' show only the available VPC or non-VPC offerings.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_orderable_db_instance_options
docdb_describe_orderable_db_instance_options <- function(Engine, EngineVersion = NULL, DBInstanceClass = NULL, LicenseModel = NULL, Vpc = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeOrderableDBInstanceOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_orderable_db_instance_options_input(Engine = Engine, EngineVersion = EngineVersion, DBInstanceClass = DBInstanceClass, LicenseModel = LicenseModel, Vpc = Vpc, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_orderable_db_instance_options_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_orderable_db_instance_options <- docdb_describe_orderable_db_instance_options

#' Returns a list of resources (for example, instances) that have at least
#' one pending maintenance action
#'
#' @description
#' Returns a list of resources (for example, instances) that have at least one pending maintenance action.
#'
#' See [https://paws-r.github.io/docs/docdb/describe_pending_maintenance_actions.html](https://paws-r.github.io/docs/docdb/describe_pending_maintenance_actions.html) for full documentation.
#'
#' @param ResourceIdentifier The ARN of a resource to return pending maintenance actions for.
#' @param Filters A filter that specifies one or more resources to return pending
#' maintenance actions for.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts cluster identifiers and cluster Amazon
#'     Resource Names (ARNs). The results list includes only pending
#'     maintenance actions for the clusters identified by these ARNs.
#' 
#' -   `db-instance-id` - Accepts instance identifiers and instance ARNs.
#'     The results list includes only pending maintenance actions for the
#'     DB instances identified by these ARNs.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#'
#' @keywords internal
#'
#' @rdname docdb_describe_pending_maintenance_actions
docdb_describe_pending_maintenance_actions <- function(ResourceIdentifier = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribePendingMaintenanceActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_pending_maintenance_actions_input(ResourceIdentifier = ResourceIdentifier, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .docdb$describe_pending_maintenance_actions_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_pending_maintenance_actions <- docdb_describe_pending_maintenance_actions

#' Forces a failover for a cluster
#'
#' @description
#' Forces a failover for a cluster.
#'
#' See [https://paws-r.github.io/docs/docdb/failover_db_cluster.html](https://paws-r.github.io/docs/docdb/failover_db_cluster.html) for full documentation.
#'
#' @param DBClusterIdentifier A cluster identifier to force a failover for. This parameter is not case
#' sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBCluster`.
#' @param TargetDBInstanceIdentifier The name of the instance to promote to the primary instance.
#' 
#' You must specify the instance identifier for an Amazon DocumentDB
#' replica in the cluster. For example, `mydbcluster-replica1`.
#'
#' @keywords internal
#'
#' @rdname docdb_failover_db_cluster
docdb_failover_db_cluster <- function(DBClusterIdentifier = NULL, TargetDBInstanceIdentifier = NULL) {
  op <- new_operation(
    name = "FailoverDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$failover_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, TargetDBInstanceIdentifier = TargetDBInstanceIdentifier)
  output <- .docdb$failover_db_cluster_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$failover_db_cluster <- docdb_failover_db_cluster

#' Lists all tags on an Amazon DocumentDB resource
#'
#' @description
#' Lists all tags on an Amazon DocumentDB resource.
#'
#' See [https://paws-r.github.io/docs/docdb/list_tags_for_resource.html](https://paws-r.github.io/docs/docdb/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon DocumentDB resource with tags to be listed. This value is an
#' Amazon Resource Name (ARN).
#' @param Filters This parameter is not currently supported.
#'
#' @keywords internal
#'
#' @rdname docdb_list_tags_for_resource
docdb_list_tags_for_resource <- function(ResourceName, Filters = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$list_tags_for_resource_input(ResourceName = ResourceName, Filters = Filters)
  output <- .docdb$list_tags_for_resource_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$list_tags_for_resource <- docdb_list_tags_for_resource

#' Modifies a setting for an Amazon DocumentDB cluster
#'
#' @description
#' Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
#'
#' See [https://paws-r.github.io/docs/docdb/modify_db_cluster.html](https://paws-r.github.io/docs/docdb/modify_db_cluster.html) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The cluster identifier for the cluster that is being modified. This
#' parameter is not case sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBCluster`.
#' @param NewDBClusterIdentifier The new cluster identifier for the cluster when renaming a cluster. This
#' value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster2`
#' @param ApplyImmediately A value that specifies whether the changes in this request and any
#' pending changes are asynchronously applied as soon as possible,
#' regardless of the `PreferredMaintenanceWindow` setting for the cluster.
#' If this parameter is set to `false`, changes to the cluster are applied
#' during the next maintenance window.
#' 
#' The `ApplyImmediately` parameter affects only the
#' `NewDBClusterIdentifier` and `MasterUserPassword` values. If you set
#' this parameter value to `false`, the changes to the
#' `NewDBClusterIdentifier` and `MasterUserPassword` values are applied
#' during the next maintenance window. All other changes are applied
#' immediately, regardless of the value of the `ApplyImmediately`
#' parameter.
#' 
#' Default: `false`
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. You must
#' specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35.
#' @param DBClusterParameterGroupName The name of the cluster parameter group to use for the cluster.
#' @param VpcSecurityGroupIds A list of virtual private cloud (VPC) security groups that the cluster
#' will belong to.
#' @param Port The port number on which the cluster accepts connections.
#' 
#' Constraints: Must be a value from `1150` to `65535`.
#' 
#' Default: The same port as the original cluster.
#' @param MasterUserPassword The password for the master database user. This password can contain any
#' printable ASCII character except forward slash (/), double quote ("), or
#' the "at" symbol (@@).
#' 
#' Constraints: Must contain from 8 to 100 characters.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region.
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region, occurring on a random
#' day of the week.
#' 
#' Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
#' 
#' Constraints: Minimum 30-minute window.
#' @param CloudwatchLogsExportConfiguration The configuration setting for the log types to be enabled for export to
#' Amazon CloudWatch Logs for a specific instance or cluster. The
#' `EnableLogTypes` and `DisableLogTypes` arrays determine which logs are
#' exported (or not exported) to CloudWatch Logs.
#' @param EngineVersion The version number of the database engine to which you want to upgrade.
#' Modifying engine version is not supported on Amazon DocumentDB.
#' @param DeletionProtection Specifies whether this cluster can be deleted. If `DeletionProtection`
#' is enabled, the cluster cannot be deleted unless it is modified and
#' `DeletionProtection` is disabled. `DeletionProtection` protects clusters
#' from being accidentally deleted.
#'
#' @keywords internal
#'
#' @rdname docdb_modify_db_cluster
docdb_modify_db_cluster <- function(DBClusterIdentifier, NewDBClusterIdentifier = NULL, ApplyImmediately = NULL, BackupRetentionPeriod = NULL, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, Port = NULL, MasterUserPassword = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, CloudwatchLogsExportConfiguration = NULL, EngineVersion = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "ModifyDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, NewDBClusterIdentifier = NewDBClusterIdentifier, ApplyImmediately = ApplyImmediately, BackupRetentionPeriod = BackupRetentionPeriod, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Port = Port, MasterUserPassword = MasterUserPassword, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration, EngineVersion = EngineVersion, DeletionProtection = DeletionProtection)
  output <- .docdb$modify_db_cluster_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_db_cluster <- docdb_modify_db_cluster

#' Modifies the parameters of a cluster parameter group
#'
#' @description
#' Modifies the parameters of a cluster parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
#'
#' See [https://paws-r.github.io/docs/docdb/modify_db_cluster_parameter_group.html](https://paws-r.github.io/docs/docdb/modify_db_cluster_parameter_group.html) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the cluster parameter group to modify.
#' @param Parameters &#91;required&#93; A list of parameters in the cluster parameter group to modify.
#'
#' @keywords internal
#'
#' @rdname docdb_modify_db_cluster_parameter_group
docdb_modify_db_cluster_parameter_group <- function(DBClusterParameterGroupName, Parameters) {
  op <- new_operation(
    name = "ModifyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Parameters = Parameters)
  output <- .docdb$modify_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_db_cluster_parameter_group <- docdb_modify_db_cluster_parameter_group

#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual cluster snapshot
#'
#' @description
#' Adds an attribute and values to, or removes an attribute and values from, a manual cluster snapshot.
#'
#' See [https://paws-r.github.io/docs/docdb/modify_db_cluster_snapshot_attribute.html](https://paws-r.github.io/docs/docdb/modify_db_cluster_snapshot_attribute.html) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the cluster snapshot to modify the attributes for.
#' @param AttributeName &#91;required&#93; The name of the cluster snapshot attribute to modify.
#' 
#' To manage authorization for other Amazon Web Services accounts to copy
#' or restore a manual cluster snapshot, set this value to `restore`.
#' @param ValuesToAdd A list of cluster snapshot attributes to add to the attribute specified
#' by `AttributeName`.
#' 
#' To authorize other Amazon Web Services accounts to copy or restore a
#' manual cluster snapshot, set this list to include one or more Amazon Web
#' Services account IDs. To make the manual cluster snapshot restorable by
#' any Amazon Web Services account, set it to `all`. Do not add the `all`
#' value for any manual cluster snapshots that contain private information
#' that you don't want to be available to all Amazon Web Services accounts.
#' @param ValuesToRemove A list of cluster snapshot attributes to remove from the attribute
#' specified by `AttributeName`.
#' 
#' To remove authorization for other Amazon Web Services accounts to copy
#' or restore a manual cluster snapshot, set this list to include one or
#' more Amazon Web Services account identifiers. To remove authorization
#' for any Amazon Web Services account to copy or restore the cluster
#' snapshot, set it to `all` . If you specify `all`, an Amazon Web Services
#' account whose account ID is explicitly added to the `restore` attribute
#' can still copy or restore a manual cluster snapshot.
#'
#' @keywords internal
#'
#' @rdname docdb_modify_db_cluster_snapshot_attribute
docdb_modify_db_cluster_snapshot_attribute <- function(DBClusterSnapshotIdentifier, AttributeName, ValuesToAdd = NULL, ValuesToRemove = NULL) {
  op <- new_operation(
    name = "ModifyDBClusterSnapshotAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_db_cluster_snapshot_attribute_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, AttributeName = AttributeName, ValuesToAdd = ValuesToAdd, ValuesToRemove = ValuesToRemove)
  output <- .docdb$modify_db_cluster_snapshot_attribute_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_db_cluster_snapshot_attribute <- docdb_modify_db_cluster_snapshot_attribute

#' Modifies settings for an instance
#'
#' @description
#' Modifies settings for an instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
#'
#' See [https://paws-r.github.io/docs/docdb/modify_db_instance.html](https://paws-r.github.io/docs/docdb/modify_db_instance.html) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The instance identifier. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBInstance`.
#' @param DBInstanceClass The new compute and memory capacity of the instance; for example,
#' `db.r5.large`. Not all instance classes are available in all Amazon Web
#' Services Regions.
#' 
#' If you modify the instance class, an outage occurs during the change.
#' The change is applied during the next maintenance window, unless
#' `ApplyImmediately` is specified as `true` for this request.
#' 
#' Default: Uses existing setting.
#' @param ApplyImmediately Specifies whether the modifications in this request and any pending
#' modifications are asynchronously applied as soon as possible, regardless
#' of the `PreferredMaintenanceWindow` setting for the instance.
#' 
#' If this parameter is set to `false`, changes to the instance are applied
#' during the next maintenance window. Some parameter changes can cause an
#' outage and are applied on the next reboot.
#' 
#' Default: `false`
#' @param PreferredMaintenanceWindow The weekly time range (in UTC) during which system maintenance can
#' occur, which might result in an outage. Changing this parameter doesn't
#' result in an outage except in the following situation, and the change is
#' asynchronously applied as soon as possible. If there are pending actions
#' that cause a reboot, and the maintenance window is changed to include
#' the current time, changing this parameter causes a reboot of the
#' instance. If you are moving this window to the current time, there must
#' be at least 30 minutes between the current time and end of the window to
#' ensure that pending changes are applied.
#' 
#' Default: Uses existing setting.
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
#' 
#' Constraints: Must be at least 30 minutes.
#' @param AutoMinorVersionUpgrade This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB
#' does not perform minor version upgrades regardless of the value set.
#' @param NewDBInstanceIdentifier The new instance identifier for the instance when renaming an instance.
#' When you change the instance identifier, an instance reboot occurs
#' immediately if you set `Apply Immediately` to `true`. It occurs during
#' the next maintenance window if you set `Apply Immediately` to `false`.
#' This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param CACertificateIdentifier Indicates the certificate that needs to be associated with the instance.
#' @param CopyTagsToSnapshot A value that indicates whether to copy all tags from the DB instance to
#' snapshots of the DB instance. By default, tags are not copied.
#' @param PromotionTier A value that specifies the order in which an Amazon DocumentDB replica
#' is promoted to the primary instance after a failure of the existing
#' primary instance.
#' 
#' Default: 1
#' 
#' Valid values: 0-15
#' @param EnablePerformanceInsights A value that indicates whether to enable Performance Insights for the DB
#' Instance. For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html).
#' @param PerformanceInsightsKMSKeyId The KMS key identifier for encryption of Performance Insights data.
#' 
#' The KMS key identifier is the key ARN, key ID, alias ARN, or alias name
#' for the KMS key.
#' 
#' If you do not specify a value for PerformanceInsightsKMSKeyId, then
#' Amazon DocumentDB uses your default KMS key. There is a default KMS key
#' for your Amazon Web Services account. Your Amazon Web Services account
#' has a different default KMS key for each Amazon Web Services region.
#'
#' @keywords internal
#'
#' @rdname docdb_modify_db_instance
docdb_modify_db_instance <- function(DBInstanceIdentifier, DBInstanceClass = NULL, ApplyImmediately = NULL, PreferredMaintenanceWindow = NULL, AutoMinorVersionUpgrade = NULL, NewDBInstanceIdentifier = NULL, CACertificateIdentifier = NULL, CopyTagsToSnapshot = NULL, PromotionTier = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL) {
  op <- new_operation(
    name = "ModifyDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, DBInstanceClass = DBInstanceClass, ApplyImmediately = ApplyImmediately, PreferredMaintenanceWindow = PreferredMaintenanceWindow, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, NewDBInstanceIdentifier = NewDBInstanceIdentifier, CACertificateIdentifier = CACertificateIdentifier, CopyTagsToSnapshot = CopyTagsToSnapshot, PromotionTier = PromotionTier, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId)
  output <- .docdb$modify_db_instance_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_db_instance <- docdb_modify_db_instance

#' Modifies an existing subnet group
#'
#' @description
#' Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/docdb/modify_db_subnet_group.html](https://paws-r.github.io/docs/docdb/modify_db_subnet_group.html) for full documentation.
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the subnet group. This value is stored as a lowercase
#' string. You can't modify the default subnet group.
#' 
#' Constraints: Must match the name of an existing `DBSubnetGroup`. Must
#' not be default.
#' 
#' Example: `mySubnetgroup`
#' @param DBSubnetGroupDescription The description for the subnet group.
#' @param SubnetIds &#91;required&#93; The Amazon EC2 subnet IDs for the subnet group.
#'
#' @keywords internal
#'
#' @rdname docdb_modify_db_subnet_group
docdb_modify_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription = NULL, SubnetIds) {
  op <- new_operation(
    name = "ModifyDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds)
  output <- .docdb$modify_db_subnet_group_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_db_subnet_group <- docdb_modify_db_subnet_group

#' Modifies an existing Amazon DocumentDB event notification subscription
#'
#' @description
#' Modifies an existing Amazon DocumentDB event notification subscription.
#'
#' See [https://paws-r.github.io/docs/docdb/modify_event_subscription.html](https://paws-r.github.io/docs/docdb/modify_event_subscription.html) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the Amazon DocumentDB event notification subscription.
#' @param SnsTopicArn The Amazon Resource Name (ARN) of the SNS topic created for event
#' notification. The ARN is created by Amazon SNS when you create a topic
#' and subscribe to it.
#' @param SourceType The type of source that is generating the events. For example, if you
#' want to be notified of events generated by an instance, set this
#' parameter to `db-instance`. If this value is not specified, all events
#' are returned.
#' 
#' Valid values: `db-instance`, `db-parameter-group`, `db-security-group`
#' @param EventCategories A list of event categories for a `SourceType` that you want to subscribe
#' to.
#' @param Enabled A Boolean value; set to `true` to activate the subscription.
#'
#' @keywords internal
#'
#' @rdname docdb_modify_event_subscription
docdb_modify_event_subscription <- function(SubscriptionName, SnsTopicArn = NULL, SourceType = NULL, EventCategories = NULL, Enabled = NULL) {
  op <- new_operation(
    name = "ModifyEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, EventCategories = EventCategories, Enabled = Enabled)
  output <- .docdb$modify_event_subscription_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_event_subscription <- docdb_modify_event_subscription

#' Modify a setting for an Amazon DocumentDB global cluster
#'
#' @description
#' Modify a setting for an Amazon DocumentDB global cluster. You can change one or more configuration parameters (for example: deletion protection), or the global cluster identifier by specifying these parameters and the new values in the request.
#'
#' See [https://paws-r.github.io/docs/docdb/modify_global_cluster.html](https://paws-r.github.io/docs/docdb/modify_global_cluster.html) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The identifier for the global cluster being modified. This parameter
#' isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing global cluster.
#' @param NewGlobalClusterIdentifier The new identifier for a global cluster when you modify a global
#' cluster. This value is stored as a lowercase string.
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#'     The first character must be a letter
#' 
#'     Can't end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-cluster2`
#' @param DeletionProtection Indicates if the global cluster has deletion protection enabled. The
#' global cluster can't be deleted when deletion protection is enabled.
#'
#' @keywords internal
#'
#' @rdname docdb_modify_global_cluster
docdb_modify_global_cluster <- function(GlobalClusterIdentifier, NewGlobalClusterIdentifier = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "ModifyGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, NewGlobalClusterIdentifier = NewGlobalClusterIdentifier, DeletionProtection = DeletionProtection)
  output <- .docdb$modify_global_cluster_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_global_cluster <- docdb_modify_global_cluster

#' You might need to reboot your instance, usually for maintenance reasons
#'
#' @description
#' You might need to reboot your instance, usually for maintenance reasons. For example, if you make certain changes, or if you change the cluster parameter group that is associated with the instance, you must reboot the instance for the changes to take effect.
#'
#' See [https://paws-r.github.io/docs/docdb/reboot_db_instance.html](https://paws-r.github.io/docs/docdb/reboot_db_instance.html) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The instance identifier. This parameter is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBInstance`.
#' @param ForceFailover When `true`, the reboot is conducted through a Multi-AZ failover.
#' 
#' Constraint: You can't specify `true` if the instance is not configured
#' for Multi-AZ.
#'
#' @keywords internal
#'
#' @rdname docdb_reboot_db_instance
docdb_reboot_db_instance <- function(DBInstanceIdentifier, ForceFailover = NULL) {
  op <- new_operation(
    name = "RebootDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$reboot_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, ForceFailover = ForceFailover)
  output <- .docdb$reboot_db_instance_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$reboot_db_instance <- docdb_reboot_db_instance

#' Detaches an Amazon DocumentDB secondary cluster from a global cluster
#'
#' @description
#' Detaches an Amazon DocumentDB secondary cluster from a global cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary in a different region.
#'
#' See [https://paws-r.github.io/docs/docdb/remove_from_global_cluster.html](https://paws-r.github.io/docs/docdb/remove_from_global_cluster.html) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The cluster identifier to detach from the Amazon DocumentDB global
#' cluster.
#' @param DbClusterIdentifier &#91;required&#93; The Amazon Resource Name (ARN) identifying the cluster that was detached
#' from the Amazon DocumentDB global cluster.
#'
#' @keywords internal
#'
#' @rdname docdb_remove_from_global_cluster
docdb_remove_from_global_cluster <- function(GlobalClusterIdentifier, DbClusterIdentifier) {
  op <- new_operation(
    name = "RemoveFromGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$remove_from_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, DbClusterIdentifier = DbClusterIdentifier)
  output <- .docdb$remove_from_global_cluster_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$remove_from_global_cluster <- docdb_remove_from_global_cluster

#' Removes a source identifier from an existing Amazon DocumentDB event
#' notification subscription
#'
#' @description
#' Removes a source identifier from an existing Amazon DocumentDB event notification subscription.
#'
#' See [https://paws-r.github.io/docs/docdb/remove_source_identifier_from_subscription.html](https://paws-r.github.io/docs/docdb/remove_source_identifier_from_subscription.html) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the Amazon DocumentDB event notification subscription that
#' you want to remove a source identifier from.
#' @param SourceIdentifier &#91;required&#93; The source identifier to be removed from the subscription, such as the
#' instance identifier for an instance, or the name of a security group.
#'
#' @keywords internal
#'
#' @rdname docdb_remove_source_identifier_from_subscription
docdb_remove_source_identifier_from_subscription <- function(SubscriptionName, SourceIdentifier) {
  op <- new_operation(
    name = "RemoveSourceIdentifierFromSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$remove_source_identifier_from_subscription_input(SubscriptionName = SubscriptionName, SourceIdentifier = SourceIdentifier)
  output <- .docdb$remove_source_identifier_from_subscription_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$remove_source_identifier_from_subscription <- docdb_remove_source_identifier_from_subscription

#' Removes metadata tags from an Amazon DocumentDB resource
#'
#' @description
#' Removes metadata tags from an Amazon DocumentDB resource.
#'
#' See [https://paws-r.github.io/docs/docdb/remove_tags_from_resource.html](https://paws-r.github.io/docs/docdb/remove_tags_from_resource.html) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon DocumentDB resource that the tags are removed from. This
#' value is an Amazon Resource Name (ARN).
#' @param TagKeys &#91;required&#93; The tag key (name) of the tag to be removed.
#'
#' @keywords internal
#'
#' @rdname docdb_remove_tags_from_resource
docdb_remove_tags_from_resource <- function(ResourceName, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$remove_tags_from_resource_input(ResourceName = ResourceName, TagKeys = TagKeys)
  output <- .docdb$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$remove_tags_from_resource <- docdb_remove_tags_from_resource

#' Modifies the parameters of a cluster parameter group to the default
#' value
#'
#' @description
#' Modifies the parameters of a cluster parameter group to the default value. To reset specific parameters, submit a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire cluster parameter group, specify the `DBClusterParameterGroupName` and `ResetAllParameters` parameters.
#'
#' See [https://paws-r.github.io/docs/docdb/reset_db_cluster_parameter_group.html](https://paws-r.github.io/docs/docdb/reset_db_cluster_parameter_group.html) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the cluster parameter group to reset.
#' @param ResetAllParameters A value that is set to `true` to reset all parameters in the cluster
#' parameter group to their default values, and `false` otherwise. You
#' can't use this parameter if there is a list of parameter names specified
#' for the `Parameters` parameter.
#' @param Parameters A list of parameter names in the cluster parameter group to reset to the
#' default values. You can't use this parameter if the `ResetAllParameters`
#' parameter is set to `true`.
#'
#' @keywords internal
#'
#' @rdname docdb_reset_db_cluster_parameter_group
docdb_reset_db_cluster_parameter_group <- function(DBClusterParameterGroupName, ResetAllParameters = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ResetDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$reset_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, ResetAllParameters = ResetAllParameters, Parameters = Parameters)
  output <- .docdb$reset_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$reset_db_cluster_parameter_group <- docdb_reset_db_cluster_parameter_group

#' Creates a new cluster from a snapshot or cluster snapshot
#'
#' @description
#' Creates a new cluster from a snapshot or cluster snapshot.
#'
#' See [https://paws-r.github.io/docs/docdb/restore_db_cluster_from_snapshot.html](https://paws-r.github.io/docs/docdb/restore_db_cluster_from_snapshot.html) for full documentation.
#'
#' @param AvailabilityZones Provides the list of Amazon EC2 Availability Zones that instances in the
#' restored DB cluster can be created in.
#' @param DBClusterIdentifier &#91;required&#93; The name of the cluster to create from the snapshot or cluster snapshot.
#' This parameter isn't case sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-snapshot-id`
#' @param SnapshotIdentifier &#91;required&#93; The identifier for the snapshot or cluster snapshot to restore from.
#' 
#' You can use either the name or the Amazon Resource Name (ARN) to specify
#' a cluster snapshot. However, you can use only the ARN to specify a
#' snapshot.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing snapshot.
#' @param Engine &#91;required&#93; The database engine to use for the new cluster.
#' 
#' Default: The same as source.
#' 
#' Constraint: Must be compatible with the engine of the source.
#' @param EngineVersion The version of the database engine to use for the new cluster.
#' @param Port The port number on which the new cluster accepts connections.
#' 
#' Constraints: Must be a value from `1150` to `65535`.
#' 
#' Default: The same port as the original cluster.
#' @param DBSubnetGroupName The name of the subnet group to use for the new cluster.
#' 
#' Constraints: If provided, must match the name of an existing
#' `DBSubnetGroup`.
#' 
#' Example: `mySubnetgroup`
#' @param VpcSecurityGroupIds A list of virtual private cloud (VPC) security groups that the new
#' cluster will belong to.
#' @param Tags The tags to be assigned to the restored cluster.
#' @param KmsKeyId The KMS key identifier to use when restoring an encrypted cluster from a
#' DB snapshot or cluster snapshot.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are restoring a cluster with the same Amazon Web
#' Services account that owns the KMS encryption key used to encrypt the
#' new cluster, then you can use the KMS key alias instead of the ARN for
#' the KMS encryption key.
#' 
#' If you do not specify a value for the `KmsKeyId` parameter, then the
#' following occurs:
#' 
#' -   If the snapshot or cluster snapshot in `SnapshotIdentifier` is
#'     encrypted, then the restored cluster is encrypted using the KMS key
#'     that was used to encrypt the snapshot or the cluster snapshot.
#' 
#' -   If the snapshot or the cluster snapshot in `SnapshotIdentifier` is
#'     not encrypted, then the restored DB cluster is not encrypted.
#' @param EnableCloudwatchLogsExports A list of log types that must be enabled for exporting to Amazon
#' CloudWatch Logs.
#' @param DeletionProtection Specifies whether this cluster can be deleted. If `DeletionProtection`
#' is enabled, the cluster cannot be deleted unless it is modified and
#' `DeletionProtection` is disabled. `DeletionProtection` protects clusters
#' from being accidentally deleted.
#'
#' @keywords internal
#'
#' @rdname docdb_restore_db_cluster_from_snapshot
docdb_restore_db_cluster_from_snapshot <- function(AvailabilityZones = NULL, DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion = NULL, Port = NULL, DBSubnetGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableCloudwatchLogsExports = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$restore_db_cluster_from_snapshot_input(AvailabilityZones = AvailabilityZones, DBClusterIdentifier = DBClusterIdentifier, SnapshotIdentifier = SnapshotIdentifier, Engine = Engine, EngineVersion = EngineVersion, Port = Port, DBSubnetGroupName = DBSubnetGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DeletionProtection = DeletionProtection)
  output <- .docdb$restore_db_cluster_from_snapshot_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$restore_db_cluster_from_snapshot <- docdb_restore_db_cluster_from_snapshot

#' Restores a cluster to an arbitrary point in time
#'
#' @description
#' Restores a cluster to an arbitrary point in time. Users can restore to any point in time before `LatestRestorableTime` for up to `BackupRetentionPeriod` days. The target cluster is created from the source cluster with the same configuration as the original cluster, except that the new cluster is created with the default security group.
#'
#' See [https://paws-r.github.io/docs/docdb/restore_db_cluster_to_point_in_time.html](https://paws-r.github.io/docs/docdb/restore_db_cluster_to_point_in_time.html) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the new cluster to be created.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' @param RestoreType The type of restore to be performed. You can specify one of the
#' following values:
#' 
#' -   `full-copy` - The new DB cluster is restored as a full copy of the
#'     source DB cluster.
#' 
#' -   `copy-on-write` - The new DB cluster is restored as a clone of the
#'     source DB cluster.
#' 
#' Constraints: You can't specify `copy-on-write` if the engine version of
#' the source DB cluster is earlier than 1.11.
#' 
#' If you don't specify a `RestoreType` value, then the new DB cluster is
#' restored as a full copy of the source DB cluster.
#' @param SourceDBClusterIdentifier &#91;required&#93; The identifier of the source cluster from which to restore.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBCluster`.
#' @param RestoreToTime The date and time to restore the cluster to.
#' 
#' Valid values: A time in Universal Coordinated Time (UTC) format.
#' 
#' Constraints:
#' 
#' -   Must be before the latest restorable time for the instance.
#' 
#' -   Must be specified if the `UseLatestRestorableTime` parameter is not
#'     provided.
#' 
#' -   Cannot be specified if the `UseLatestRestorableTime` parameter is
#'     `true`.
#' 
#' -   Cannot be specified if the `RestoreType` parameter is
#'     `copy-on-write`.
#' 
#' Example: `2015-03-07T23:45:00Z`
#' @param UseLatestRestorableTime A value that is set to `true` to restore the cluster to the latest
#' restorable backup time, and `false` otherwise.
#' 
#' Default: `false`
#' 
#' Constraints: Cannot be specified if the `RestoreToTime` parameter is
#' provided.
#' @param Port The port number on which the new cluster accepts connections.
#' 
#' Constraints: Must be a value from `1150` to `65535`.
#' 
#' Default: The default port for the engine.
#' @param DBSubnetGroupName The subnet group name to use for the new cluster.
#' 
#' Constraints: If provided, must match the name of an existing
#' `DBSubnetGroup`.
#' 
#' Example: `mySubnetgroup`
#' @param VpcSecurityGroupIds A list of VPC security groups that the new cluster belongs to.
#' @param Tags The tags to be assigned to the restored cluster.
#' @param KmsKeyId The KMS key identifier to use when restoring an encrypted cluster from
#' an encrypted cluster.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are restoring a cluster with the same Amazon Web
#' Services account that owns the KMS encryption key used to encrypt the
#' new cluster, then you can use the KMS key alias instead of the ARN for
#' the KMS encryption key.
#' 
#' You can restore to a new cluster and encrypt the new cluster with an KMS
#' key that is different from the KMS key used to encrypt the source
#' cluster. The new DB cluster is encrypted with the KMS key identified by
#' the `KmsKeyId` parameter.
#' 
#' If you do not specify a value for the `KmsKeyId` parameter, then the
#' following occurs:
#' 
#' -   If the cluster is encrypted, then the restored cluster is encrypted
#'     using the KMS key that was used to encrypt the source cluster.
#' 
#' -   If the cluster is not encrypted, then the restored cluster is not
#'     encrypted.
#' 
#' If `DBClusterIdentifier` refers to a cluster that is not encrypted, then
#' the restore request is rejected.
#' @param EnableCloudwatchLogsExports A list of log types that must be enabled for exporting to Amazon
#' CloudWatch Logs.
#' @param DeletionProtection Specifies whether this cluster can be deleted. If `DeletionProtection`
#' is enabled, the cluster cannot be deleted unless it is modified and
#' `DeletionProtection` is disabled. `DeletionProtection` protects clusters
#' from being accidentally deleted.
#'
#' @keywords internal
#'
#' @rdname docdb_restore_db_cluster_to_point_in_time
docdb_restore_db_cluster_to_point_in_time <- function(DBClusterIdentifier, RestoreType = NULL, SourceDBClusterIdentifier, RestoreToTime = NULL, UseLatestRestorableTime = NULL, Port = NULL, DBSubnetGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableCloudwatchLogsExports = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterToPointInTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$restore_db_cluster_to_point_in_time_input(DBClusterIdentifier = DBClusterIdentifier, RestoreType = RestoreType, SourceDBClusterIdentifier = SourceDBClusterIdentifier, RestoreToTime = RestoreToTime, UseLatestRestorableTime = UseLatestRestorableTime, Port = Port, DBSubnetGroupName = DBSubnetGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DeletionProtection = DeletionProtection)
  output <- .docdb$restore_db_cluster_to_point_in_time_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$restore_db_cluster_to_point_in_time <- docdb_restore_db_cluster_to_point_in_time

#' Restarts the stopped cluster that is specified by DBClusterIdentifier
#'
#' @description
#' Restarts the stopped cluster that is specified by `DBClusterIdentifier`. For more information, see [Stopping and Starting an Amazon DocumentDB Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
#'
#' See [https://paws-r.github.io/docs/docdb/start_db_cluster.html](https://paws-r.github.io/docs/docdb/start_db_cluster.html) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the cluster to restart. Example:
#' `docdb-2019-05-28-15-24-52`
#'
#' @keywords internal
#'
#' @rdname docdb_start_db_cluster
docdb_start_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "StartDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$start_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .docdb$start_db_cluster_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$start_db_cluster <- docdb_start_db_cluster

#' Stops the running cluster that is specified by DBClusterIdentifier
#'
#' @description
#' Stops the running cluster that is specified by `DBClusterIdentifier`. The cluster must be in the *available* state. For more information, see [Stopping and Starting an Amazon DocumentDB Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
#'
#' See [https://paws-r.github.io/docs/docdb/stop_db_cluster.html](https://paws-r.github.io/docs/docdb/stop_db_cluster.html) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the cluster to stop. Example:
#' `docdb-2019-05-28-15-24-52`
#'
#' @keywords internal
#'
#' @rdname docdb_stop_db_cluster
docdb_stop_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "StopDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$stop_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .docdb$stop_db_cluster_output()
  config <- get_config()
  svc <- .docdb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$stop_db_cluster <- docdb_stop_db_cluster
