% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdsdataservice_operations.R
\name{rdsdataservice_execute_statement}
\alias{rdsdataservice_execute_statement}
\title{Runs a SQL statement against a database}
\usage{
rdsdataservice_execute_statement(continueAfterTimeout, database,
  includeResultMetadata, parameters, resourceArn, resultSetOptions,
  schema, secretArn, sql, transactionId)
}
\arguments{
\item{continueAfterTimeout}{A value that indicates whether to continue running the statement after
the call times out. By default, the statement stops running when the
call times out.

For DDL statements, we recommend continuing to run the statement after
the call times out. When a DDL statement terminates before it is
finished running, it can result in errors and possibly corrupted data
structures.}

\item{database}{The name of the database.}

\item{includeResultMetadata}{A value that indicates whether to include metadata in the results.}

\item{parameters}{The parameters for the SQL statement.

Array parameters are not supported.}

\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.}

\item{resultSetOptions}{Options that control how the result set is returned.}

\item{schema}{The name of the database schema.}

\item{secretArn}{[required] The name or ARN of the secret that enables access to the DB cluster.}

\item{sql}{[required] The SQL statement to run.}

\item{transactionId}{The identifier of a transaction that was started by using the
\code{\link[=rdsdataservice_begin_transaction]{begin_transaction}} operation.
Specify the transaction ID of the transaction that you want to include
the SQL statement in.

If the SQL statement is not part of a transaction, don't set this
parameter.}
}
\value{
A list with the following syntax:\preformatted{list(
  columnMetadata = list(
    list(
      arrayBaseColumnType = 123,
      isAutoIncrement = TRUE|FALSE,
      isCaseSensitive = TRUE|FALSE,
      isCurrency = TRUE|FALSE,
      isSigned = TRUE|FALSE,
      label = "string",
      name = "string",
      nullable = 123,
      precision = 123,
      scale = 123,
      schemaName = "string",
      tableName = "string",
      type = 123,
      typeName = "string"
    )
  ),
  generatedFields = list(
    list(
      arrayValue = list(
        arrayValues = list(
          list()
        ),
        booleanValues = list(
          TRUE|FALSE
        ),
        doubleValues = list(
          123.0
        ),
        longValues = list(
          123
        ),
        stringValues = list(
          "string"
        )
      ),
      blobValue = raw,
      booleanValue = TRUE|FALSE,
      doubleValue = 123.0,
      isNull = TRUE|FALSE,
      longValue = 123,
      stringValue = "string"
    )
  ),
  numberOfRecordsUpdated = 123,
  records = list(
    list(
      list(
        arrayValue = list(
          arrayValues = list(
            list()
          ),
          booleanValues = list(
            TRUE|FALSE
          ),
          doubleValues = list(
            123.0
          ),
          longValues = list(
            123
          ),
          stringValues = list(
            "string"
          )
        ),
        blobValue = raw,
        booleanValue = TRUE|FALSE,
        doubleValue = 123.0,
        isNull = TRUE|FALSE,
        longValue = 123,
        stringValue = "string"
      )
    )
  )
)
}
}
\description{
Runs a SQL statement against a database.

If a call isn't part of a transaction because it doesn't include the
\code{transactionID} parameter, changes that result from the call are
committed automatically.

The response size limit is 1 MB. If the call returns more than 1 MB of
response data, the call is terminated.
}
\section{Request syntax}{
\preformatted{svc$execute_statement(
  continueAfterTimeout = TRUE|FALSE,
  database = "string",
  includeResultMetadata = TRUE|FALSE,
  parameters = list(
    list(
      name = "string",
      typeHint = "DATE"|"DECIMAL"|"TIME"|"TIMESTAMP",
      value = list(
        arrayValue = list(
          arrayValues = list(
            list()
          ),
          booleanValues = list(
            TRUE|FALSE
          ),
          doubleValues = list(
            123.0
          ),
          longValues = list(
            123
          ),
          stringValues = list(
            "string"
          )
        ),
        blobValue = raw,
        booleanValue = TRUE|FALSE,
        doubleValue = 123.0,
        isNull = TRUE|FALSE,
        longValue = 123,
        stringValue = "string"
      )
    )
  ),
  resourceArn = "string",
  resultSetOptions = list(
    decimalReturnType = "DOUBLE_OR_LONG"|"STRING"
  ),
  schema = "string",
  secretArn = "string",
  sql = "string",
  transactionId = "string"
)
}
}

\keyword{internal}
