% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_stop_db_cluster}
\alias{docdb_stop_db_cluster}
\title{Stops the running cluster that is specified by DBClusterIdentifier}
\usage{
docdb_stop_db_cluster(DBClusterIdentifier)
}
\arguments{
\item{DBClusterIdentifier}{[required] The identifier of the cluster to stop. Example:
\code{docdb-2019-05-28-15-24-52}}
}
\value{
A list with the following syntax:\preformatted{list(
  DBCluster = list(
    AvailabilityZones = list(
      "string"
    ),
    BackupRetentionPeriod = 123,
    DBClusterIdentifier = "string",
    DBClusterParameterGroup = "string",
    DBSubnetGroup = "string",
    Status = "string",
    PercentProgress = "string",
    EarliestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    Endpoint = "string",
    ReaderEndpoint = "string",
    MultiAZ = TRUE|FALSE,
    Engine = "string",
    EngineVersion = "string",
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    Port = 123,
    MasterUsername = "string",
    PreferredBackupWindow = "string",
    PreferredMaintenanceWindow = "string",
    DBClusterMembers = list(
      list(
        DBInstanceIdentifier = "string",
        IsClusterWriter = TRUE|FALSE,
        DBClusterParameterGroupStatus = "string",
        PromotionTier = 123
      )
    ),
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    HostedZoneId = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbClusterResourceId = "string",
    DBClusterArn = "string",
    AssociatedRoles = list(
      list(
        RoleArn = "string",
        Status = "string"
      )
    ),
    ClusterCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    EnabledCloudwatchLogsExports = list(
      "string"
    ),
    DeletionProtection = TRUE|FALSE
  )
)
}
}
\description{
Stops the running cluster that is specified by \code{DBClusterIdentifier}.
The cluster must be in the \emph{available} state. For more information, see
\href{https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html}{Stopping and Starting an Amazon DocumentDB Cluster}.
}
\section{Request syntax}{
\preformatted{svc$stop_db_cluster(
  DBClusterIdentifier = "string"
)
}
}

\keyword{internal}
