% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_create_db_instance}
\alias{docdb_create_db_instance}
\title{Creates a new instance}
\usage{
docdb_create_db_instance(DBInstanceIdentifier, DBInstanceClass, Engine,
  AvailabilityZone, PreferredMaintenanceWindow, AutoMinorVersionUpgrade,
  Tags, DBClusterIdentifier, PromotionTier)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The instance identifier. This parameter is stored as a lowercase string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{mydbinstance}}

\item{DBInstanceClass}{[required] The compute and memory capacity of the instance; for example,
\code{db.r5.large}.}

\item{Engine}{[required] The name of the database engine to be used for this instance.

Valid value: \code{docdb}}

\item{AvailabilityZone}{The Amazon EC2 Availability Zone that the instance is created in.

Default: A random, system-chosen Availability Zone in the endpoint's AWS
Region.

Example: \verb{us-east-1d}}

\item{PreferredMaintenanceWindow}{The time range each week during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region, occurring on a random day of the
week.

Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun

Constraints: Minimum 30-minute window.}

\item{AutoMinorVersionUpgrade}{Indicates that minor engine upgrades are applied automatically to the
instance during the maintenance window.

Default: \code{true}}

\item{Tags}{The tags to be assigned to the instance. You can assign up to 10 tags to
an instance.}

\item{DBClusterIdentifier}{[required] The identifier of the cluster that the instance will belong to.}

\item{PromotionTier}{A value that specifies the order in which an Amazon DocumentDB replica
is promoted to the primary instance after a failure of the existing
primary instance.

Default: 1

Valid values: 0-15}
}
\value{
A list with the following syntax:\preformatted{list(
  DBInstance = list(
    DBInstanceIdentifier = "string",
    DBInstanceClass = "string",
    Engine = "string",
    DBInstanceStatus = "string",
    Endpoint = list(
      Address = "string",
      Port = 123,
      HostedZoneId = "string"
    ),
    InstanceCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    PreferredBackupWindow = "string",
    BackupRetentionPeriod = 123,
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    AvailabilityZone = "string",
    DBSubnetGroup = list(
      DBSubnetGroupName = "string",
      DBSubnetGroupDescription = "string",
      VpcId = "string",
      SubnetGroupStatus = "string",
      Subnets = list(
        list(
          SubnetIdentifier = "string",
          SubnetAvailabilityZone = list(
            Name = "string"
          ),
          SubnetStatus = "string"
        )
      ),
      DBSubnetGroupArn = "string"
    ),
    PreferredMaintenanceWindow = "string",
    PendingModifiedValues = list(
      DBInstanceClass = "string",
      AllocatedStorage = 123,
      MasterUserPassword = "string",
      Port = 123,
      BackupRetentionPeriod = 123,
      MultiAZ = TRUE|FALSE,
      EngineVersion = "string",
      LicenseModel = "string",
      Iops = 123,
      DBInstanceIdentifier = "string",
      StorageType = "string",
      CACertificateIdentifier = "string",
      DBSubnetGroupName = "string",
      PendingCloudwatchLogsExports = list(
        LogTypesToEnable = list(
          "string"
        ),
        LogTypesToDisable = list(
          "string"
        )
      )
    ),
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    EngineVersion = "string",
    AutoMinorVersionUpgrade = TRUE|FALSE,
    PubliclyAccessible = TRUE|FALSE,
    StatusInfos = list(
      list(
        StatusType = "string",
        Normal = TRUE|FALSE,
        Status = "string",
        Message = "string"
      )
    ),
    DBClusterIdentifier = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbiResourceId = "string",
    CACertificateIdentifier = "string",
    PromotionTier = 123,
    DBInstanceArn = "string",
    EnabledCloudwatchLogsExports = list(
      "string"
    )
  )
)
}
}
\description{
Creates a new instance.
}
\section{Request syntax}{
\preformatted{svc$create_db_instance(
  DBInstanceIdentifier = "string",
  DBInstanceClass = "string",
  Engine = "string",
  AvailabilityZone = "string",
  PreferredMaintenanceWindow = "string",
  AutoMinorVersionUpgrade = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  DBClusterIdentifier = "string",
  PromotionTier = 123
)
}
}

\keyword{internal}
