% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_allocate_address}
\alias{ec2_allocate_address}
\title{Allocates an Elastic IP address to your Amazon Web Services account}
\usage{
ec2_allocate_address(
  Domain = NULL,
  Address = NULL,
  PublicIpv4Pool = NULL,
  NetworkBorderGroup = NULL,
  CustomerOwnedIpv4Pool = NULL,
  TagSpecifications = NULL,
  IpamPoolId = NULL,
  DryRun = NULL
)
}
\arguments{
\item{Domain}{The network (\code{vpc}).}

\item{Address}{The Elastic IP address to recover or an IPv4 address from an address
pool.}

\item{PublicIpv4Pool}{The ID of an address pool that you own. Use this parameter to let Amazon
EC2 select an address from the address pool. To specify a specific
address from the address pool, use the \code{Address} parameter instead.}

\item{NetworkBorderGroup}{A unique set of Availability Zones, Local Zones, or Wavelength Zones
from which Amazon Web Services advertises IP addresses. Use this
parameter to limit the IP address to this location. IP addresses cannot
move between network border groups.}

\item{CustomerOwnedIpv4Pool}{The ID of a customer-owned address pool. Use this parameter to let
Amazon EC2 select an address from the address pool. Alternatively,
specify a specific address from the address pool.}

\item{TagSpecifications}{The tags to assign to the Elastic IP address.}

\item{IpamPoolId}{The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4
CIDR provisioned to it. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-eip-pool.html}{Allocate sequential Elastic IP addresses from an IPAM pool}
in the \emph{Amazon VPC IPAM User Guide}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address you can associate it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address pool and can be allocated to a different Amazon Web Services account.

See \url{https://www.paws-r-sdk.com/docs/ec2_allocate_address/} for full documentation.
}
\keyword{internal}
