% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_fpga_image}
\alias{ec2_create_fpga_image}
\title{Creates an Amazon FPGA Image (AFI) from the specified design checkpoint
(DCP)}
\usage{
ec2_create_fpga_image(
  DryRun = NULL,
  InputStorageLocation,
  LogsStorageLocation = NULL,
  Description = NULL,
  Name = NULL,
  ClientToken = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InputStorageLocation}{[required] The location of the encrypted design checkpoint in Amazon S3. The input
must be a tarball.}

\item{LogsStorageLocation}{The location in Amazon S3 for the output logs.}

\item{Description}{A description for the AFI.}

\item{Name}{A name for the AFI.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring Idempotency}.}

\item{TagSpecifications}{The tags to apply to the FPGA image during creation.}
}
\description{
Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).

See \url{https://www.paws-r-sdk.com/docs/ec2_create_fpga_image/} for full documentation.
}
\keyword{internal}
