# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include elasticbeanstalk_service.R
NULL

#' Cancels in-progress environment configuration update or application
#' version deployment
#'
#' @description
#' Cancels in-progress environment configuration update or application version deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_abort_environment_update/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_abort_environment_update/) for full documentation.
#'
#' @param EnvironmentId This specifies the ID of the environment with the in-progress update
#' that you want to cancel.
#' @param EnvironmentName This specifies the name of the environment with the in-progress update
#' that you want to cancel.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_abort_environment_update
elasticbeanstalk_abort_environment_update <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "AbortEnvironmentUpdate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$abort_environment_update_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$abort_environment_update_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$abort_environment_update <- elasticbeanstalk_abort_environment_update

#' Applies a scheduled managed action immediately
#'
#' @description
#' Applies a scheduled managed action immediately. A managed action can be applied only if its status is `Scheduled`. Get the status and action ID of a managed action with [`describe_environment_managed_actions`][elasticbeanstalk_describe_environment_managed_actions].
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_apply_environment_managed_action/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_apply_environment_managed_action/) for full documentation.
#'
#' @param EnvironmentName The name of the target environment.
#' @param EnvironmentId The environment ID of the target environment.
#' @param ActionId &#91;required&#93; The action ID of the scheduled managed action to execute.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_apply_environment_managed_action
elasticbeanstalk_apply_environment_managed_action <- function(EnvironmentName = NULL, EnvironmentId = NULL, ActionId) {
  op <- new_operation(
    name = "ApplyEnvironmentManagedAction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$apply_environment_managed_action_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, ActionId = ActionId)
  output <- .elasticbeanstalk$apply_environment_managed_action_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$apply_environment_managed_action <- elasticbeanstalk_apply_environment_managed_action

#' Add or change the operations role used by an environment
#'
#' @description
#' Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk uses the associated operations role for permissions to downstream services during subsequent calls acting on this environment. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/) in the *AWS Elastic Beanstalk Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_associate_environment_operations_role/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_associate_environment_operations_role/) for full documentation.
#'
#' @param EnvironmentName &#91;required&#93; The name of the environment to which to set the operations role.
#' @param OperationsRole &#91;required&#93; The Amazon Resource Name (ARN) of an existing IAM role to be used as the
#' environment's operations role.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_associate_environment_operations_role
elasticbeanstalk_associate_environment_operations_role <- function(EnvironmentName, OperationsRole) {
  op <- new_operation(
    name = "AssociateEnvironmentOperationsRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$associate_environment_operations_role_input(EnvironmentName = EnvironmentName, OperationsRole = OperationsRole)
  output <- .elasticbeanstalk$associate_environment_operations_role_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$associate_environment_operations_role <- elasticbeanstalk_associate_environment_operations_role

#' Checks if the specified CNAME is available
#'
#' @description
#' Checks if the specified CNAME is available.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_check_dns_availability/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_check_dns_availability/) for full documentation.
#'
#' @param CNAMEPrefix &#91;required&#93; The prefix used when this CNAME is reserved.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_check_dns_availability
elasticbeanstalk_check_dns_availability <- function(CNAMEPrefix) {
  op <- new_operation(
    name = "CheckDNSAvailability",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$check_dns_availability_input(CNAMEPrefix = CNAMEPrefix)
  output <- .elasticbeanstalk$check_dns_availability_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$check_dns_availability <- elasticbeanstalk_check_dns_availability

#' Create or update a group of environments that each run a separate
#' component of a single application
#'
#' @description
#' Create or update a group of environments that each run a separate component of a single application. Takes a list of version labels that specify application source bundles for each of the environments to create or update. The name of each environment and other required information must be included in the source bundles in an environment manifest named `env.yaml`. See [Compose Environments](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html) for details.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_compose_environments/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_compose_environments/) for full documentation.
#'
#' @param ApplicationName The name of the application to which the specified source bundles
#' belong.
#' @param GroupName The name of the group to which the target environments belong. Specify a
#' group name only if the environment name defined in each target
#' environment's manifest ends with a + (plus) character. See [Environment
#' Manifest
#' (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
#' for details.
#' @param VersionLabels A list of version labels, specifying one or more application source
#' bundles that belong to the target application. Each source bundle must
#' include an environment manifest that specifies the name of the
#' environment and the name of the solution stack to use, and optionally
#' can specify environment links to create.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_compose_environments
elasticbeanstalk_compose_environments <- function(ApplicationName = NULL, GroupName = NULL, VersionLabels = NULL) {
  op <- new_operation(
    name = "ComposeEnvironments",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$compose_environments_input(ApplicationName = ApplicationName, GroupName = GroupName, VersionLabels = VersionLabels)
  output <- .elasticbeanstalk$compose_environments_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$compose_environments <- elasticbeanstalk_compose_environments

#' Creates an application that has one configuration template named default
#' and no application versions
#'
#' @description
#' Creates an application that has one configuration template named `default` and no application versions.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_application/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_application/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application. Must be unique within your account.
#' @param Description Your description of the application.
#' @param ResourceLifecycleConfig Specifies an application resource lifecycle configuration to prevent
#' your application from accumulating too many versions.
#' @param Tags Specifies the tags applied to the application.
#' 
#' Elastic Beanstalk applies these tags only to the application.
#' Environments that you create in the application don't inherit the tags.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_application
elasticbeanstalk_create_application <- function(ApplicationName, Description = NULL, ResourceLifecycleConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_application_input(ApplicationName = ApplicationName, Description = Description, ResourceLifecycleConfig = ResourceLifecycleConfig, Tags = Tags)
  output <- .elasticbeanstalk$create_application_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_application <- elasticbeanstalk_create_application

#' Creates an application version for the specified application
#'
#' @description
#' Creates an application version for the specified application. You can create an application version from a source bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows:
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_application_version/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_application_version/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application. If no application is found with this name,
#' and `AutoCreateApplication` is `false`, returns an
#' `InvalidParameterValue` error.
#' @param VersionLabel &#91;required&#93; A label identifying this version.
#' 
#' Constraint: Must be unique per application. If an application version
#' already exists with this label for the specified application, AWS
#' Elastic Beanstalk returns an `InvalidParameterValue` error.
#' @param Description A description of this application version.
#' @param SourceBuildInformation Specify a commit in an AWS CodeCommit Git repository to use as the
#' source code for the application version.
#' @param SourceBundle The Amazon S3 bucket and key that identify the location of the source
#' bundle for this version.
#' 
#' The Amazon S3 bucket must be in the same region as the environment.
#' 
#' Specify a source bundle in S3 or a commit in an AWS CodeCommit
#' repository (with `SourceBuildInformation`), but not both. If neither
#' `SourceBundle` nor `SourceBuildInformation` are provided, Elastic
#' Beanstalk uses a sample application.
#' @param BuildConfiguration Settings for an AWS CodeBuild build.
#' @param AutoCreateApplication Set to `true` to create an application with the specified name if it
#' doesn't already exist.
#' @param Process Pre-processes and validates the environment manifest (`env.yaml`) and
#' configuration files (`*.config` files in the `.ebextensions` folder) in
#' the source bundle. Validating configuration files can identify issues
#' prior to deploying the application version to an environment.
#' 
#' You must turn processing on for application versions that you create
#' using AWS CodeBuild or AWS CodeCommit. For application versions built
#' from a source bundle in Amazon S3, processing is optional.
#' 
#' The `Process` option validates Elastic Beanstalk configuration files. It
#' doesn't validate your application's configuration files, like proxy
#' server or Docker configuration.
#' @param Tags Specifies the tags applied to the application version.
#' 
#' Elastic Beanstalk applies these tags only to the application version.
#' Environments that use the application version don't inherit the tags.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_application_version
elasticbeanstalk_create_application_version <- function(ApplicationName, VersionLabel, Description = NULL, SourceBuildInformation = NULL, SourceBundle = NULL, BuildConfiguration = NULL, AutoCreateApplication = NULL, Process = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateApplicationVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_application_version_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, Description = Description, SourceBuildInformation = SourceBuildInformation, SourceBundle = SourceBundle, BuildConfiguration = BuildConfiguration, AutoCreateApplication = AutoCreateApplication, Process = Process, Tags = Tags)
  output <- .elasticbeanstalk$create_application_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_application_version <- elasticbeanstalk_create_application_version

#' Creates an AWS Elastic Beanstalk configuration template, associated with
#' a specific Elastic Beanstalk application
#'
#' @description
#' Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk application. You define application configuration settings in a configuration template. You can then use the configuration template to deploy different versions of the application with the same configuration settings.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_configuration_template/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_configuration_template/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the Elastic Beanstalk application to associate with this
#' configuration template.
#' @param TemplateName &#91;required&#93; The name of the configuration template.
#' 
#' Constraint: This name must be unique per application.
#' @param SolutionStackName The name of an Elastic Beanstalk solution stack (platform version) that
#' this configuration uses. For example,
#' `64bit Amazon Linux 2013.09 running Tomcat 7 Java 7`. A solution stack
#' specifies the operating system, runtime, and application server for a
#' configuration template. It also determines the set of configuration
#' options as well as the possible and default values. For more
#' information, see [Supported
#' Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
#' in the *AWS Elastic Beanstalk Developer Guide*.
#' 
#' You must specify `SolutionStackName` if you don't specify `PlatformArn`,
#' `EnvironmentId`, or `SourceConfiguration`.
#' 
#' Use the
#' [`list_available_solution_stacks`](https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html)
#' API to obtain a list of available solution stacks.
#' @param PlatformArn The Amazon Resource Name (ARN) of the custom platform. For more
#' information, see [Custom
#' Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html)
#' in the *AWS Elastic Beanstalk Developer Guide*.
#' 
#' If you specify `PlatformArn`, then don't specify `SolutionStackName`.
#' @param SourceConfiguration An Elastic Beanstalk configuration template to base this one on. If
#' specified, Elastic Beanstalk uses the configuration values from the
#' specified configuration template to create a new configuration.
#' 
#' Values specified in `OptionSettings` override any values obtained from
#' the `SourceConfiguration`.
#' 
#' You must specify `SourceConfiguration` if you don't specify
#' `PlatformArn`, `EnvironmentId`, or `SolutionStackName`.
#' 
#' Constraint: If both solution stack name and source configuration are
#' specified, the solution stack of the source configuration template must
#' match the specified solution stack name.
#' @param EnvironmentId The ID of an environment whose settings you want to use to create the
#' configuration template. You must specify `EnvironmentId` if you don't
#' specify `PlatformArn`, `SolutionStackName`, or `SourceConfiguration`.
#' @param Description An optional description for this configuration.
#' @param OptionSettings Option values for the Elastic Beanstalk configuration, such as the
#' instance type. If specified, these values override the values obtained
#' from the solution stack or the source configuration template. For a
#' complete list of Elastic Beanstalk configuration options, see [Option
#' Values](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html)
#' in the *AWS Elastic Beanstalk Developer Guide*.
#' @param Tags Specifies the tags applied to the configuration template.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_configuration_template
elasticbeanstalk_create_configuration_template <- function(ApplicationName, TemplateName, SolutionStackName = NULL, PlatformArn = NULL, SourceConfiguration = NULL, EnvironmentId = NULL, Description = NULL, OptionSettings = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateConfigurationTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_configuration_template_input(ApplicationName = ApplicationName, TemplateName = TemplateName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, SourceConfiguration = SourceConfiguration, EnvironmentId = EnvironmentId, Description = Description, OptionSettings = OptionSettings, Tags = Tags)
  output <- .elasticbeanstalk$create_configuration_template_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_configuration_template <- elasticbeanstalk_create_configuration_template

#' Launches an AWS Elastic Beanstalk environment for the specified
#' application using the specified configuration
#'
#' @description
#' Launches an AWS Elastic Beanstalk environment for the specified application using the specified configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_environment/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_environment/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application that is associated with this environment.
#' @param EnvironmentName A unique name for the environment.
#' 
#' Constraint: Must be from 4 to 40 characters in length. The name can
#' contain only letters, numbers, and hyphens. It can't start or end with a
#' hyphen. This name must be unique within a region in your account. If the
#' specified name already exists in the region, Elastic Beanstalk returns
#' an `InvalidParameterValue` error.
#' 
#' If you don't specify the `CNAMEPrefix` parameter, the environment name
#' becomes part of the CNAME, and therefore part of the visible URL for
#' your application.
#' @param GroupName The name of the group to which the target environment belongs. Specify a
#' group name only if the environment's name is specified in an environment
#' manifest and not with the environment name parameter. See [Environment
#' Manifest
#' (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
#' for details.
#' @param Description Your description for this environment.
#' @param CNAMEPrefix If specified, the environment attempts to use this value as the prefix
#' for the CNAME in your Elastic Beanstalk environment URL. If not
#' specified, the CNAME is generated automatically by appending a random
#' alphanumeric string to the environment name.
#' @param Tier Specifies the tier to use in creating this environment. The environment
#' tier that you choose determines whether Elastic Beanstalk provisions
#' resources to support a web application that handles HTTP(S) requests or
#' a web application that handles background-processing tasks.
#' @param Tags Specifies the tags applied to resources in the environment.
#' @param VersionLabel The name of the application version to deploy.
#' 
#' Default: If not specified, Elastic Beanstalk attempts to deploy the
#' sample application.
#' @param TemplateName The name of the Elastic Beanstalk configuration template to use with the
#' environment.
#' 
#' If you specify `TemplateName`, then don't specify `SolutionStackName`.
#' @param SolutionStackName The name of an Elastic Beanstalk solution stack (platform version) to
#' use with the environment. If specified, Elastic Beanstalk sets the
#' configuration values to the default values associated with the specified
#' solution stack. For a list of current solution stacks, see [Elastic
#' Beanstalk Supported
#' Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html)
#' in the *AWS Elastic Beanstalk Platforms* guide.
#' 
#' If you specify `SolutionStackName`, don't specify `PlatformArn` or
#' `TemplateName`.
#' @param PlatformArn The Amazon Resource Name (ARN) of the custom platform to use with the
#' environment. For more information, see [Custom
#' Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html)
#' in the *AWS Elastic Beanstalk Developer Guide*.
#' 
#' If you specify `PlatformArn`, don't specify `SolutionStackName`.
#' @param OptionSettings If specified, AWS Elastic Beanstalk sets the specified configuration
#' options to the requested value in the configuration set for the new
#' environment. These override the values obtained from the solution stack
#' or the configuration template.
#' @param OptionsToRemove A list of custom user-defined configuration options to remove from the
#' configuration set for this new environment.
#' @param OperationsRole The Amazon Resource Name (ARN) of an existing IAM role to be used as the
#' environment's operations role. If specified, Elastic Beanstalk uses the
#' operations role for permissions to downstream services during this call
#' and during subsequent calls acting on this environment. To specify an
#' operations role, you must have the `iam:PassRole` permission for the
#' role. For more information, see [Operations
#' roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/) in the
#' *AWS Elastic Beanstalk Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_environment
elasticbeanstalk_create_environment <- function(ApplicationName, EnvironmentName = NULL, GroupName = NULL, Description = NULL, CNAMEPrefix = NULL, Tier = NULL, Tags = NULL, VersionLabel = NULL, TemplateName = NULL, SolutionStackName = NULL, PlatformArn = NULL, OptionSettings = NULL, OptionsToRemove = NULL, OperationsRole = NULL) {
  op <- new_operation(
    name = "CreateEnvironment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_environment_input(ApplicationName = ApplicationName, EnvironmentName = EnvironmentName, GroupName = GroupName, Description = Description, CNAMEPrefix = CNAMEPrefix, Tier = Tier, Tags = Tags, VersionLabel = VersionLabel, TemplateName = TemplateName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, OptionSettings = OptionSettings, OptionsToRemove = OptionsToRemove, OperationsRole = OperationsRole)
  output <- .elasticbeanstalk$create_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_environment <- elasticbeanstalk_create_environment

#' Create a new version of your custom platform
#'
#' @description
#' Create a new version of your custom platform.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_platform_version/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_platform_version/) for full documentation.
#'
#' @param PlatformName &#91;required&#93; The name of your custom platform.
#' @param PlatformVersion &#91;required&#93; The number, such as 1.0.2, for the new platform version.
#' @param PlatformDefinitionBundle &#91;required&#93; The location of the platform definition archive in Amazon S3.
#' @param EnvironmentName The name of the builder environment.
#' @param OptionSettings The configuration option settings to apply to the builder environment.
#' @param Tags Specifies the tags applied to the new platform version.
#' 
#' Elastic Beanstalk applies these tags only to the platform version.
#' Environments that you create using the platform version don't inherit
#' the tags.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_platform_version
elasticbeanstalk_create_platform_version <- function(PlatformName, PlatformVersion, PlatformDefinitionBundle, EnvironmentName = NULL, OptionSettings = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePlatformVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_platform_version_input(PlatformName = PlatformName, PlatformVersion = PlatformVersion, PlatformDefinitionBundle = PlatformDefinitionBundle, EnvironmentName = EnvironmentName, OptionSettings = OptionSettings, Tags = Tags)
  output <- .elasticbeanstalk$create_platform_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_platform_version <- elasticbeanstalk_create_platform_version

#' Creates a bucket in Amazon S3 to store application versions, logs, and
#' other files used by Elastic Beanstalk environments
#'
#' @description
#' Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in a region. If the storage location already exists, [`create_storage_location`][elasticbeanstalk_create_storage_location] still returns the bucket name but does not create a new bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_storage_location/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_storage_location/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_storage_location
elasticbeanstalk_create_storage_location <- function() {
  op <- new_operation(
    name = "CreateStorageLocation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_storage_location_input()
  output <- .elasticbeanstalk$create_storage_location_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_storage_location <- elasticbeanstalk_create_storage_location

#' Deletes the specified application along with all associated versions and
#' configurations
#'
#' @description
#' Deletes the specified application along with all associated versions and configurations. The application versions will not be deleted from your Amazon S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_delete_application/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_delete_application/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application to delete.
#' @param TerminateEnvByForce When set to true, running environments will be terminated before
#' deleting the application.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_application
elasticbeanstalk_delete_application <- function(ApplicationName, TerminateEnvByForce = NULL) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_application_input(ApplicationName = ApplicationName, TerminateEnvByForce = TerminateEnvByForce)
  output <- .elasticbeanstalk$delete_application_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_application <- elasticbeanstalk_delete_application

#' Deletes the specified version from the specified application
#'
#' @description
#' Deletes the specified version from the specified application.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_delete_application_version/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_delete_application_version/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application to which the version belongs.
#' @param VersionLabel &#91;required&#93; The label of the version to delete.
#' @param DeleteSourceBundle Set to `true` to delete the source bundle from your storage bucket.
#' Otherwise, the application version is deleted only from Elastic
#' Beanstalk and the source bundle remains in Amazon S3.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_application_version
elasticbeanstalk_delete_application_version <- function(ApplicationName, VersionLabel, DeleteSourceBundle = NULL) {
  op <- new_operation(
    name = "DeleteApplicationVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_application_version_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, DeleteSourceBundle = DeleteSourceBundle)
  output <- .elasticbeanstalk$delete_application_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_application_version <- elasticbeanstalk_delete_application_version

#' Deletes the specified configuration template
#'
#' @description
#' Deletes the specified configuration template.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_delete_configuration_template/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_delete_configuration_template/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application to delete the configuration template from.
#' @param TemplateName &#91;required&#93; The name of the configuration template to delete.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_configuration_template
elasticbeanstalk_delete_configuration_template <- function(ApplicationName, TemplateName) {
  op <- new_operation(
    name = "DeleteConfigurationTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_configuration_template_input(ApplicationName = ApplicationName, TemplateName = TemplateName)
  output <- .elasticbeanstalk$delete_configuration_template_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_configuration_template <- elasticbeanstalk_delete_configuration_template

#' Deletes the draft configuration associated with the running environment
#'
#' @description
#' Deletes the draft configuration associated with the running environment.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_delete_environment_configuration/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_delete_environment_configuration/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application the environment is associated with.
#' @param EnvironmentName &#91;required&#93; The name of the environment to delete the draft configuration from.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_environment_configuration
elasticbeanstalk_delete_environment_configuration <- function(ApplicationName, EnvironmentName) {
  op <- new_operation(
    name = "DeleteEnvironmentConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_environment_configuration_input(ApplicationName = ApplicationName, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$delete_environment_configuration_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_environment_configuration <- elasticbeanstalk_delete_environment_configuration

#' Deletes the specified version of a custom platform
#'
#' @description
#' Deletes the specified version of a custom platform.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_delete_platform_version/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_delete_platform_version/) for full documentation.
#'
#' @param PlatformArn The ARN of the version of the custom platform.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_platform_version
elasticbeanstalk_delete_platform_version <- function(PlatformArn = NULL) {
  op <- new_operation(
    name = "DeletePlatformVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_platform_version_input(PlatformArn = PlatformArn)
  output <- .elasticbeanstalk$delete_platform_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_platform_version <- elasticbeanstalk_delete_platform_version

#' Returns attributes related to AWS Elastic Beanstalk that are associated
#' with the calling AWS account
#'
#' @description
#' Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_account_attributes/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_account_attributes/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_account_attributes
elasticbeanstalk_describe_account_attributes <- function() {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_account_attributes_input()
  output <- .elasticbeanstalk$describe_account_attributes_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_account_attributes <- elasticbeanstalk_describe_account_attributes

#' Retrieve a list of application versions
#'
#' @description
#' Retrieve a list of application versions.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_application_versions/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_application_versions/) for full documentation.
#'
#' @param ApplicationName Specify an application name to show only application versions for that
#' application.
#' @param VersionLabels Specify a version label to show a specific application version.
#' @param MaxRecords For a paginated request. Specify a maximum number of application
#' versions to include in each response.
#' 
#' If no `MaxRecords` is specified, all available application versions are
#' retrieved in a single response.
#' @param NextToken For a paginated request. Specify a token from a previous response page
#' to retrieve the next response page. All other parameter values must be
#' identical to the ones specified in the initial request.
#' 
#' If no `NextToken` is specified, the first page is retrieved.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_application_versions
elasticbeanstalk_describe_application_versions <- function(ApplicationName = NULL, VersionLabels = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeApplicationVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "ApplicationVersions")
  )
  input <- .elasticbeanstalk$describe_application_versions_input(ApplicationName = ApplicationName, VersionLabels = VersionLabels, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_application_versions_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_application_versions <- elasticbeanstalk_describe_application_versions

#' Returns the descriptions of existing applications
#'
#' @description
#' Returns the descriptions of existing applications.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_applications/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_applications/) for full documentation.
#'
#' @param ApplicationNames If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to only include those with the specified names.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_applications
elasticbeanstalk_describe_applications <- function(ApplicationNames = NULL) {
  op <- new_operation(
    name = "DescribeApplications",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "Applications")
  )
  input <- .elasticbeanstalk$describe_applications_input(ApplicationNames = ApplicationNames)
  output <- .elasticbeanstalk$describe_applications_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_applications <- elasticbeanstalk_describe_applications

#' Describes the configuration options that are used in a particular
#' configuration template or environment, or that a specified solution
#' stack defines
#'
#' @description
#' Describes the configuration options that are used in a particular configuration template or environment, or that a specified solution stack defines. The description includes the values the options, their default values, and an indication of the required action on a running environment if an option value is changed.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_configuration_options/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_configuration_options/) for full documentation.
#'
#' @param ApplicationName The name of the application associated with the configuration template
#' or environment. Only needed if you want to describe the configuration
#' options associated with either the configuration template or
#' environment.
#' @param TemplateName The name of the configuration template whose configuration options you
#' want to describe.
#' @param EnvironmentName The name of the environment whose configuration options you want to
#' describe.
#' @param SolutionStackName The name of the solution stack whose configuration options you want to
#' describe.
#' @param PlatformArn The ARN of the custom platform.
#' @param Options If specified, restricts the descriptions to only the specified options.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_configuration_options
elasticbeanstalk_describe_configuration_options <- function(ApplicationName = NULL, TemplateName = NULL, EnvironmentName = NULL, SolutionStackName = NULL, PlatformArn = NULL, Options = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationOptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "Options")
  )
  input <- .elasticbeanstalk$describe_configuration_options_input(ApplicationName = ApplicationName, TemplateName = TemplateName, EnvironmentName = EnvironmentName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, Options = Options)
  output <- .elasticbeanstalk$describe_configuration_options_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_configuration_options <- elasticbeanstalk_describe_configuration_options

#' Returns a description of the settings for the specified configuration
#' set, that is, either a configuration template or the configuration set
#' associated with a running environment
#'
#' @description
#' Returns a description of the settings for the specified configuration set, that is, either a configuration template or the configuration set associated with a running environment.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_configuration_settings/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_configuration_settings/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The application for the environment or configuration template.
#' @param TemplateName The name of the configuration template to describe.
#' 
#' Conditional: You must specify either this parameter or an
#' EnvironmentName, but not both. If you specify both, AWS Elastic
#' Beanstalk returns an `InvalidParameterCombination` error. If you do not
#' specify either, AWS Elastic Beanstalk returns a
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to describe.
#' 
#' Condition: You must specify either this or a TemplateName, but not both.
#' If you specify both, AWS Elastic Beanstalk returns an
#' `InvalidParameterCombination` error. If you do not specify either, AWS
#' Elastic Beanstalk returns `MissingRequiredParameter` error.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_configuration_settings
elasticbeanstalk_describe_configuration_settings <- function(ApplicationName, TemplateName = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationSettings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_configuration_settings_input(ApplicationName = ApplicationName, TemplateName = TemplateName, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$describe_configuration_settings_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_configuration_settings <- elasticbeanstalk_describe_configuration_settings

#' Returns information about the overall health of the specified
#' environment
#'
#' @description
#' Returns information about the overall health of the specified environment. The **DescribeEnvironmentHealth** operation is only available with AWS Elastic Beanstalk Enhanced Health.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_environment_health/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_environment_health/) for full documentation.
#'
#' @param EnvironmentName Specify the environment by name.
#' 
#' You must specify either this or an EnvironmentName, or both.
#' @param EnvironmentId Specify the environment by ID.
#' 
#' You must specify either this or an EnvironmentName, or both.
#' @param AttributeNames Specify the response elements to return. To retrieve all attributes, set
#' to `All`. If no attribute names are specified, returns the name of the
#' environment.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_health
elasticbeanstalk_describe_environment_health <- function(EnvironmentName = NULL, EnvironmentId = NULL, AttributeNames = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentHealth",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environment_health_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, AttributeNames = AttributeNames)
  output <- .elasticbeanstalk$describe_environment_health_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_health <- elasticbeanstalk_describe_environment_health

#' Lists an environment's completed and failed managed actions
#'
#' @description
#' Lists an environment's completed and failed managed actions.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_environment_managed_action_history/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_environment_managed_action_history/) for full documentation.
#'
#' @param EnvironmentId The environment ID of the target environment.
#' @param EnvironmentName The name of the target environment.
#' @param NextToken The pagination token returned by a previous request.
#' @param MaxItems The maximum number of items to return for a single request.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_managed_action_history
elasticbeanstalk_describe_environment_managed_action_history <- function(EnvironmentId = NULL, EnvironmentName = NULL, NextToken = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentManagedActionHistory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxItems", output_token = "NextToken", result_key = "ManagedActionHistoryItems")
  )
  input <- .elasticbeanstalk$describe_environment_managed_action_history_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, NextToken = NextToken, MaxItems = MaxItems)
  output <- .elasticbeanstalk$describe_environment_managed_action_history_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_managed_action_history <- elasticbeanstalk_describe_environment_managed_action_history

#' Lists an environment's upcoming and in-progress managed actions
#'
#' @description
#' Lists an environment's upcoming and in-progress managed actions.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_environment_managed_actions/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_environment_managed_actions/) for full documentation.
#'
#' @param EnvironmentName The name of the target environment.
#' @param EnvironmentId The environment ID of the target environment.
#' @param Status To show only actions with a particular status, specify a status.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_managed_actions
elasticbeanstalk_describe_environment_managed_actions <- function(EnvironmentName = NULL, EnvironmentId = NULL, Status = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentManagedActions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environment_managed_actions_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, Status = Status)
  output <- .elasticbeanstalk$describe_environment_managed_actions_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_managed_actions <- elasticbeanstalk_describe_environment_managed_actions

#' Returns AWS resources for this environment
#'
#' @description
#' Returns AWS resources for this environment.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_environment_resources/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_environment_resources/) for full documentation.
#'
#' @param EnvironmentId The ID of the environment to retrieve AWS resource usage data.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to retrieve AWS resource usage data.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_resources
elasticbeanstalk_describe_environment_resources <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentResources",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environment_resources_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$describe_environment_resources_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_resources <- elasticbeanstalk_describe_environment_resources

#' Returns descriptions for existing environments
#'
#' @description
#' Returns descriptions for existing environments.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_environments/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_environments/) for full documentation.
#'
#' @param ApplicationName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that are associated with this application.
#' @param VersionLabel If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that are associated with this application version.
#' @param EnvironmentIds If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that have the specified IDs.
#' @param EnvironmentNames If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that have the specified names.
#' @param IncludeDeleted Indicates whether to include deleted environments:
#' 
#' `true`: Environments that have been deleted after
#' `IncludedDeletedBackTo` are displayed.
#' 
#' `false`: Do not include deleted environments.
#' @param IncludedDeletedBackTo If specified when `IncludeDeleted` is set to `true`, then environments
#' deleted after this date are displayed.
#' @param MaxRecords For a paginated request. Specify a maximum number of environments to
#' include in each response.
#' 
#' If no `MaxRecords` is specified, all available environments are
#' retrieved in a single response.
#' @param NextToken For a paginated request. Specify a token from a previous response page
#' to retrieve the next response page. All other parameter values must be
#' identical to the ones specified in the initial request.
#' 
#' If no `NextToken` is specified, the first page is retrieved.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environments
elasticbeanstalk_describe_environments <- function(ApplicationName = NULL, VersionLabel = NULL, EnvironmentIds = NULL, EnvironmentNames = NULL, IncludeDeleted = NULL, IncludedDeletedBackTo = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEnvironments",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "Environments")
  )
  input <- .elasticbeanstalk$describe_environments_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, EnvironmentIds = EnvironmentIds, EnvironmentNames = EnvironmentNames, IncludeDeleted = IncludeDeleted, IncludedDeletedBackTo = IncludedDeletedBackTo, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_environments_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environments <- elasticbeanstalk_describe_environments

#' Returns list of event descriptions matching criteria up to the last 6
#' weeks
#'
#' @description
#' Returns list of event descriptions matching criteria up to the last 6 weeks.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_events/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_events/) for full documentation.
#'
#' @param ApplicationName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those associated with this application.
#' @param VersionLabel If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those associated with this application version.
#' @param TemplateName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those that are associated with this environment configuration.
#' @param EnvironmentId If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those associated with this environment.
#' @param EnvironmentName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those associated with this environment.
#' @param PlatformArn The ARN of a custom platform version. If specified, AWS Elastic
#' Beanstalk restricts the returned descriptions to those associated with
#' this custom platform version.
#' @param RequestId If specified, AWS Elastic Beanstalk restricts the described events to
#' include only those associated with this request ID.
#' @param Severity If specified, limits the events returned from this call to include only
#' those with the specified severity or higher.
#' @param StartTime If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those that occur on or after this time.
#' @param EndTime If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those that occur up to, but not including, the `EndTime`.
#' @param MaxRecords Specifies the maximum number of events that can be returned, beginning
#' with the most recent event.
#' @param NextToken Pagination token. If specified, the events return the next batch of
#' results.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_events
elasticbeanstalk_describe_events <- function(ApplicationName = NULL, VersionLabel = NULL, TemplateName = NULL, EnvironmentId = NULL, EnvironmentName = NULL, PlatformArn = NULL, RequestId = NULL, Severity = NULL, StartTime = NULL, EndTime = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "Events")
  )
  input <- .elasticbeanstalk$describe_events_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, TemplateName = TemplateName, EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, PlatformArn = PlatformArn, RequestId = RequestId, Severity = Severity, StartTime = StartTime, EndTime = EndTime, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_events_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_events <- elasticbeanstalk_describe_events

#' Retrieves detailed information about the health of instances in your AWS
#' Elastic Beanstalk
#'
#' @description
#' Retrieves detailed information about the health of instances in your AWS Elastic Beanstalk. This operation requires [enhanced health reporting](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html).
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_instances_health/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_instances_health/) for full documentation.
#'
#' @param EnvironmentName Specify the AWS Elastic Beanstalk environment by name.
#' @param EnvironmentId Specify the AWS Elastic Beanstalk environment by ID.
#' @param AttributeNames Specifies the response elements you wish to receive. To retrieve all
#' attributes, set to `All`. If no attribute names are specified, returns a
#' list of instances.
#' @param NextToken Specify the pagination token returned by a previous call.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_instances_health
elasticbeanstalk_describe_instances_health <- function(EnvironmentName = NULL, EnvironmentId = NULL, AttributeNames = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstancesHealth",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_instances_health_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, AttributeNames = AttributeNames, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_instances_health_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_instances_health <- elasticbeanstalk_describe_instances_health

#' Describes a platform version
#'
#' @description
#' Describes a platform version. Provides full details. Compare to [`list_platform_versions`][elasticbeanstalk_list_platform_versions], which provides summary information about a list of platform versions.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_platform_version/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_platform_version/) for full documentation.
#'
#' @param PlatformArn The ARN of the platform version.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_platform_version
elasticbeanstalk_describe_platform_version <- function(PlatformArn = NULL) {
  op <- new_operation(
    name = "DescribePlatformVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_platform_version_input(PlatformArn = PlatformArn)
  output <- .elasticbeanstalk$describe_platform_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_platform_version <- elasticbeanstalk_describe_platform_version

#' Disassociate the operations role from an environment
#'
#' @description
#' Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses the caller's permissions for permissions to downstream services during subsequent calls acting on this environment. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/) in the *AWS Elastic Beanstalk Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_disassociate_environment_operations_role/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_disassociate_environment_operations_role/) for full documentation.
#'
#' @param EnvironmentName &#91;required&#93; The name of the environment from which to disassociate the operations
#' role.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_disassociate_environment_operations_role
elasticbeanstalk_disassociate_environment_operations_role <- function(EnvironmentName) {
  op <- new_operation(
    name = "DisassociateEnvironmentOperationsRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$disassociate_environment_operations_role_input(EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$disassociate_environment_operations_role_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$disassociate_environment_operations_role <- elasticbeanstalk_disassociate_environment_operations_role

#' Returns a list of the available solution stack names, with the public
#' version first and then in reverse chronological order
#'
#' @description
#' Returns a list of the available solution stack names, with the public version first and then in reverse chronological order.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_list_available_solution_stacks/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_list_available_solution_stacks/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_list_available_solution_stacks
elasticbeanstalk_list_available_solution_stacks <- function() {
  op <- new_operation(
    name = "ListAvailableSolutionStacks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "SolutionStacks")
  )
  input <- .elasticbeanstalk$list_available_solution_stacks_input()
  output <- .elasticbeanstalk$list_available_solution_stacks_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$list_available_solution_stacks <- elasticbeanstalk_list_available_solution_stacks

#' Lists the platform branches available for your account in an AWS Region
#'
#' @description
#' Lists the platform branches available for your account in an AWS Region. Provides summary information about each platform branch.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_list_platform_branches/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_list_platform_branches/) for full documentation.
#'
#' @param Filters Criteria for restricting the resulting list of platform branches. The
#' filter is evaluated as a logical conjunction (AND) of the separate
#' `SearchFilter` terms.
#' 
#' The following list shows valid attribute values for each of the
#' `SearchFilter` terms. Most operators take a single value. The `in` and
#' `not_in` operators can take multiple values.
#' 
#' -   `Attribute = BranchName`:
#' 
#'     -   `Operator`: `=` | `!=` | `begins_with` | `ends_with` |
#'         `contains` | `in` | `not_in`
#' 
#' -   `Attribute = LifecycleState`:
#' 
#'     -   `Operator`: `=` | `!=` | `in` | `not_in`
#' 
#'     -   `Values`: `beta` | `supported` | `deprecated` | `retired`
#' 
#' -   `Attribute = PlatformName`:
#' 
#'     -   `Operator`: `=` | `!=` | `begins_with` | `ends_with` |
#'         `contains` | `in` | `not_in`
#' 
#' -   `Attribute = TierType`:
#' 
#'     -   `Operator`: `=` | `!=`
#' 
#'     -   `Values`: `WebServer/Standard` | `Worker/SQS/HTTP`
#' 
#' Array size: limited to 10 `SearchFilter` objects.
#' 
#' Within each `SearchFilter` item, the `Values` array is limited to 10
#' items.
#' @param MaxRecords The maximum number of platform branch values returned in one call.
#' @param NextToken For a paginated request. Specify a token from a previous response page
#' to retrieve the next response page. All other parameter values must be
#' identical to the ones specified in the initial request.
#' 
#' If no `NextToken` is specified, the first page is retrieved.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_list_platform_branches
elasticbeanstalk_list_platform_branches <- function(Filters = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPlatformBranches",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken")
  )
  input <- .elasticbeanstalk$list_platform_branches_input(Filters = Filters, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$list_platform_branches_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$list_platform_branches <- elasticbeanstalk_list_platform_branches

#' Lists the platform versions available for your account in an AWS Region
#'
#' @description
#' Lists the platform versions available for your account in an AWS Region. Provides summary information about each platform version. Compare to [`describe_platform_version`][elasticbeanstalk_describe_platform_version], which provides full details about a single platform version.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_list_platform_versions/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_list_platform_versions/) for full documentation.
#'
#' @param Filters Criteria for restricting the resulting list of platform versions. The
#' filter is interpreted as a logical conjunction (AND) of the separate
#' `PlatformFilter` terms.
#' @param MaxRecords The maximum number of platform version values returned in one call.
#' @param NextToken For a paginated request. Specify a token from a previous response page
#' to retrieve the next response page. All other parameter values must be
#' identical to the ones specified in the initial request.
#' 
#' If no `NextToken` is specified, the first page is retrieved.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_list_platform_versions
elasticbeanstalk_list_platform_versions <- function(Filters = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPlatformVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "PlatformSummaryList")
  )
  input <- .elasticbeanstalk$list_platform_versions_input(Filters = Filters, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$list_platform_versions_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$list_platform_versions <- elasticbeanstalk_list_platform_versions

#' Return the tags applied to an AWS Elastic Beanstalk resource
#'
#' @description
#' Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value pairs.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resouce for which a tag list is
#' requested.
#' 
#' Must be the ARN of an Elastic Beanstalk resource.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_list_tags_for_resource
elasticbeanstalk_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .elasticbeanstalk$list_tags_for_resource_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$list_tags_for_resource <- elasticbeanstalk_list_tags_for_resource

#' Deletes and recreates all of the AWS resources (for example: the Auto
#' Scaling group, load balancer, etc
#'
#' @description
#' Deletes and recreates all of the AWS resources (for example: the Auto Scaling group, load balancer, etc.) for a specified environment and forces a restart.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_rebuild_environment/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_rebuild_environment/) for full documentation.
#'
#' @param EnvironmentId The ID of the environment to rebuild.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to rebuild.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_rebuild_environment
elasticbeanstalk_rebuild_environment <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "RebuildEnvironment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$rebuild_environment_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$rebuild_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$rebuild_environment <- elasticbeanstalk_rebuild_environment

#' Initiates a request to compile the specified type of information of the
#' deployed environment
#'
#' @description
#' Initiates a request to compile the specified type of information of the deployed environment.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_request_environment_info/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_request_environment_info/) for full documentation.
#'
#' @param EnvironmentId The ID of the environment of the requested data.
#' 
#' If no such environment is found,
#' [`request_environment_info`][elasticbeanstalk_request_environment_info]
#' returns an `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment of the requested data.
#' 
#' If no such environment is found,
#' [`request_environment_info`][elasticbeanstalk_request_environment_info]
#' returns an `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param InfoType &#91;required&#93; The type of information to request.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_request_environment_info
elasticbeanstalk_request_environment_info <- function(EnvironmentId = NULL, EnvironmentName = NULL, InfoType) {
  op <- new_operation(
    name = "RequestEnvironmentInfo",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$request_environment_info_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, InfoType = InfoType)
  output <- .elasticbeanstalk$request_environment_info_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$request_environment_info <- elasticbeanstalk_request_environment_info

#' Causes the environment to restart the application container server
#' running on each Amazon EC2 instance
#'
#' @description
#' Causes the environment to restart the application container server running on each Amazon EC2 instance.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_restart_app_server/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_restart_app_server/) for full documentation.
#'
#' @param EnvironmentId The ID of the environment to restart the server for.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to restart the server for.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_restart_app_server
elasticbeanstalk_restart_app_server <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "RestartAppServer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$restart_app_server_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$restart_app_server_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$restart_app_server <- elasticbeanstalk_restart_app_server

#' Retrieves the compiled information from a RequestEnvironmentInfo request
#'
#' @description
#' Retrieves the compiled information from a [`request_environment_info`][elasticbeanstalk_request_environment_info] request.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_retrieve_environment_info/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_retrieve_environment_info/) for full documentation.
#'
#' @param EnvironmentId The ID of the data's environment.
#' 
#' If no such environment is found, returns an `InvalidParameterValue`
#' error.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the data's environment.
#' 
#' If no such environment is found, returns an `InvalidParameterValue`
#' error.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param InfoType &#91;required&#93; The type of information to retrieve.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_retrieve_environment_info
elasticbeanstalk_retrieve_environment_info <- function(EnvironmentId = NULL, EnvironmentName = NULL, InfoType) {
  op <- new_operation(
    name = "RetrieveEnvironmentInfo",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$retrieve_environment_info_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, InfoType = InfoType)
  output <- .elasticbeanstalk$retrieve_environment_info_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$retrieve_environment_info <- elasticbeanstalk_retrieve_environment_info

#' Swaps the CNAMEs of two environments
#'
#' @description
#' Swaps the CNAMEs of two environments.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_swap_environment_cnam_es/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_swap_environment_cnam_es/) for full documentation.
#'
#' @param SourceEnvironmentId The ID of the source environment.
#' 
#' Condition: You must specify at least the `SourceEnvironmentID` or the
#' `SourceEnvironmentName`. You may also specify both. If you specify the
#' `SourceEnvironmentId`, you must specify the `DestinationEnvironmentId`.
#' @param SourceEnvironmentName The name of the source environment.
#' 
#' Condition: You must specify at least the `SourceEnvironmentID` or the
#' `SourceEnvironmentName`. You may also specify both. If you specify the
#' `SourceEnvironmentName`, you must specify the
#' `DestinationEnvironmentName`.
#' @param DestinationEnvironmentId The ID of the destination environment.
#' 
#' Condition: You must specify at least the `DestinationEnvironmentID` or
#' the `DestinationEnvironmentName`. You may also specify both. You must
#' specify the `SourceEnvironmentId` with the `DestinationEnvironmentId`.
#' @param DestinationEnvironmentName The name of the destination environment.
#' 
#' Condition: You must specify at least the `DestinationEnvironmentID` or
#' the `DestinationEnvironmentName`. You may also specify both. You must
#' specify the `SourceEnvironmentName` with the
#' `DestinationEnvironmentName`.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_swap_environment_cnam_es
elasticbeanstalk_swap_environment_cnam_es <- function(SourceEnvironmentId = NULL, SourceEnvironmentName = NULL, DestinationEnvironmentId = NULL, DestinationEnvironmentName = NULL) {
  op <- new_operation(
    name = "SwapEnvironmentCNAMEs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$swap_environment_cnam_es_input(SourceEnvironmentId = SourceEnvironmentId, SourceEnvironmentName = SourceEnvironmentName, DestinationEnvironmentId = DestinationEnvironmentId, DestinationEnvironmentName = DestinationEnvironmentName)
  output <- .elasticbeanstalk$swap_environment_cnam_es_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$swap_environment_cnam_es <- elasticbeanstalk_swap_environment_cnam_es

#' Terminates the specified environment
#'
#' @description
#' Terminates the specified environment.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_terminate_environment/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_terminate_environment/) for full documentation.
#'
#' @param EnvironmentId The ID of the environment to terminate.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to terminate.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param TerminateResources Indicates whether the associated AWS resources should shut down when the
#' environment is terminated:
#' 
#' -   `true`: The specified environment as well as the associated AWS
#'     resources, such as Auto Scaling group and LoadBalancer, are
#'     terminated.
#' 
#' -   `false`: AWS Elastic Beanstalk resource management is removed from
#'     the environment, but the AWS resources continue to operate.
#' 
#' For more information, see the [AWS Elastic Beanstalk User
#' Guide.](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/)
#' 
#' Default: `true`
#' 
#' Valid Values: `true` | `false`
#' @param ForceTerminate Terminates the target environment even if another environment in the
#' same group is dependent on it.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_terminate_environment
elasticbeanstalk_terminate_environment <- function(EnvironmentId = NULL, EnvironmentName = NULL, TerminateResources = NULL, ForceTerminate = NULL) {
  op <- new_operation(
    name = "TerminateEnvironment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$terminate_environment_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, TerminateResources = TerminateResources, ForceTerminate = ForceTerminate)
  output <- .elasticbeanstalk$terminate_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$terminate_environment <- elasticbeanstalk_terminate_environment

#' Updates the specified application to have the specified properties
#'
#' @description
#' Updates the specified application to have the specified properties.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_application/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_application/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application to update. If no such application is found,
#' [`update_application`][elasticbeanstalk_update_application] returns an
#' `InvalidParameterValue` error.
#' @param Description A new description for the application.
#' 
#' Default: If not specified, AWS Elastic Beanstalk does not update the
#' description.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_application
elasticbeanstalk_update_application <- function(ApplicationName, Description = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_application_input(ApplicationName = ApplicationName, Description = Description)
  output <- .elasticbeanstalk$update_application_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_application <- elasticbeanstalk_update_application

#' Modifies lifecycle settings for an application
#'
#' @description
#' Modifies lifecycle settings for an application.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_application_resource_lifecycle/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_application_resource_lifecycle/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' @param ResourceLifecycleConfig &#91;required&#93; The lifecycle configuration.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_application_resource_lifecycle
elasticbeanstalk_update_application_resource_lifecycle <- function(ApplicationName, ResourceLifecycleConfig) {
  op <- new_operation(
    name = "UpdateApplicationResourceLifecycle",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_application_resource_lifecycle_input(ApplicationName = ApplicationName, ResourceLifecycleConfig = ResourceLifecycleConfig)
  output <- .elasticbeanstalk$update_application_resource_lifecycle_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_application_resource_lifecycle <- elasticbeanstalk_update_application_resource_lifecycle

#' Updates the specified application version to have the specified
#' properties
#'
#' @description
#' Updates the specified application version to have the specified properties.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_application_version/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_application_version/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application associated with this version.
#' 
#' If no application is found with this name,
#' [`update_application`][elasticbeanstalk_update_application] returns an
#' `InvalidParameterValue` error.
#' @param VersionLabel &#91;required&#93; The name of the version to update.
#' 
#' If no application version is found with this label,
#' [`update_application`][elasticbeanstalk_update_application] returns an
#' `InvalidParameterValue` error.
#' @param Description A new description for this version.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_application_version
elasticbeanstalk_update_application_version <- function(ApplicationName, VersionLabel, Description = NULL) {
  op <- new_operation(
    name = "UpdateApplicationVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_application_version_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, Description = Description)
  output <- .elasticbeanstalk$update_application_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_application_version <- elasticbeanstalk_update_application_version

#' Updates the specified configuration template to have the specified
#' properties or configuration option values
#'
#' @description
#' Updates the specified configuration template to have the specified properties or configuration option values.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_configuration_template/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_configuration_template/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application associated with the configuration template
#' to update.
#' 
#' If no application is found with this name,
#' [`update_configuration_template`][elasticbeanstalk_update_configuration_template]
#' returns an `InvalidParameterValue` error.
#' @param TemplateName &#91;required&#93; The name of the configuration template to update.
#' 
#' If no configuration template is found with this name,
#' [`update_configuration_template`][elasticbeanstalk_update_configuration_template]
#' returns an `InvalidParameterValue` error.
#' @param Description A new description for the configuration.
#' @param OptionSettings A list of configuration option settings to update with the new specified
#' option value.
#' @param OptionsToRemove A list of configuration options to remove from the configuration set.
#' 
#' Constraint: You can remove only `UserDefined` configuration options.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_configuration_template
elasticbeanstalk_update_configuration_template <- function(ApplicationName, TemplateName, Description = NULL, OptionSettings = NULL, OptionsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateConfigurationTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_configuration_template_input(ApplicationName = ApplicationName, TemplateName = TemplateName, Description = Description, OptionSettings = OptionSettings, OptionsToRemove = OptionsToRemove)
  output <- .elasticbeanstalk$update_configuration_template_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_configuration_template <- elasticbeanstalk_update_configuration_template

#' Updates the environment description, deploys a new application version,
#' updates the configuration settings to an entirely new configuration
#' template, or updates select configuration option values in the running
#' environment
#'
#' @description
#' Updates the environment description, deploys a new application version, updates the configuration settings to an entirely new configuration template, or updates select configuration option values in the running environment.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_environment/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_environment/) for full documentation.
#'
#' @param ApplicationName The name of the application with which the environment is associated.
#' @param EnvironmentId The ID of the environment to update.
#' 
#' If no environment with this ID exists, AWS Elastic Beanstalk returns an
#' `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to update. If no environment with this name
#' exists, AWS Elastic Beanstalk returns an `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param GroupName The name of the group to which the target environment belongs. Specify a
#' group name only if the environment's name is specified in an environment
#' manifest and not with the environment name or environment ID parameters.
#' See [Environment Manifest
#' (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
#' for details.
#' @param Description If this parameter is specified, AWS Elastic Beanstalk updates the
#' description of this environment.
#' @param Tier This specifies the tier to use to update the environment.
#' 
#' Condition: At this time, if you change the tier version, name, or type,
#' AWS Elastic Beanstalk returns `InvalidParameterValue` error.
#' @param VersionLabel If this parameter is specified, AWS Elastic Beanstalk deploys the named
#' application version to the environment. If no such application version
#' is found, returns an `InvalidParameterValue` error.
#' @param TemplateName If this parameter is specified, AWS Elastic Beanstalk deploys this
#' configuration template to the environment. If no such configuration
#' template is found, AWS Elastic Beanstalk returns an
#' `InvalidParameterValue` error.
#' @param SolutionStackName This specifies the platform version that the environment will run after
#' the environment is updated.
#' @param PlatformArn The ARN of the platform, if used.
#' @param OptionSettings If specified, AWS Elastic Beanstalk updates the configuration set
#' associated with the running environment and sets the specified
#' configuration options to the requested value.
#' @param OptionsToRemove A list of custom user-defined configuration options to remove from the
#' configuration set for this environment.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_environment
elasticbeanstalk_update_environment <- function(ApplicationName = NULL, EnvironmentId = NULL, EnvironmentName = NULL, GroupName = NULL, Description = NULL, Tier = NULL, VersionLabel = NULL, TemplateName = NULL, SolutionStackName = NULL, PlatformArn = NULL, OptionSettings = NULL, OptionsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateEnvironment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_environment_input(ApplicationName = ApplicationName, EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, GroupName = GroupName, Description = Description, Tier = Tier, VersionLabel = VersionLabel, TemplateName = TemplateName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, OptionSettings = OptionSettings, OptionsToRemove = OptionsToRemove)
  output <- .elasticbeanstalk$update_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_environment <- elasticbeanstalk_update_environment

#' Update the list of tags applied to an AWS Elastic Beanstalk resource
#'
#' @description
#' Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed: `TagsToAdd` for tags to add or update, and `TagsToRemove`.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_tags_for_resource/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_update_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resouce to be updated.
#' 
#' Must be the ARN of an Elastic Beanstalk resource.
#' @param TagsToAdd A list of tags to add or update. If a key of an existing tag is added,
#' the tag's value is updated.
#' 
#' Specify at least one of these parameters: `TagsToAdd`, `TagsToRemove`.
#' @param TagsToRemove A list of tag keys to remove. If a tag key doesn't exist, it is silently
#' ignored.
#' 
#' Specify at least one of these parameters: `TagsToAdd`, `TagsToRemove`.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_tags_for_resource
elasticbeanstalk_update_tags_for_resource <- function(ResourceArn, TagsToAdd = NULL, TagsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_tags_for_resource_input(ResourceArn = ResourceArn, TagsToAdd = TagsToAdd, TagsToRemove = TagsToRemove)
  output <- .elasticbeanstalk$update_tags_for_resource_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_tags_for_resource <- elasticbeanstalk_update_tags_for_resource

#' Takes a set of configuration settings and either a configuration
#' template or environment, and determines whether those values are valid
#'
#' @description
#' Takes a set of configuration settings and either a configuration template or environment, and determines whether those values are valid.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticbeanstalk_validate_configuration_settings/](https://www.paws-r-sdk.com/docs/elasticbeanstalk_validate_configuration_settings/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application that the configuration template or
#' environment belongs to.
#' @param TemplateName The name of the configuration template to validate the settings against.
#' 
#' Condition: You cannot specify both this and an environment name.
#' @param EnvironmentName The name of the environment to validate the settings against.
#' 
#' Condition: You cannot specify both this and a configuration template
#' name.
#' @param OptionSettings &#91;required&#93; A list of the options and desired values to evaluate.
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_validate_configuration_settings
elasticbeanstalk_validate_configuration_settings <- function(ApplicationName, TemplateName = NULL, EnvironmentName = NULL, OptionSettings) {
  op <- new_operation(
    name = "ValidateConfigurationSettings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticbeanstalk$validate_configuration_settings_input(ApplicationName = ApplicationName, TemplateName = TemplateName, EnvironmentName = EnvironmentName, OptionSettings = OptionSettings)
  output <- .elasticbeanstalk$validate_configuration_settings_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$validate_configuration_settings <- elasticbeanstalk_validate_configuration_settings
