% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_copy_fpga_image}
\alias{ec2_copy_fpga_image}
\title{Copies the specified Amazon FPGA Image (AFI) to the current Region}
\usage{
ec2_copy_fpga_image(
  DryRun = NULL,
  SourceFpgaImageId,
  Description = NULL,
  Name = NULL,
  SourceRegion,
  ClientToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SourceFpgaImageId}{[required] The ID of the source AFI.}

\item{Description}{The description for the new AFI.}

\item{Name}{The name for the new AFI. The default is the name of the source AFI.}

\item{SourceRegion}{[required] The Region that contains the source AFI.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}
}
\description{
Copies the specified Amazon FPGA Image (AFI) to the current Region.

See \url{https://www.paws-r-sdk.com/docs/ec2_copy_fpga_image/} for full documentation.
}
\keyword{internal}
