% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_ipam_byoasn}
\alias{ec2_describe_ipam_byoasn}
\title{Describes your Autonomous System Numbers (ASNs), their provisioning
statuses, and the BYOIP CIDRs with which they are associated}
\usage{
ec2_describe_ipam_byoasn(DryRun = NULL, MaxResults = NULL, NextToken = NULL)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Describes your Autonomous System Numbers (ASNs), their provisioning statuses, and the BYOIP CIDRs with which they are associated. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html}{Tutorial: Bring your ASN to IPAM} in the \emph{Amazon VPC IPAM guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_ipam_byoasn/} for full documentation.
}
\keyword{internal}
