% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_verified_access_trust_provider}
\alias{ec2_modify_verified_access_trust_provider}
\title{Modifies the configuration of the specified Amazon Web Services Verified
Access trust provider}
\usage{
ec2_modify_verified_access_trust_provider(
  VerifiedAccessTrustProviderId,
  OidcOptions = NULL,
  DeviceOptions = NULL,
  Description = NULL,
  DryRun = NULL,
  ClientToken = NULL,
  SseSpecification = NULL
)
}
\arguments{
\item{VerifiedAccessTrustProviderId}{[required] The ID of the Verified Access trust provider.}

\item{OidcOptions}{The options for an OpenID Connect-compatible user-identity trust
provider.}

\item{DeviceOptions}{The options for a device-based trust provider. This parameter is
required when the provider type is \code{device}.}

\item{Description}{A description for the Verified Access trust provider.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{A unique, case-sensitive token that you provide to ensure idempotency of
your modification request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{SseSpecification}{The options for server side encryption.}
}
\description{
Modifies the configuration of the specified Amazon Web Services Verified Access trust provider.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_verified_access_trust_provider/} for full documentation.
}
\keyword{internal}
