% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_credit_specification}
\alias{ec2_modify_instance_credit_specification}
\title{Modifies the credit option for CPU usage on a running or stopped
burstable performance instance}
\usage{
ec2_modify_instance_credit_specification(
  DryRun = NULL,
  ClientToken = NULL,
  InstanceCreditSpecifications
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{A unique, case-sensitive token that you provide to ensure idempotency of
your modification request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{InstanceCreditSpecifications}{[required] Information about the credit option for CPU usage.}
}
\description{
Modifies the credit option for CPU usage on a running or stopped burstable performance instance. The credit options are \code{standard} and \code{unlimited}.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_instance_credit_specification/} for full documentation.
}
\keyword{internal}
