% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_update_pod_identity_association}
\alias{eks_update_pod_identity_association}
\title{Updates a EKS Pod Identity association}
\usage{
eks_update_pod_identity_association(
  clusterName,
  associationId,
  roleArn = NULL,
  clientRequestToken = NULL
)
}
\arguments{
\item{clusterName}{[required] The name of the cluster that you want to update the association in.}

\item{associationId}{[required] The ID of the association to be updated.}

\item{roleArn}{The new IAM role to change the}

\item{clientRequestToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\description{
Updates a EKS Pod Identity association. Only the IAM role can be changed; an association can't be moved between clusters, namespaces, or service accounts. If you need to edit the namespace or service account, you need to delete the association and then create a new association with your desired settings.

See \url{https://www.paws-r-sdk.com/docs/eks_update_pod_identity_association/} for full documentation.
}
\keyword{internal}
