% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_verified_access_group}
\alias{ec2_create_verified_access_group}
\title{An Amazon Web Services Verified Access group is a collection of Amazon
Web Services Verified Access endpoints who's associated applications
have similar security requirements}
\usage{
ec2_create_verified_access_group(
  VerifiedAccessInstanceId,
  Description = NULL,
  PolicyDocument = NULL,
  TagSpecifications = NULL,
  ClientToken = NULL,
  DryRun = NULL,
  SseSpecification = NULL
)
}
\arguments{
\item{VerifiedAccessInstanceId}{[required] The ID of the Verified Access instance.}

\item{Description}{A description for the Verified Access group.}

\item{PolicyDocument}{The Verified Access policy document.}

\item{TagSpecifications}{The tags to assign to the Verified Access group.}

\item{ClientToken}{A unique, case-sensitive token that you provide to ensure idempotency of
your modification request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SseSpecification}{The options for server side encryption.}
}
\description{
An Amazon Web Services Verified Access group is a collection of Amazon Web Services Verified Access endpoints who's associated applications have similar security requirements. Each instance within a Verified Access group shares an Verified Access policy. For example, you can group all Verified Access instances associated with "sales" applications together and use one common Verified Access policy.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_verified_access_group/} for full documentation.
}
\keyword{internal}
