% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_launch_template}
\alias{ec2_modify_launch_template}
\title{Modifies a launch template}
\usage{
ec2_modify_launch_template(
  DryRun = NULL,
  ClientToken = NULL,
  LaunchTemplateId = NULL,
  LaunchTemplateName = NULL,
  DefaultVersion = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring idempotency}.

Constraint: Maximum 128 ASCII characters.}

\item{LaunchTemplateId}{The ID of the launch template.

You must specify either the \code{LaunchTemplateId} or the
\code{LaunchTemplateName}, but not both.}

\item{LaunchTemplateName}{The name of the launch template.

You must specify either the \code{LaunchTemplateName} or the
\code{LaunchTemplateId}, but not both.}

\item{DefaultVersion}{The version number of the launch template to set as the default version.}
}
\description{
Modifies a launch template. You can specify which version of the launch template to set as the default version. When launching an instance, the default version applies when a launch template version is not specified.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_launch_template/} for full documentation.
}
\keyword{internal}
