% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_snapshot_attribute}
\alias{ec2_modify_snapshot_attribute}
\title{Adds or removes permission settings for the specified snapshot}
\usage{
ec2_modify_snapshot_attribute(
  Attribute = NULL,
  CreateVolumePermission = NULL,
  GroupNames = NULL,
  OperationType = NULL,
  SnapshotId,
  UserIds = NULL,
  DryRun = NULL
)
}
\arguments{
\item{Attribute}{The snapshot attribute to modify. Only volume creation permissions can
be modified.}

\item{CreateVolumePermission}{A JSON representation of the snapshot attribute modification.}

\item{GroupNames}{The group to modify for the snapshot.}

\item{OperationType}{The type of operation to perform to the attribute.}

\item{SnapshotId}{[required] The ID of the snapshot.}

\item{UserIds}{The account ID to modify for the snapshot.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Adds or removes permission settings for the specified snapshot. You may add or remove specified Amazon Web Services account IDs from a snapshot's list of create volume permissions, but you cannot do both in a single operation. If you need to both add and remove account IDs for a snapshot, you must use multiple operations. You can make up to 500 modifications to a snapshot in a single operation.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_snapshot_attribute/} for full documentation.
}
\keyword{internal}
