% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_create_environment_template}
\alias{proton_create_environment_template}
\title{Create an environment template for Proton}
\usage{
proton_create_environment_template(
  description = NULL,
  displayName = NULL,
  encryptionKey = NULL,
  name,
  provisioning = NULL,
  tags = NULL
)
}
\arguments{
\item{description}{A description of the environment template.}

\item{displayName}{The environment template name as displayed in the developer interface.}

\item{encryptionKey}{A customer provided encryption key that Proton uses to encrypt data.}

\item{name}{[required] The name of the environment template.}

\item{provisioning}{When included, indicates that the environment template is for customer
provisioned and managed infrastructure.}

\item{tags}{An optional list of metadata items that you can associate with the
Proton environment template. A tag is a key-value pair.

For more information, see \emph{Proton resources and tagging} in the \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton Administrator Guide}
or \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton User Guide}.}
}
\description{
Create an environment template for Proton. For more information, see \href{https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html}{Environment Templates} in the \emph{Proton Administrator Guide}.

See \url{https://paws-r.github.io/docs/proton/create_environment_template.html} for full documentation.
}
\keyword{internal}
