% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_private_dns_name_options}
\alias{ec2_modify_private_dns_name_options}
\title{Modifies the options for instance hostnames for the specified instance}
\usage{
ec2_modify_private_dns_name_options(
  DryRun = NULL,
  InstanceId = NULL,
  PrivateDnsHostnameType = NULL,
  EnableResourceNameDnsARecord = NULL,
  EnableResourceNameDnsAAAARecord = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceId}{The ID of the instance.}

\item{PrivateDnsHostnameType}{The type of hostname for EC2 instances. For IPv4 only subnets, an
instance DNS name must be based on the instance IPv4 address. For IPv6
only subnets, an instance DNS name must be based on the instance ID. For
dual-stack subnets, you can specify whether DNS names use the instance
IPv4 address or the instance ID.}

\item{EnableResourceNameDnsARecord}{Indicates whether to respond to DNS queries for instance hostnames with
DNS A records.}

\item{EnableResourceNameDnsAAAARecord}{Indicates whether to respond to DNS queries for instance hostnames with
DNS AAAA records.}
}
\description{
Modifies the options for instance hostnames for the specified instance.

See \url{https://paws-r.github.io/docs/ec2/modify_private_dns_name_options.html} for full documentation.
}
\keyword{internal}
