% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_maintenance_options}
\alias{ec2_modify_instance_maintenance_options}
\title{Modifies the recovery behavior of your instance to disable simplified
automatic recovery or set the recovery behavior to default}
\usage{
ec2_modify_instance_maintenance_options(
  InstanceId,
  AutoRecovery = NULL,
  DryRun = NULL
)
}
\arguments{
\item{InstanceId}{[required] The ID of the instance.}

\item{AutoRecovery}{Disables the automatic recovery behavior of your instance or sets it to
default.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies the recovery behavior of your instance to disable simplified automatic recovery or set the recovery behavior to default. The default configuration will not enable simplified automatic recovery for an unsupported instance type. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery}{Simplified automatic recovery}.

See \url{https://paws-r.github.io/docs/ec2/modify_instance_maintenance_options.html} for full documentation.
}
\keyword{internal}
