% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_traffic_mirror_target}
\alias{ec2_create_traffic_mirror_target}
\title{Creates a target for your Traffic Mirror session}
\usage{
ec2_create_traffic_mirror_target(
  NetworkInterfaceId = NULL,
  NetworkLoadBalancerArn = NULL,
  Description = NULL,
  TagSpecifications = NULL,
  DryRun = NULL,
  ClientToken = NULL,
  GatewayLoadBalancerEndpointId = NULL
)
}
\arguments{
\item{NetworkInterfaceId}{The network interface ID that is associated with the target.}

\item{NetworkLoadBalancerArn}{The Amazon Resource Name (ARN) of the Network Load Balancer that is
associated with the target.}

\item{Description}{The description of the Traffic Mirror target.}

\item{TagSpecifications}{The tags to assign to the Traffic Mirror target.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to ensure idempotency}.}

\item{GatewayLoadBalancerEndpointId}{The ID of the Gateway Load Balancer endpoint.}
}
\description{
Creates a target for your Traffic Mirror session.

See \url{https://paws-r.github.io/docs/ec2/create_traffic_mirror_target.html} for full documentation.
}
\keyword{internal}
