% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apprunner_operations.R
\name{apprunner_create_auto_scaling_configuration}
\alias{apprunner_create_auto_scaling_configuration}
\title{Create an App Runner automatic scaling configuration resource}
\usage{
apprunner_create_auto_scaling_configuration(
  AutoScalingConfigurationName,
  MaxConcurrency = NULL,
  MinSize = NULL,
  MaxSize = NULL,
  Tags = NULL
)
}
\arguments{
\item{AutoScalingConfigurationName}{[required] A name for the auto scaling configuration. When you use it for the first
time in an Amazon Web Services Region, App Runner creates revision
number \code{1} of this name. When you use the same name in subsequent calls,
App Runner creates incremental revisions of the configuration.

The name \code{DefaultConfiguration} is reserved (it's the configuration that
App Runner uses if you don't provide a custome one). You can't use it to
create a new auto scaling configuration, and you can't create a revision
of it.

When you want to use your own auto scaling configuration for your App
Runner service, \emph{create a configuration with a different name}, and then
provide it when you create or update your service.}

\item{MaxConcurrency}{The maximum number of concurrent requests that you want an instance to
process. If the number of concurrent requests exceeds this limit, App
Runner scales up your service.

Default: \code{100}}

\item{MinSize}{The minimum number of instances that App Runner provisions for your
service. The service always has at least \code{MinSize} provisioned
instances. Some of them actively serve traffic. The rest of them
(provisioned and inactive instances) are a cost-effective compute
capacity reserve and are ready to be quickly activated. You pay for
memory usage of all the provisioned instances. You pay for CPU usage of
only the active subset.

App Runner temporarily doubles the number of provisioned instances
during deployments, to maintain the same capacity for both old and new
code.

Default: \code{1}}

\item{MaxSize}{The maximum number of instances that your service scales up to. At most
\code{MaxSize} instances actively serve traffic for your service.

Default: \code{25}}

\item{Tags}{A list of metadata items that you can associate with your auto scaling
configuration resource. A tag is a key-value pair.}
}
\description{
Create an App Runner automatic scaling configuration resource. App Runner requires this resource when you create or update App Runner services and you require non-default auto scaling settings. You can share an auto scaling configuration across multiple services.

See \url{https://paws-r.github.io/docs/apprunner/create_auto_scaling_configuration.html} for full documentation.
}
\keyword{internal}
