% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apprunner_operations.R
\name{apprunner_associate_custom_domain}
\alias{apprunner_associate_custom_domain}
\title{Associate your own domain name with the App Runner subdomain URL of your
App Runner service}
\usage{
apprunner_associate_custom_domain(
  ServiceArn,
  DomainName,
  EnableWWWSubdomain = NULL
)
}
\arguments{
\item{ServiceArn}{[required] The Amazon Resource Name (ARN) of the App Runner service that you want
to associate a custom domain name with.}

\item{DomainName}{[required] A custom domain endpoint to associate. Specify a root domain (for
example, \code{example.com}), a subdomain (for example, \code{login.example.com}
or \code{admin.login.example.com}), or a wildcard (for example,
\verb{*.example.com}).}

\item{EnableWWWSubdomain}{Set to \code{true} to associate the subdomain \code{www.DomainName } with the App
Runner service in addition to the base domain.

Default: \code{true}}
}
\description{
Associate your own domain name with the App Runner subdomain URL of your App Runner service.

See \url{https://paws-r.github.io/docs/apprunner/associate_custom_domain.html} for full documentation.
}
\keyword{internal}
