% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_create_component}
\alias{proton_create_component}
\title{Create an Proton component}
\usage{
proton_create_component(
  description = NULL,
  environmentName = NULL,
  manifest,
  name,
  serviceInstanceName = NULL,
  serviceName = NULL,
  serviceSpec = NULL,
  tags = NULL,
  templateFile
)
}
\arguments{
\item{description}{An optional customer-provided description of the component.}

\item{environmentName}{The name of the Proton environment that you want to associate this
component with. You must specify this when you don't specify
\code{serviceInstanceName} and \code{serviceName}.}

\item{manifest}{[required] A path to a manifest file that lists the Infrastructure as Code (IaC)
file, template language, and rendering engine for infrastructure that a
custom component provisions.}

\item{name}{[required] The customer-provided name of the component.}

\item{serviceInstanceName}{The name of the service instance that you want to attach this component
to. If you don't specify this, the component isn't attached to any
service instance. Specify both \code{serviceInstanceName} and \code{serviceName}
or neither of them.}

\item{serviceName}{The name of the service that \code{serviceInstanceName} is associated with.
If you don't specify this, the component isn't attached to any service
instance. Specify both \code{serviceInstanceName} and \code{serviceName} or
neither of them.}

\item{serviceSpec}{The service spec that you want the component to use to access service
inputs. Set this only when you attach the component to a service
instance.}

\item{tags}{An optional list of metadata items that you can associate with the
Proton component. A tag is a key-value pair.

For more information, see \emph{Proton resources and tagging} in the \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton Administrator Guide}
or \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton User Guide}.}

\item{templateFile}{[required] A path to the Infrastructure as Code (IaC) file describing
infrastructure that a custom component provisions.

Components support a single IaC file, even if you use Terraform as your
template language.}
}
\description{
Create an Proton component. A component is an infrastructure extension for a service instance.

See \url{https://paws-r.github.io/docs/proton/create_component.html} for full documentation.
}
\keyword{internal}
