% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_validate_configuration_settings}
\alias{elasticbeanstalk_validate_configuration_settings}
\title{Takes a set of configuration settings and either a configuration
template or environment, and determines whether those values are valid}
\usage{
elasticbeanstalk_validate_configuration_settings(
  ApplicationName,
  TemplateName = NULL,
  EnvironmentName = NULL,
  OptionSettings
)
}
\arguments{
\item{ApplicationName}{[required] The name of the application that the configuration template or
environment belongs to.}

\item{TemplateName}{The name of the configuration template to validate the settings against.

Condition: You cannot specify both this and an environment name.}

\item{EnvironmentName}{The name of the environment to validate the settings against.

Condition: You cannot specify both this and a configuration template
name.}

\item{OptionSettings}{[required] A list of the options and desired values to evaluate.}
}
\description{
Takes a set of configuration settings and either a configuration template or environment, and determines whether those values are valid.

See \url{https://paws-r.github.io/docs/elasticbeanstalk/validate_configuration_settings.html} for full documentation.
}
\keyword{internal}
