% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_describe_configuration_settings}
\alias{elasticbeanstalk_describe_configuration_settings}
\title{Returns a description of the settings for the specified configuration
set, that is, either a configuration template or the configuration set
associated with a running environment}
\usage{
elasticbeanstalk_describe_configuration_settings(
  ApplicationName,
  TemplateName = NULL,
  EnvironmentName = NULL
)
}
\arguments{
\item{ApplicationName}{[required] The application for the environment or configuration template.}

\item{TemplateName}{The name of the configuration template to describe.

Conditional: You must specify either this parameter or an
EnvironmentName, but not both. If you specify both, AWS Elastic
Beanstalk returns an \code{InvalidParameterCombination} error. If you do not
specify either, AWS Elastic Beanstalk returns a
\code{MissingRequiredParameter} error.}

\item{EnvironmentName}{The name of the environment to describe.

Condition: You must specify either this or a TemplateName, but not both.
If you specify both, AWS Elastic Beanstalk returns an
\code{InvalidParameterCombination} error. If you do not specify either, AWS
Elastic Beanstalk returns \code{MissingRequiredParameter} error.}
}
\description{
Returns a description of the settings for the specified configuration set, that is, either a configuration template or the configuration set associated with a running environment.

See \url{https://paws-r.github.io/docs/elasticbeanstalk/describe_configuration_settings.html} for full documentation.
}
\keyword{internal}
