% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_volume_status}
\alias{ec2_describe_volume_status}
\title{Describes the status of the specified volumes}
\usage{
ec2_describe_volume_status(
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  VolumeIds = NULL,
  DryRun = NULL
)
}
\arguments{
\item{Filters}{The filters.
\itemize{
\item \code{action.code} - The action code for the event (for example,
\code{enable-volume-io}).
\item \code{action.description} - A description of the action.
\item \code{action.event-id} - The event ID associated with the action.
\item \code{availability-zone} - The Availability Zone of the instance.
\item \code{event.description} - A description of the event.
\item \code{event.event-id} - The event ID.
\item \code{event.event-type} - The event type (for \code{io-enabled}: \code{passed} |
\code{failed}; for \code{io-performance}: \code{io-performance:degraded} |
\code{io-performance:severely-degraded} | \code{io-performance:stalled}).
\item \code{event.not-after} - The latest end time for the event.
\item \code{event.not-before} - The earliest start time for the event.
\item \code{volume-status.details-name} - The cause for \code{volume-status.status}
(\code{io-enabled} | \code{io-performance}).
\item \code{volume-status.details-status} - The status of
\code{volume-status.details-name} (for \code{io-enabled}: \code{passed} | \code{failed};
for \code{io-performance}: \code{normal} | \code{degraded} | \code{severely-degraded} |
\code{stalled}).
\item \code{volume-status.status} - The status of the volume (\code{ok} | \code{impaired}
| \code{warning} | \code{insufficient-data}).
}}

\item{MaxResults}{The maximum number of volume results returned by
\code{\link[=ec2_describe_volume_status]{describe_volume_status}} in paginated
output. When this parameter is used, the request only returns
\code{MaxResults} results in a single page along with a \code{NextToken} response
element. The remaining results of the initial request can be seen by
sending another request with the returned \code{NextToken} value. This value
can be between 5 and 1,000; if \code{MaxResults} is given a value larger than
1,000, only 1,000 results are returned. If this parameter is not used,
then \code{\link[=ec2_describe_volume_status]{describe_volume_status}} returns all
results. You cannot specify this parameter and the volume IDs parameter
in the same request.}

\item{NextToken}{The \code{NextToken} value to include in a future
\code{\link[=ec2_describe_volume_status]{describe_volume_status}} request. When the
results of the request exceed \code{MaxResults}, this value can be used to
retrieve the next page of results. This value is \code{null} when there are
no more results to return.}

\item{VolumeIds}{The IDs of the volumes.

Default: Describes all your volumes.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the status of the specified volumes. Volume status provides the result of the checks performed on your volumes to determine events that can impair the performance of your volumes. The performance of a volume can be affected if an issue occurs on the volume's underlying host. If the volume's underlying host experiences a power outage or system issue, after the system is restored, there could be data inconsistencies on the volume. Volume events notify you if this occurs. Volume actions notify you if any action needs to be taken in response to the event.

See \url{https://paws-r.github.io/docs/ec2/describe_volume_status.html} for full documentation.
}
\keyword{internal}
