% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apprunner_operations.R
\name{apprunner_list_observability_configurations}
\alias{apprunner_list_observability_configurations}
\title{Returns a list of active App Runner observability configurations in your
Amazon Web Services account}
\usage{
apprunner_list_observability_configurations(
  ObservabilityConfigurationName = NULL,
  LatestOnly = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ObservabilityConfigurationName}{The name of the App Runner observability configuration that you want to
list. If specified, App Runner lists revisions that share this name. If
not specified, App Runner returns revisions of all active
configurations.}

\item{LatestOnly}{Set to \code{true} to list only the latest revision for each requested
configuration name.

Set to \code{false} to list all revisions for each requested configuration
name.

Default: \code{true}}

\item{MaxResults}{The maximum number of results to include in each response (result page).
It's used for a paginated request.

If you don't specify \code{MaxResults}, the request retrieves all available
results in a single response.}

\item{NextToken}{A token from a previous result page. It's used for a paginated request.
The request retrieves the next result page. All other parameter values
must be identical to the ones that are specified in the initial request.

If you don't specify \code{NextToken}, the request retrieves the first result
page.}
}
\description{
Returns a list of active App Runner observability configurations in your Amazon Web Services account. You can query the revisions for a specific configuration name or the revisions for all active configurations in your account. You can optionally query only the latest revision of each requested name.

See \url{https://paws-r.github.io/docs/apprunner/list_observability_configurations.html} for full documentation.
}
\keyword{internal}
