% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_traffic_mirror_sessions}
\alias{ec2_describe_traffic_mirror_sessions}
\title{Describes one or more Traffic Mirror sessions}
\usage{
ec2_describe_traffic_mirror_sessions(TrafficMirrorSessionIds, DryRun,
  Filters, MaxResults, NextToken)
}
\arguments{
\item{TrafficMirrorSessionIds}{The ID of the Traffic Mirror session.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{One or more filters. The possible values are:
\itemize{
\item \code{description}: The Traffic Mirror session description.
\item \code{network-interface-id}: The ID of the Traffic Mirror session network
interface.
\item \code{owner-id}: The ID of the account that owns the Traffic Mirror
session.
\item \code{packet-length}: The assigned number of packets to mirror.
\item \code{session-number}: The assigned session number.
\item \code{traffic-mirror-filter-id}: The ID of the Traffic Mirror filter.
\item \code{traffic-mirror-session-id}: The ID of the Traffic Mirror session.
\item \code{traffic-mirror-target-id}: The ID of the Traffic Mirror target.
\item \code{virtual-network-id}: The virtual network ID of the Traffic Mirror
session.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Describes one or more Traffic Mirror sessions. By default, all Traffic
Mirror sessions are described. Alternatively, you can filter the
results.
}
\section{Request syntax}{
\preformatted{svc$describe_traffic_mirror_sessions(
  TrafficMirrorSessionIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE,
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
