% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_host_reservations}
\alias{ec2_describe_host_reservations}
\title{Describes reservations that are associated with Dedicated Hosts in your
account}
\usage{
ec2_describe_host_reservations(Filter, HostReservationIdSet, MaxResults,
  NextToken)
}
\arguments{
\item{Filter}{The filters.
\itemize{
\item \code{instance-family} - The instance family (for example, \code{m4}).
\item \code{payment-option} - The payment option (\code{NoUpfront} \\|
\code{PartialUpfront} \\| \code{AllUpfront}).
\item \code{state} - The state of the reservation (\code{payment-pending} \\|
\code{payment-failed} \\| \code{active} \\| \code{retired}).
\item \code{tag}:\\<key\\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}}

\item{HostReservationIdSet}{The host reservation IDs.}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the returned \code{nextToken} value. This value can be between 5 and 500. If
\code{maxResults} is given a larger value than 500, you receive an error.}

\item{NextToken}{The token to use to retrieve the next page of results.}
}
\description{
Describes reservations that are associated with Dedicated Hosts in your
account.
}
\section{Request syntax}{
\preformatted{svc$describe_host_reservations(
  Filter = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  HostReservationIdSet = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
