% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_describe_job_definitions}
\alias{batch_describe_job_definitions}
\title{Describes a list of job definitions}
\usage{
batch_describe_job_definitions(jobDefinitions, maxResults,
  jobDefinitionName, status, nextToken)
}
\arguments{
\item{jobDefinitions}{A list of up to 100 job definition names or full Amazon Resource Name
(ARN) entries.}

\item{maxResults}{The maximum number of results returned by \code{DescribeJobDefinitions} in
paginated output. When this parameter is used, \code{DescribeJobDefinitions}
only returns \code{maxResults} results in a single page along with a
\code{nextToken} response element. The remaining results of the initial
request can be seen by sending another \code{DescribeJobDefinitions} request
with the returned \code{nextToken} value. This value can be between 1 and
100. If this parameter is not used, then \code{DescribeJobDefinitions}
returns up to 100 results and a \code{nextToken} value if applicable.}

\item{jobDefinitionName}{The name of the job definition to describe.}

\item{status}{The status with which to filter job definitions.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{DescribeJobDefinitions} request where \code{maxResults} was used and the
results exceeded the value of that parameter. Pagination continues from
the end of the previous results that returned the \code{nextToken} value.
This value is \code{null} when there are no more results to return.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}
}
\description{
Describes a list of job definitions. You can specify a \code{status} (such as
\code{ACTIVE}) to only return job definitions that match that status.
}
\section{Request syntax}{
\preformatted{svc$describe_job_definitions(
  jobDefinitions = list(
    "string"
  ),
  maxResults = 123,
  jobDefinitionName = "string",
  status = "string",
  nextToken = "string"
)
}
}

\examples{
\dontrun{
# This example describes all of your active job definitions.
svc$describe_job_definitions(
  status = "ACTIVE"
)
}

}
\keyword{internal}
