% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_swap_environment_cnam_es}
\alias{elasticbeanstalk_swap_environment_cnam_es}
\title{Swaps the CNAMEs of two environments}
\usage{
elasticbeanstalk_swap_environment_cnam_es(SourceEnvironmentId,
  SourceEnvironmentName, DestinationEnvironmentId,
  DestinationEnvironmentName)
}
\arguments{
\item{SourceEnvironmentId}{The ID of the source environment.

Condition: You must specify at least the \code{SourceEnvironmentID} or the
\code{SourceEnvironmentName}. You may also specify both. If you specify the
\code{SourceEnvironmentId}, you must specify the \code{DestinationEnvironmentId}.}

\item{SourceEnvironmentName}{The name of the source environment.

Condition: You must specify at least the \code{SourceEnvironmentID} or the
\code{SourceEnvironmentName}. You may also specify both. If you specify the
\code{SourceEnvironmentName}, you must specify the
\code{DestinationEnvironmentName}.}

\item{DestinationEnvironmentId}{The ID of the destination environment.

Condition: You must specify at least the \code{DestinationEnvironmentID} or
the \code{DestinationEnvironmentName}. You may also specify both. You must
specify the \code{SourceEnvironmentId} with the \code{DestinationEnvironmentId}.}

\item{DestinationEnvironmentName}{The name of the destination environment.

Condition: You must specify at least the \code{DestinationEnvironmentID} or
the \code{DestinationEnvironmentName}. You may also specify both. You must
specify the \code{SourceEnvironmentName} with the
\code{DestinationEnvironmentName}.}
}
\description{
Swaps the CNAMEs of two environments.
}
\section{Request syntax}{
\preformatted{svc$swap_environment_cnam_es(
  SourceEnvironmentId = "string",
  SourceEnvironmentName = "string",
  DestinationEnvironmentId = "string",
  DestinationEnvironmentName = "string"
)
}
}

\examples{
# The following operation swaps the assigned subdomains of two
# environments:
\dontrun{svc$swap_environment_cnam_es(
  DestinationEnvironmentName = "my-env-green",
  SourceEnvironmentName = "my-env-blue"
)}

}
\keyword{internal}
