% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_fpga_images}
\alias{ec2_describe_fpga_images}
\title{Describes the Amazon FPGA Images (AFIs) available to you}
\usage{
ec2_describe_fpga_images(DryRun, FpgaImageIds, Owners, Filters,
  NextToken, MaxResults)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{FpgaImageIds}{The AFI IDs.}

\item{Owners}{Filters the AFI by owner. Specify an AWS account ID, \code{self} (owner is
the sender of the request), or an AWS owner alias (valid values are
\code{amazon} \\| \code{aws-marketplace}).}

\item{Filters}{The filters.
\itemize{
\item \code{create-time} - The creation time of the AFI.
\item \code{fpga-image-id} - The FPGA image identifier (AFI ID).
\item \code{fpga-image-global-id} - The global FPGA image identifier (AGFI ID).
\item \code{name} - The name of the AFI.
\item \code{owner-id} - The AWS account ID of the AFI owner.
\item \code{product-code} - The product code.
\item \code{shell-version} - The version of the AWS Shell that was used to
create the bitstream.
\item \code{state} - The state of the AFI (\code{pending} \\| \code{failed} \\| \code{available}
\\| \code{unavailable}).
\item \code{tag}:\\<key\\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{update-time} - The time of the most recent update.
}}

\item{NextToken}{The token to retrieve the next page of results.}

\item{MaxResults}{The maximum number of results to return in a single call.}
}
\description{
Describes the Amazon FPGA Images (AFIs) available to you. These include
public AFIs, private AFIs that you own, and AFIs owned by other AWS
accounts for which you have load permissions.
}
\section{Request syntax}{
\preformatted{svc$describe_fpga_images(
  DryRun = TRUE|FALSE,
  FpgaImageIds = list(
    "string"
  ),
  Owners = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
